/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.base;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;

public final class DirectoryDependencyEndpointCollector
extends DependencyEndpointCollector {
    private final Map<ProgrammingElement, IDirectoryPath> m_lookupMap = new THashMap();

    public final void reset() {
        this.m_lookupMap.clear();
    }

    public void addDirectory(IDirectoryPath directory) {
        assert (directory != null) : "Parameter 'directory' of method 'addDirectory' must not be null";
        for (IComponent nextComponent : directory.getNamedElement().getChildren(IComponent.class)) {
            for (ProgrammingElement nextProgrammingElement : nextComponent.getNamedElement().getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                this.m_lookupMap.put(nextProgrammingElement, directory);
            }
        }
    }

    public Set<ProgrammingElement> getProgrammingElements(NamedElement forNamedElement) {
        assert (forNamedElement != null) : "Parameter 'forNamedElement' of method 'getProgrammingElements' must not be null";
        assert (forNamedElement != null && forNamedElement instanceof IDirectoryPath) : "Unexpected class in method 'getProgrammingElements': " + String.valueOf(forNamedElement);
        THashSet result = new THashSet();
        IDirectoryPath directory = (IDirectoryPath)((Object)forNamedElement);
        for (IComponent nextComponent : directory.getNamedElement().getChildren(IComponent.class)) {
            result.addAll(nextComponent.getNamedElement().getChildrenRecursively(ProgrammingElement.class, new Class[0]));
        }
        return result;
    }

    @Override
    public NamedElement getFirstCandidateForNodeAdapterLookUp(NamedElement element) {
        NamedElement parent;
        assert (element instanceof ProgrammingElement) : "Unexpected class: " + element.getClass().getName();
        while ((parent = element.getParent()) instanceof ProgrammingElement) {
            element = parent;
        }
        IDirectoryPath directory = this.m_lookupMap.get(element);
        return directory != null ? directory.getNamedElement() : null;
    }

    @Override
    public NamedElement getNextCandidateForNodeAdapterLookUp(NamedElement element) {
        return null;
    }
}

