/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecture;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controller.system.ArchitectureExtension;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IPhysicalArchitectureElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.Collection;
import java.util.List;

public final class MoveArchitectureElementsCommand
extends SoftwareSystemBasedCommand<IMoveInteraction> {
    public static final ICommandId ID = CoreCommandId.MOVE_ARCHITECTURE_ELEMENTS;

    public MoveArchitectureElementsCommand(ISoftwareSystemProvider provider, IMoveInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return ID;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        MoveCommandData data;
        IMoveInteraction moveInteraction = (IMoveInteraction)this.getInteraction();
        if (!moveInteraction.collectData(data = new MoveCommandData())) {
            return;
        }
        SoftwareSystem softwareSystem = this.getController().getSoftwareSystem();
        ArchitectureExtension architectureExtension = softwareSystem.getExtension(ArchitectureExtension.class);
        Collection<ArchitectureFile> applyingFiles = architectureExtension.getApplyingAndRequiringFiles(data.getElements());
        if (!moveInteraction.confirmSaveBeforeMove(data.getElements(), applyingFiles)) {
            return;
        }
        OperationResult result = architectureExtension.moveElements(workerContext, data.getElements(), data.getTargetDirectory());
        moveInteraction.processMoveResult(result);
    }

    public static interface IMoveInteraction
    extends ICommandInteraction {
        public boolean collectData(MoveCommandData var1);

        public void processMoveResult(OperationResult var1);

        public boolean confirmSaveBeforeMove(Collection<? extends IPhysicalArchitectureElement> var1, Collection<ArchitectureFile> var2);
    }

    public static class MoveCommandData {
        private List<? extends IPhysicalArchitectureElement> m_elements;
        private DirectoryPath m_targetDirectory;

        public List<? extends IPhysicalArchitectureElement> getElements() {
            return this.m_elements;
        }

        public void setElements(List<? extends IPhysicalArchitectureElement> elements) {
            this.m_elements = elements;
        }

        public DirectoryPath getTargetDirectory() {
            return this.m_targetDirectory;
        }

        public void setTargetDirectory(DirectoryPath targetDirectory) {
            this.m_targetDirectory = targetDirectory;
        }
    }
}

