/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.ModifiableFilesToBeProcessedData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionType;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.List;
import java.util.Map;

public final class SaveSoftwareSystemCommand
extends SoftwareSystemBasedCommand<ISaveInteraction> {
    private boolean m_canceled;

    public SaveSoftwareSystemCommand(ISoftwareSystemProvider provider, ISaveInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.SAVE_SOFTWARE_SYSTEM;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected TransactionType getTransactionType() {
        return TransactionType.SAVE;
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && !this.getController().getSoftwareSystem().getUniqueExistingChild(Files.class).modifiableFilesNeedSave()) {
            enabled.addErrorMessage("No modified files");
        }
        return enabled;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        ISoftwareSystemController controller = this.getController();
        SoftwareSystem softwareSystem = controller.getSoftwareSystem();
        Files files = softwareSystem.getUniqueExistingChild(Files.class);
        List<IModifiableFile> modifiableFilesNeedingSave = files.getModifiableFilesNeedingSave();
        if (!modifiableFilesNeedingSave.isEmpty()) {
            ModifiableFilesToBeSavedData modifiableFilesToBeSavedData = new ModifiableFilesToBeSavedData(files.getConflictStates(modifiableFilesNeedingSave));
            modifiableFilesToBeSavedData.setToBeSaved(modifiableFilesNeedingSave);
            if (!((ISaveInteraction)this.getInteraction()).collectSaveData(modifiableFilesToBeSavedData)) {
                this.m_canceled = true;
                return;
            }
            List<IModifiableFile> toBeSaved = modifiableFilesToBeSavedData.getToBeSaved();
            if (!toBeSaved.isEmpty()) {
                Map<IModifiableFile, IModificationOnSave> modificationsOnSave = ((ISaveInteraction)this.getInteraction()).aboutToSave(softwareSystem, toBeSaved);
                OperationResult result = controller.save(workerContext, modifiableFilesToBeSavedData.getToBeSaved(), modificationsOnSave);
                if (!((ISaveInteraction)this.getInteraction()).processSaveResult(result)) {
                    this.m_canceled = true;
                }
            }
        }
    }

    public boolean canceled() {
        return this.m_canceled;
    }

    public static interface ISaveInteraction
    extends ICommandInteraction {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public boolean collectSaveData(ModifiableFilesToBeSavedData var1);

        public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem var1, List<IModifiableFile> var2);

        default public boolean processSaveResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processSaveResult' must not be null";
            return true;
        }
    }

    public static final class ModifiableFilesToBeSavedData
    extends ModifiableFilesToBeProcessedData {
        public ModifiableFilesToBeSavedData(List<Pair<IModifiableFile, Files.ConflictState>> needingSave) {
            super(needingSave);
        }

        public List<IModifiableFile> getToBeSaved() {
            return this.getToBeProcessed();
        }

        public void setToBeSaved(List<IModifiableFile> toBeSaved) {
            this.setToBeProcessed(toBeSaved);
        }
    }
}

