/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;

public final class TypescriptNamespace
extends NamespaceFragment {
    public static final String NAMESPACE_FRAGMENT = "NamespaceFragment";
    public static final String NAMESPACE_FRAGMENT_PART = "NamespaceFragmentPart";
    private IModelServiceProvider m_msp;
    private int m_lineNumber;

    public TypescriptNamespace(NamedElement parent) {
        super(parent);
    }

    public TypescriptNamespace(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber) {
        super(msp, parent, name);
        assert (msp != null) : "Parameter 'msp' of method 'TypescriptNamespace' must not be null";
        this.m_lineNumber = lineNumber;
    }

    public String getFullyQualifiedNamePart() {
        return super.getFullyQualifiedNamePart() + "-" + Integer.toString(this.getLineNumber());
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public StructureItem getStructureItem() {
        return StructureItem.NAMESPACE;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_lineNumber);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_lineNumber = reader.readInt();
    }

    public String getSeparator() {
        return this.getLanguage().getNamespaceSeparator();
    }

    public NamedElement getParent() {
        return this.getParent(this.m_msp);
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitTypescriptNamespace(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitTypescriptNamespace(TypescriptNamespace var1);
    }
}

