/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptFunctionOrMethodKind;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TypescriptFunctionOrMethod
extends ProgrammingElementWithChildren
implements IRoutine {
    private int m_numberOfParameters;
    private boolean m_isAbstract;
    private TypescriptFunctionOrMethodKind m_kind;
    private String m_parameters;
    private String m_typeParameters;
    private String m_returnType;

    public TypescriptFunctionOrMethod(NamedElement parent) {
        super(parent);
    }

    public TypescriptFunctionOrMethod(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, int noParameters, boolean isAbstract, TypescriptFunctionOrMethodKind kind) {
        super(msp, parent, name, lineNumber);
        this.m_numberOfParameters = noParameters;
        this.m_isAbstract = isAbstract;
        this.m_kind = kind;
    }

    public String getImageResourceName() {
        String image = "Method";
        switch (this.m_kind) {
            case FUNCTION: {
                image = "Function";
            }
            case METHOD: {
                break;
            }
            case CONSTRUCTOR: {
                break;
            }
            case GETTER: {
                break;
            }
        }
        return image;
    }

    public boolean isStatic() {
        return false;
    }

    public String getShortName() {
        StringBuilder sb = new StringBuilder(this.getMethodName());
        if (this.m_typeParameters.length() > 0) {
            sb.append('<').append(this.getTypeParameters()).append('>');
        }
        sb.append('(').append(this.getParameters()).append(')');
        return sb.toString();
    }

    protected String getMethodName() {
        return super.getShortName();
    }

    public String getName() {
        NamedElement parent = this.getParent();
        if (parent instanceof SourceFile) {
            return this.getShortName();
        }
        return parent.getName() + "." + this.getShortName();
    }

    public String getRawPresentationName(boolean shortName) {
        NamedElement parent = this.getParent();
        if (parent instanceof SourceFile) {
            return this.getMethodName();
        }
        return shortName ? this.getMethodName() : parent.getRawPresentationName(false) + "." + this.getMethodName();
    }

    public String getFullyQualifiedNamePart() {
        return this.getMethodName() + "-" + Integer.toString(this.getLineNumber());
    }

    public TypescriptFunctionOrMethodKind getKind() {
        return this.m_kind;
    }

    @IntProperty
    public final int getNumberOfParameters() {
        return this.m_numberOfParameters;
    }

    @IntProperty
    public int getNumberOfStatements() {
        return -1;
    }

    @IntProperty
    public int getCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getExtendedCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getModifiedExtendedCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getModifiedCyclomaticComplexity() {
        return -1;
    }

    @IntProperty
    public int getMaxNesting() {
        return -1;
    }

    public List<String> getArgumentTypes() {
        String[] params = this.m_parameters.split(";");
        return Arrays.stream(params).map(p -> p.substring(p.lastIndexOf(58) + 1).trim()).collect(Collectors.toList());
    }

    public String getReturnType() {
        return this.m_returnType;
    }

    public int getNumberOfGenericTypeParameters() {
        if (this.m_typeParameters.length() == 0) {
            return 0;
        }
        return this.m_typeParameters.split(";").length;
    }

    public boolean isMember() {
        return true;
    }

    public String getParameters() {
        return this.m_parameters.replace(";", ", ");
    }

    public void setParameters(String parameters) {
        this.m_parameters = parameters;
    }

    public String getTypeParameters() {
        return this.m_typeParameters.replace(";", ", ");
    }

    public void setTypeParameters(String typeParameters) {
        this.m_typeParameters = typeParameters;
    }

    public void setReturnType(String returnType) {
        assert (returnType != null) : "Parameter 'returnType' of method 'setReturnType' must not be null";
        int pos = returnType.lastIndexOf(58);
        if (pos > 0) {
            returnType = returnType.substring(pos + 1).trim();
        }
        this.m_returnType = returnType;
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_numberOfParameters = reader.readInt();
        this.m_isAbstract = reader.readBoolean();
        String kind = reader.readString();
        this.m_kind = TypescriptFunctionOrMethodKind.valueOf(kind);
        this.m_parameters = reader.readString();
        this.m_typeParameters = reader.readString();
        this.m_returnType = reader.readString();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeInt(this.m_numberOfParameters);
        writer.writeBoolean(this.m_isAbstract);
        writer.writeString(this.m_kind.name());
        writer.writeString(this.m_parameters);
        writer.writeString(this.m_typeParameters);
        writer.writeString(this.m_returnType);
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitTypescriptMethod(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitTypescriptMethod(TypescriptFunctionOrMethod var1);
    }
}

