/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericRootDirectory;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.TsConfigFileHelper;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.settings.TypescriptConfigFile;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.settings.TypescriptSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.ITypescriptWorkspaceProvider;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.workspace.TypescriptModuleType;
import de.schlichtherle.truezip.file.TFile;

public final class TypescriptWorkspaceExtension
extends Extension
implements ITypescriptWorkspaceProvider {
    private final SoftwareSystem m_softwareSystem;

    public TypescriptWorkspaceExtension(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'TypescriptWorkspaceExtension' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    public void initTypescriptSoftwareSystem(OperationResult result, TFile tsConfigFile) {
        WorkspaceExtension wsExt = (WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class);
        OperationResultWithOutcome moduleResult = wsExt.createModule((IWorkerContext)DefaultWorkerContext.INSTANCE, (Module.IModuleType)TypescriptModuleType.TYPESCRIPT_MODULE, this.m_softwareSystem.getName(), "");
        if (moduleResult.isFailure()) {
            result.addMessagesFrom((OperationResult)moduleResult);
            return;
        }
        Workspace ws = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        TypescriptSystemSettings settings = (TypescriptSystemSettings)((Object)ws.getFirstChild(TypescriptSystemSettings.class));
        if (settings == null) {
            settings = new TypescriptSystemSettings((NamedElement)ws);
            ws.addChild((NamedElement)settings);
        }
        settings.removeChildren(new Class[]{TypescriptConfigFile.class});
        settings.addChild((NamedElement)new TypescriptConfigFile((NamedElement)settings, tsConfigFile));
        Module module = (Module)moduleResult.getOutcome();
        TFile rootDir = TsConfigFileHelper.extractRootDirectorFromTsConfig(result, tsConfigFile);
        GenericRootDirectory root = new GenericRootDirectory((IModelServiceProvider)this.m_softwareSystem, (NamedElement)module, rootDir.getNormalizedAbsoluteFile());
        module.addChild((NamedElement)root);
    }

    @Override
    public TFile getTsConfigFile() {
        return ((TypescriptConfigFile)((Object)((TypescriptSystemSettings)((Object)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueExistingChild(TypescriptSystemSettings.class))).getUniqueExistingChild(TypescriptConfigFile.class))).getFile();
    }
}

