/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.languageprovider.go.controller.settings.GoLocator;
import com.hello2morrow.sonargraph.languageprovider.go.model.system.IGoSettingsProvider;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoSettingsExtension
extends Extension
implements IGoSettingsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoSettingsExtension.class);
    private static final String SETTINGS_FILE_NAME = "GoSettings.properties";
    private static final String GO_PATH = "GO_PATH";
    private final TFile m_goSettingsDir;
    private final Properties m_settings = new Properties();

    public GoSettingsExtension(TFile goSettingsDir) {
        assert (goSettingsDir != null && goSettingsDir.isDirectory());
        this.m_goSettingsDir = goSettingsDir;
        TFile settingsFile = this.getSettingsFile();
        if (settingsFile.canRead()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader((File)settingsFile));){
                    this.m_settings.load(reader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot read Go settings file: ", (Throwable)e);
            }
        }
    }

    private TFile getSettingsFile() {
        return new TFile((File)this.m_goSettingsDir, SETTINGS_FILE_NAME);
    }

    @Override
    public void setGoFile(TFile goExeFile) {
        if (goExeFile == null) {
            this.m_settings.remove(GO_PATH);
        } else {
            this.m_settings.put(GO_PATH, goExeFile.getNormalizedAbsolutePath());
        }
        if (this.m_settings.isEmpty()) {
            try {
                this.getSettingsFile().rm();
            }
            catch (IOException iOException) {}
        } else {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter((File)this.getSettingsFile()));){
                    this.m_settings.store(writer, "Go Settings");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("failed to save Go settings: ", (Throwable)e);
            }
        }
    }

    @Override
    public TFile getGoFile() {
        String path = this.m_settings.getProperty(GO_PATH);
        TFile goFile = null;
        if (path == null) {
            path = GoLocator.locateGoExecutable();
            if (path != null) {
                goFile = new TFile(path);
                this.setGoFile(goFile);
            }
        } else {
            goFile = new TFile(path);
        }
        return goFile;
    }

    @Override
    public IPathValidator getGoPathValidator() {
        return new GoExeValidator();
    }

    private static class GoExeValidator
    implements IPathValidator {
        private GoExeValidator() {
        }

        public IPathValidator.PathType getType() {
            return IPathValidator.PathType.FILE;
        }

        public ValidationResult isValid(TFile currentInput, TFile newInput) {
            ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
            if (newInput == null || newInput.getPath().isEmpty()) {
                result.addError("Must not be empty");
                return result;
            }
            if (!newInput.isFile()) {
                result.addError("Specified path '" + newInput.getNormalizedAbsolutePath() + "' is not a file.");
                return result;
            }
            if (!newInput.canExecute()) {
                result.addError("Specified path '" + newInput.getNormalizedAbsolutePath() + "' is not executable.");
                return result;
            }
            if (Platform.isWindows()) {
                if (!newInput.getName().equalsIgnoreCase("go.exe")) {
                    result.addError("File name should be 'go.exe'");
                }
            } else if (!newInput.getName().equalsIgnoreCase("go")) {
                result.addError("File name should be 'go'");
            }
            return result;
        }
    }
}

