/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.go.command.system.GoCommandId;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.GoWorkspaceExtension;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;

public class AddNewGoModulesCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public static final ICommandId ID = GoCommandId.ADD_GO_MODULES;

    public AddNewGoModulesCommand(ISoftwareSystemProvider controller, IInteraction interaction) {
        super(controller, (ICommandInteraction)interaction);
    }

    public final ICommandId getId() {
        return ID;
    }

    protected void internalRun(IWorkerContext workerContext) {
        ModuleCreationData data = new ModuleCreationData();
        if (!((IInteraction)this.getInteraction()).collect(data) || data.isEmpty()) {
            return;
        }
        Installation installation = this.getController().getInstallation();
        GoWorkspaceExtension wsExt = (GoWorkspaceExtension)installation.getExtension(GoWorkspaceExtension.class);
        OperationResult result = new OperationResult("Adding modules to Go system");
        wsExt.addModulesToSystem(workerContext, result, this.getController().getSoftwareSystem(), data.getGoModFiles());
        if (!result.isFailure()) {
            OperationResult saveResult = this.getController().saveSoftwareSystem();
            result.addMessagesFrom(saveResult);
        }
        if (result.isFailure() || result.containsWarning()) {
            ((IInteraction)this.getInteraction()).processModuleCreationResult(result);
        }
    }

    public static interface IInteraction
    extends SaveSoftwareSystemCommand.ISaveInteraction {
        public boolean collect(ModuleCreationData var1);

        public void processModuleCreationResult(OperationResult var1);
    }

    public static class ModuleCreationData {
        private final List<TFile> m_goModFiles = new ArrayList<TFile>();

        public List<TFile> getGoModFiles() {
            return this.m_goModFiles;
        }

        public void addGoModFile(TFile goModFile) {
            assert (goModFile != null) : "Parameter 'goModFile' of method 'addGoModFile' must not be null";
            this.m_goModFiles.add(goModFile);
        }

        boolean isEmpty() {
            return this.m_goModFiles.isEmpty();
        }
    }
}

