/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.architecture;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.typescript.controller.system.architecture.TypescriptTypeHierarchyRetriever;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptClass;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.programming.TypescriptDependencyType;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Set;

public final class TypescriptExtendsClassRetriever
extends TypescriptTypeHierarchyRetriever {
    public String getName() {
        return "TypescriptExtendsClass";
    }

    public String getShortName() {
        return "ExtendsClass";
    }

    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches the pattern against the fully qualified name of any direct or indirect base class.\n\nPlease note that \u201c*\u201d will match anything except dots ('.').\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence";
    }

    @Override
    protected boolean collectFor(ProgrammingElement type) {
        assert (type != null) : "Parameter 'type' of method 'collectFor' must not be null";
        return type instanceof TypescriptClass;
    }

    @Override
    protected void collect(IWorkerContext workerContext, ProgrammingElement type, Set<String> collector) {
        Set data = this.getData((NamedElement)type);
        if (data == null) {
            List deps = type.getOutgoingDependencies(new IParserDependencyType[]{TypescriptDependencyType.EXTENDS});
            data = new THashSet();
            for (ParserDependency dep : deps) {
                ProgrammingElement baseType = dep.getTo();
                data.add(this.cutOffGenericParameters(baseType.getName()));
                this.collect(workerContext, baseType, data);
            }
            this.setData((NamedElement)type, data);
        }
        collector.addAll(data);
    }
}

