/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlElementAttributesExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlElementAttributesExtractor.class);

    private XmlElementAttributesExtractor() {
    }

    public static Map<String, String> process(File file, final String elementName) {
        assert (file != null) : "Parameter 'file' of method 'process' must not be null";
        assert (elementName != null && elementName.length() > 0) : "Parameter 'elementName' of method 'process' must not be empty";
        boolean error = false;
        try {
            Throwable throwable = null;
            Object var4_9 = null;
            try (FileInputStream is = new FileInputStream(file);){
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                DefaultHandler processor = new DefaultHandler(){
                    private StringBuilder m_content;
                    private final Map<String, String> attributeToValues = new LinkedHashMap<String, String>();

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (qName.equals(elementName)) {
                            int i = 0;
                            while (i < attributes.getLength()) {
                                this.attributeToValues.put(attributes.getQName(i), attributes.getValue(i));
                                ++i;
                            }
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (qName.equals(elementName)) {
                            throw new ElementProcessedException(this.attributeToValues);
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.m_content != null) {
                            this.m_content.append(ch, start, length);
                        }
                    }
                };
                saxParser.parse((InputStream)is, processor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ElementProcessedException ex) {
            return ex.getAttributeValues();
        }
        catch (SAXParseException sAXParseException) {
            error = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            error = true;
        }
        catch (IOException ex) {
            LOGGER.error("Failed to determine root element of " + file.getAbsolutePath(), (Throwable)ex);
            error = true;
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Fatal configuration exception", (Throwable)ex);
            error = true;
        }
        catch (SAXException ex) {
            LOGGER.error("Generic SAXException while processing " + file.getAbsolutePath(), (Throwable)ex);
            error = true;
        }
        return error ? null : Collections.emptyMap();
    }

    private static class ElementProcessedException
    extends SAXException {
        private static final long serialVersionUID = 4957345534010873888L;
        private final Map<String, String> attributeValues;

        public ElementProcessedException(Map<String, String> attributeValues) {
            super("");
            this.attributeValues = attributeValues;
        }

        public Map<String, String> getAttributeValues() {
            return this.attributeValues;
        }
    }
}

