/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.apitest;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.TestUtility;
import com.hello2morrow.sonargraph.integration.access.foundation.Utility;
import com.hello2morrow.sonargraph.integration.access.model.IElement;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IMetricCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricProvider;
import com.hello2morrow.sonargraph.integration.access.model.IMetricValue;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;
import com.hello2morrow.sonargraph.integration.access.model.IThresholdViolationIssue;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class SonargraphSystemControllerTest {
    private static final String APPLICATION_MODULE = "Application";
    private static final String INVALID_REPORT = "./src/test/resources/AlarmClock_invalid.xml";
    private static final String REPORT_PATH = "./src/test/resources/AlarmClock.xml";
    private ISonargraphSystemController m_controller;

    @Before
    public void before() {
        this.m_controller = ControllerFactory.createController();
    }

    @Test
    public void validateThresholdIssues() {
        Result result = this.m_controller.loadSystemReport(new File("./src/test/resources/AlarmClock_thresholdViolations.xml"));
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
        ISystemInfoProcessor processor = this.m_controller.createSystemInfoProcessor();
        List<IThresholdViolationIssue> thresholdIssues = processor.getThresholdViolationIssues(null);
        Assert.assertEquals((String)"Wrong number of issues", (long)3L, (long)thresholdIssues.size());
        List<IThresholdViolationIssue> unusedTypeThresholds = processor.getThresholdViolationIssues(th -> th.getThreshold().getMetricId().getName().equals("Unused Types"));
        Assert.assertEquals((String)"Wrong number of metric threshold issue", (long)1L, (long)unusedTypeThresholds.size());
        Assert.assertEquals((String)"Wrong metric value", (long)4L, (long)unusedTypeThresholds.get(0).getMetricValue().intValue());
    }

    @Test
    public void validateRefactorings() {
        Result result = this.m_controller.loadSystemReport(new File("./src/test/resources/AlarmClockMain_Refactorings.xml"));
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
        ISystemInfoProcessor systemProcessor = this.m_controller.createSystemInfoProcessor();
        List<IIssue> issues = systemProcessor.getIssues(i -> i.getIssueType().getCategory().getName().equals("Refactoring"));
        Assert.assertEquals((String)"Wrong number of refactorings", (long)3L, (long)issues.size());
        IModule alarmClock = systemProcessor.getModules().get("AlarmClock");
        List<ISourceFile> refactoredElements = this.getRefactoredSourceElements(alarmClock);
        Assert.assertEquals((String)"Wrong number of originals", (long)1L, (long)refactoredElements.size());
        Assert.assertEquals((String)"Wrong refactored element", (Object)"Workspace:AlarmClock:./AlarmClock/src/main/java:com:h2m:alarm:model:AlarmClock2.java", (Object)refactoredElements.get(0).getFqName());
        Optional<ISourceFile> originalSourceFileOpt = refactoredElements.get(0).getOriginalLocation();
        Assert.assertTrue((String)("Original source file expected '" + refactoredElements.get(0).getFqName() + "'"), (boolean)originalSourceFileOpt.isPresent());
        Assert.assertEquals((String)"Wrong original", (Object)"Workspace:AlarmClock:./AlarmClock/src/main/java:com:h2m:alarm:model:AlarmClock.java", (Object)originalSourceFileOpt.get().getFqName());
        IModule foundation = systemProcessor.getModules().get("Foundation");
        List<ISourceFile> refactoredElements2 = this.getRefactoredSourceElements(foundation);
        Assert.assertEquals((String)"Wrong number of originals", (long)1L, (long)refactoredElements2.size());
        Assert.assertEquals((String)"Wrong refactored element", (Object)"Workspace:Foundation:./Foundation/src/main/java:com:h2m:alarm:p1:C1_2.java", (Object)refactoredElements2.get(0).getFqName());
        Optional<ISourceFile> originalSourceFileOpt2 = refactoredElements2.get(0).getOriginalLocation();
        Assert.assertTrue((String)("Original source file expected for '" + refactoredElements2.get(0).getFqName() + "'"), (boolean)originalSourceFileOpt2.isPresent());
        Assert.assertEquals((String)"Wrong original", (Object)"Workspace:AlarmClock:./AlarmClock/src/main/java:com:h2m:alarm:p1:C1.java", (Object)originalSourceFileOpt2.get().getFqName());
    }

    private List<ISourceFile> getRefactoredSourceElements(IModule module) {
        HashMap<String, INamedElement> sourceFiles = new HashMap<String, INamedElement>(TestUtility.getFqNameToNamedElement(module, "JavaSourceFile"));
        sourceFiles.putAll(TestUtility.getFqNameToNamedElement(module, "JavaInternalCompilationUnit"));
        ArrayList<ISourceFile> refactoredElements = new ArrayList<ISourceFile>();
        for (INamedElement next : sourceFiles.values()) {
            Assert.assertTrue((String)("Unexpected class '" + next.getClass().getCanonicalName() + "' for element: " + next.toString()), (boolean)(next instanceof ISourceFile));
            ISourceFile sourceFile = (ISourceFile)next;
            Optional<ISourceFile> originalOpt = sourceFile.getOriginalLocation();
            if (!originalOpt.isPresent()) continue;
            refactoredElements.add(sourceFile);
        }
        return refactoredElements;
    }

    @Test
    public void testReadValidReport() {
        Result result = this.m_controller.loadSystemReport(new File(REPORT_PATH));
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = this.m_controller.getSoftwareSystem();
        this.verifySystem(softwareSystem, "D:\\00_repos\\00_e4-sgng\\com.hello2morrow.sonargraph.language.provider.java\\src\\test\\architecture\\AlarmClockWithArchitecture\\AlarmClock.sonargraph");
        this.verifyModule(softwareSystem);
        this.verifyIssues();
        this.verifyResolutions();
        this.verifyMetrics(softwareSystem);
    }

    @Test
    public void testReadMinimalReport() {
        Result result = this.m_controller.loadSystemReport(new File("./src/test/resources/ReportWithOneMetric.xml"));
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = this.m_controller.getSoftwareSystem();
        Assert.assertNotNull((String)"No software system available", (Object)softwareSystem);
    }

    @Test
    public void testReadReportWithDifferentOrigin() throws IOException {
        File baseDir = new File("./src/test/projects/smallTestProject");
        Result result = this.m_controller.loadSystemReport(new File("./src/test/projects/smallTestProject/AlarmClock_from_different_origin.xml"), baseDir);
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
        ISoftwareSystem softwareSystem = this.m_controller.getSoftwareSystem();
        Assert.assertNotNull((String)"No software system available", (Object)softwareSystem);
        Assert.assertEquals((String)"Wrong base directory", (Object)Utility.convertPathToUniversalForm(baseDir.getCanonicalPath()), (Object)softwareSystem.getBaseDir());
    }

    private void verifySystem(ISoftwareSystem softwareSystem, String systemPath) {
        Assert.assertEquals((String)"Wrong id", (Object)"4df288656010188b4d84a2a03bb0ecb9", (Object)softwareSystem.getSystemId());
        Assert.assertEquals((String)"Wrong system name", (Object)"AlarmClock", (Object)softwareSystem.getPresentationName());
        Assert.assertEquals((String)"Wrong path", (Object)systemPath, (Object)softwareSystem.getPath());
        Assert.assertEquals((String)"Wrong version", (Object)"9.1.0.100", (Object)softwareSystem.getVersion());
        Assert.assertEquals((String)"Wrong description", (Object)"", (Object)softwareSystem.getDescription());
        Assert.assertEquals((String)"Wrong virtual model", (Object)"Modifiable.vm", (Object)softwareSystem.getVirtualModel());
        Assert.assertEquals((String)"Wrong number of modules", (long)4L, (long)softwareSystem.getModules().size());
        HashSet<String> expectedSystemElementKinds = new HashSet<String>(Arrays.asList("GroovyScript", "JavaLogicalSystemNamespace", "LogicalSystemProgrammingElement", "SoftwareSystem"));
        Assert.assertThat((String)"Wrong system element kinds", softwareSystem.getElementKinds(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expectedSystemElementKinds)));
    }

    private void verifyModule(ISoftwareSystem softwareSystem) {
        IModule moduleApplication = softwareSystem.getModules().get(APPLICATION_MODULE);
        Assert.assertNotNull((String)"Module does not exist", (Object)moduleApplication);
        Assert.assertEquals((String)"Wrong module name", (Object)APPLICATION_MODULE, (Object)moduleApplication.getPresentationName());
        Assert.assertEquals((String)"Wrong language", (Object)"Java", (Object)moduleApplication.getLanguage());
        Assert.assertEquals((String)"Wrong description", (Object)"Main Project", (Object)moduleApplication.getDescription());
        Assert.assertEquals((String)"Wrong number of root directories", (long)2L, (long)moduleApplication.getRootDirectories().size());
        HashSet<String> expectedModuleElementKinds = new HashSet<String>(Arrays.asList("JavaModule", "JavaLogicalModuleNamespace", "LogicalModuleProgrammingElement", "JavaClassRootDirectoryPath", "JavaSourceRootDirectoryPath", "JavaInternalCompilationUnit", "JavaType", "JavaMethod", "JavaConstructor", "JavaStaticBlock"));
        Assert.assertThat((String)"Wrong module element kinds", moduleApplication.getElementKinds(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(expectedModuleElementKinds)));
        ISystemInfoProcessor infoProcessor = this.m_controller.createSystemInfoProcessor();
        Assert.assertEquals((String)"Wrong number of Analyzers", (long)19L, (long)infoProcessor.getAnalyzers().size());
        Assert.assertEquals((String)"No unlicensed analyzers expected", (long)0L, (long)infoProcessor.getAnalyzers().stream().filter(analyzer -> !analyzer.isLicensed()).count());
        Assert.assertEquals((String)"Wrong number of Features", (long)12L, (long)infoProcessor.getFeatures().size());
        Assert.assertEquals((String)"No uunlicensed features expected", (long)0L, (long)infoProcessor.getFeatures().stream().filter(features -> !features.isLicensed()).count());
        IModule moduleView = softwareSystem.getModules().get("View");
        this.processModuleElements(moduleView);
    }

    private void processModuleElements(IModule module) {
        HashMap elementMetricValueMap = new HashMap();
        IModuleInfoProcessor moduleInfoProcessor = this.m_controller.createModuleInfoProcessor(module);
        for (IMetricLevel nextLevel : moduleInfoProcessor.getMetricLevels()) {
            HashMap levelMetricValueMap = new HashMap();
            elementMetricValueMap.put(nextLevel, levelMetricValueMap);
            for (IMetricId nextId : moduleInfoProcessor.getMetricIdsForLevel(nextLevel)) {
                Map<String, IMetricValue> metricValueMap;
                if (!levelMetricValueMap.containsKey(nextId)) {
                    metricValueMap = new HashMap();
                    levelMetricValueMap.put(nextId, metricValueMap);
                } else {
                    metricValueMap = (Map)levelMetricValueMap.get(nextId);
                }
                for (Map.Entry<INamedElement, IMetricValue> nextValue : moduleInfoProcessor.getMetricValues(nextLevel.getName(), nextId.getName()).entrySet()) {
                    metricValueMap.put(nextValue.getKey().getFqName(), nextValue.getValue());
                }
            }
        }
        Assert.assertEquals((String)"Wrong number of levels", (long)7L, (long)elementMetricValueMap.size());
        ISystemInfoProcessor systemProcessor = this.m_controller.createSystemInfoProcessor();
        Map<String, IMetricLevel> allMetricLevels = systemProcessor.getMetricLevels().stream().collect(Collectors.toMap(level -> level.getName(), level -> level));
        Map moduleLevelMetricValueMap = (Map)elementMetricValueMap.get(allMetricLevels.get("Module"));
        Assert.assertEquals((String)"Wrong number of metric ids on module level", (long)37L, (long)moduleLevelMetricValueMap.size());
        IMetricId coreTotalLines = systemProcessor.getMetricId("CoreTotalLines").get();
        Map moduleMetricValueMap = (Map)moduleLevelMetricValueMap.get(coreTotalLines);
        Assert.assertEquals((String)"Wrong number of metric values", (long)1L, (long)moduleMetricValueMap.size());
        Assert.assertEquals((String)"Wrong metric value", (long)102L, (long)((IMetricValue)moduleMetricValueMap.get("Workspace:View")).getValue().intValue());
        Map packageLevelMetricValueMap = (Map)elementMetricValueMap.get(allMetricLevels.get("Package"));
        Assert.assertEquals((String)"Wrong number of metric ids on package level", (long)6L, (long)packageLevelMetricValueMap.size());
        IMetricId coreAbstractnessModule = systemProcessor.getMetricId("CoreAbstractnessModule").get();
        Map packageMetricValueMap = (Map)packageLevelMetricValueMap.get(coreAbstractnessModule);
        Assert.assertEquals((String)"Wrong number of metric values", (long)3L, (long)packageMetricValueMap.size());
        Assert.assertEquals((String)"Wrong metric value", (double)1.0, (double)((IMetricValue)packageMetricValueMap.get("Logical module namespaces:View:com:h2m:alarm:presentation")).getValue().floatValue(), (double)0.01);
        Map componentLevelMetricValueMap = (Map)elementMetricValueMap.get(allMetricLevels.get("Component"));
        IMetricId coreInstabilitySystem = systemProcessor.getMetricId("CoreInstabilitySysytem").get();
        Map componentMetricValueMap = (Map)componentLevelMetricValueMap.get(coreInstabilitySystem);
        Assert.assertEquals((String)"Wrong number of metric values", (long)3L, (long)componentMetricValueMap.size());
        Assert.assertEquals((String)"Wrong metric value", (double)0.33, (double)((IMetricValue)componentMetricValueMap.get("Workspace:View:../../smallTestProject/AlarmClock/View/src/main/java:com:h2m:alarm:presentation:AlarmHandler.java")).getValue().floatValue(), (double)0.01);
        Map sourceFileLevelMetricValueMap = (Map)elementMetricValueMap.get(allMetricLevels.get("SourceFile"));
        IMetricId coreSourceElementCount = systemProcessor.getMetricId("CoreSourceElementCount").get();
        Map sourceFileMetricValueMap = (Map)sourceFileLevelMetricValueMap.get(coreSourceElementCount);
        Assert.assertEquals((String)"Wrong number of metric values", (long)3L, (long)sourceFileMetricValueMap.size());
        Assert.assertEquals((String)"Wrong metric value", (long)13L, (long)((IMetricValue)sourceFileMetricValueMap.get("Workspace:View:../../smallTestProject/AlarmClock/View/src/main/java:com:h2m:alarm:presentation:file:AlarmToFile.java")).getValue().intValue());
        Map logicalProgElementLevelMetricValueMap = (Map)elementMetricValueMap.get(allMetricLevels.get("LogicalProgrammingElement"));
        IMetricId coreLogicalCouplingModule = systemProcessor.getMetricId("CoreLogicalCouplingModule").get();
        Map logicalProgElementMetricValueMap = (Map)logicalProgElementLevelMetricValueMap.get(coreLogicalCouplingModule);
        Assert.assertEquals((String)"Wrong number of metric values", (long)3L, (long)logicalProgElementMetricValueMap.size());
        Assert.assertEquals((String)"Wrong metric value", (long)4L, (long)((IMetricValue)logicalProgElementMetricValueMap.get("Logical module namespaces:View:com:h2m:alarm:presentation:console:AlarmToConsole")).getValue().intValue());
        Map typeLevelMetricValueMap = (Map)elementMetricValueMap.get(allMetricLevels.get("Type"));
        IMetricId coreStatements = systemProcessor.getMetricId("CoreStatements").get();
        Map typeMetricValueMap = (Map)typeLevelMetricValueMap.get(coreStatements);
        Assert.assertEquals((String)"Wrong number of metric values", (long)3L, (long)typeMetricValueMap.size());
        Assert.assertEquals((String)"Wrong metric value", (long)9L, (long)((IMetricValue)typeMetricValueMap.get("Workspace:View:../../smallTestProject/AlarmClock/View/src/main/java:com:h2m:alarm:presentation:file:AlarmToFile.java:AlarmToFile")).getValue().intValue());
        Map routineLevelMetricValueMap = (Map)elementMetricValueMap.get(allMetricLevels.get("Routine"));
        IMetricId coreCyclomaticComplexity = systemProcessor.getMetricId("CoreCcn").get();
        Map routineMetricValueMap = (Map)routineLevelMetricValueMap.get(coreCyclomaticComplexity);
        Assert.assertEquals((String)"Wrong number of metric values", (long)8L, (long)routineMetricValueMap.size());
        Assert.assertEquals((String)"Wrong metric value", (long)2L, (long)((IMetricValue)routineMetricValueMap.get("Workspace:View:../../smallTestProject/AlarmClock/View/src/main/java:com:h2m:alarm:presentation:file:AlarmToFile.java:AlarmToFile:handleAlarm()")).getValue().intValue());
    }

    private void verifyIssues() {
        ISystemInfoProcessor infoProcessor = this.m_controller.createSystemInfoProcessor();
        Assert.assertEquals((String)"Wrong number of issue providers", (long)3L, (long)infoProcessor.getIssueProviders().size());
        Assert.assertEquals((String)"Wrong number of issue types", (long)10L, (long)infoProcessor.getIssueTypes().size());
        Assert.assertTrue((String)"Script issue type not found", (boolean)infoProcessor.getIssueTypes().stream().anyMatch(type -> type.getName().equals("No incoming dependencies")));
        Assert.assertEquals((String)"Wrong number of issues", (long)22L, (long)infoProcessor.getIssues(null).size());
        Assert.assertEquals((String)"Wrong number of unresolved issues", (long)21L, (long)infoProcessor.getIssues(issue -> !issue.hasResolution()).size());
        Assert.assertEquals((String)"Wrong number of script based issues", (long)4L, (long)infoProcessor.getIssues(issue -> issue.getIssueType().getName().equals("No incoming dependencies")).size());
        Assert.assertEquals((String)"Wrong number of Script compilation issues", (long)1L, (long)infoProcessor.getIssues(issue -> issue.getIssueType().getName().equals("ScriptCompilationError")).size());
        Assert.assertEquals((String)"Wrong number of cycle groups", (long)2L, (long)infoProcessor.getIssues(issue -> {
            String name = issue.getIssueType().getName();
            return name.equals("NamespaceCycleGroup") || name.equals("ComponentCycleGroup");
        }).size());
        Assert.assertEquals((String)"Wrong number of component cycle groups", (long)1L, (long)infoProcessor.getCycleGroups(group -> group.getAnalyzer().getName().equals("ComponentCyclesModule")).size());
        Assert.assertEquals((String)"Wrong number of package cycle groups", (long)1L, (long)infoProcessor.getCycleGroups(group -> group.getAnalyzer().getName().equals("PackageCyclesModule")).size());
        Assert.assertEquals((String)"Wrong number of duplicate blocks", (long)3L, (long)infoProcessor.getIssues(issue -> issue.getIssueType().getCategory().getName().equals("DuplicateCode")).size());
        Assert.assertEquals((String)"Wrong number of issues matching predicate filter", (long)7L, (long)infoProcessor.getIssues(issue -> !issue.hasResolution() && issue.getIssueProvider().getName().equals("./createViolations.arc")).size());
    }

    private void verifyResolutions() {
        ISystemInfoProcessor infoProcessor = this.m_controller.createSystemInfoProcessor();
        Assert.assertEquals((String)"Wrong number of resolutions", (long)1L, (long)infoProcessor.getResolutions(null).size());
        Assert.assertEquals((String)"Wrong number of resolutions", (long)1L, (long)infoProcessor.getResolutions(r -> r.getType() == ResolutionType.TODO).size());
        Assert.assertEquals((String)"Wrong number of applicable resolutions", (long)1L, (long)infoProcessor.getResolutions(r -> r.isApplicable()).size());
    }

    private void verifyMetrics(ISoftwareSystem softwareSystem) {
        ISystemInfoProcessor infoProcessor = this.m_controller.createSystemInfoProcessor();
        List<IMetricCategory> metricCategories = infoProcessor.getMetricCategories();
        Assert.assertEquals((String)"Wrong number of metric categories", (long)10L, (long)metricCategories.size());
        Assert.assertEquals((String)"Wrong first category", (Object)"Architecture", (Object)metricCategories.get(0).getName());
        IMetricCategory metricCategory = metricCategories.stream().filter(cat -> cat.getName().equals("CodeAnalysis")).findFirst().get();
        Assert.assertEquals((String)"Wrong presentation name", (Object)"Code Analysis", (Object)metricCategory.getPresentationName());
        Assert.assertEquals((String)"Wrong order number of metric category", (long)1L, (long)metricCategory.getOrderNumber());
        List<IMetricProvider> metricProviders = infoProcessor.getMetricProviders();
        Assert.assertEquals((String)"Wrong number of metric providers", (long)3L, (long)metricProviders.size());
        Assert.assertEquals((String)"Wrong first provider", (Object)"Core", (Object)metricProviders.get(0).getName());
        Assert.assertEquals((String)"Wrong presentation name", (Object)"Java", (Object)metricProviders.stream().filter(p -> p.getName().equals("JavaLanguageProvider")).findFirst().get().getPresentationName());
        Assert.assertEquals((String)"Wrong number of metric ids", (long)76L, (long)infoProcessor.getMetricIds().size());
        Map<String, IMetricLevel> allMetricLevels = infoProcessor.getMetricLevels().stream().collect(Collectors.toMap(IElement::getName, level -> level));
        Assert.assertEquals((String)"Wrong number of metric levels", (long)8L, (long)allMetricLevels.size());
        Assert.assertEquals((String)"Wrong order number of metric level", (long)50L, (long)allMetricLevels.get("Component").getOrderNumber());
        Assert.assertEquals((String)"Wrong system metric float value", (float)2.44f, (float)infoProcessor.getMetricValue("CoreAcd").get().getValue().floatValue(), (float)0.001f);
        Assert.assertEquals((String)"Wrong system metric int value", (long)13L, (long)infoProcessor.getMetricValue("CoreArtifactCount").get().getValue().intValue());
        Assert.assertEquals((String)"Wrong number of unused types", (long)4L, (long)infoProcessor.getMetricValue("Unused Types").get().getValue().intValue());
        IModule viewModule = softwareSystem.getModules().get("View");
        IModuleInfoProcessor moduleInfoProcessor = this.m_controller.createModuleInfoProcessor(viewModule);
        IMetricLevel packageLevel = allMetricLevels.get("Package");
        Assert.assertEquals((String)"Wrong module metric value", (long)1L, (long)moduleInfoProcessor.getMetricValueForElement(infoProcessor.getMetricId("CoreIncomingDependenciesModule").get(), packageLevel, "Logical module namespaces:View:com:h2m:alarm:presentation:file").get().getValue().intValue());
        Assert.assertEquals((String)"Wrong module metric value", (long)2L, (long)moduleInfoProcessor.getMetricValueForElement(infoProcessor.getMetricId("CoreOutgoingDependenciesModule").get(), packageLevel, "Logical module namespaces:View:com:h2m:alarm:presentation:file").get().getValue().intValue());
        Assert.assertEquals((String)"Wrong module metric value", (double)0.67, (double)moduleInfoProcessor.getMetricValueForElement(infoProcessor.getMetricId("CoreInstabilityModule").get(), packageLevel, "Logical module namespaces:View:com:h2m:alarm:presentation:file").get().getValue().floatValue(), (double)0.01f);
    }

    @Test
    public void testReadInvalidReport() {
        Result result = this.m_controller.loadSystemReport(new File(INVALID_REPORT));
        Assert.assertTrue((String)"Expect failure, but got success", (boolean)result.isFailure());
    }

    @Test
    public void testReadNotExistingReport() {
        Result result = this.m_controller.loadSystemReport(new File("./fantasyDir/fantasyReport.xml"));
        Assert.assertTrue((String)"Expect failure, but got success", (boolean)result.isFailure());
    }
}

