/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.RootDirectoryPathValidator;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISnapshotController;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportRootDirectoryPathCandidate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.CustomPattern;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.IJavaModulesExtension;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.buildunits.BuildUnitDetector;
import com.hello2morrow.sonargraph.languageprovider.java.model.externalimport.buildunits.BuildUnitData;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaModulesExtension
extends Extension
implements IJavaModulesExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaModulesExtension.class);
    private final IFinishModelProcessor m_finishModelProcessor;

    JavaModulesExtension(IFinishModelProcessor finishModelProcessor) {
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'JavaModulesExtension' must not be null";
        this.m_finishModelProcessor = finishModelProcessor;
    }

    @Override
    public BuildUnitData detectInitialBuildUnitData(IWorkerContext workerContext, TFile startDirectory, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'detectInitialBuildUnitData' must not be null";
        assert (startDirectory != null) : "Parameter 'startDirectory' of method 'detectInitialBuildUnitData' must not be null";
        assert (startDirectory.exists()) : "Parameter 'startDirectory' of method 'detectInitialBuildUnitData' must exist";
        assert (startDirectory.isDirectory()) : "Parameter 'startDirectory' of method 'detectInitialBuildUnitData' must be a directory";
        return BuildUnitDetector.detectInitialBuildUnitData(workerContext, startDirectory, softwareSystem);
    }

    @Override
    public void detectRootDefinitions(IWorkerContext workerContext, BuildUnitData data) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'detectRootDefinitions' must not be null";
        assert (data != null) : "Parameter 'data' of method 'detectRootDefinitions' must not be null";
        BuildUnitDetector.detectRootDefinitions(workerContext, data);
    }

    @Override
    public void detectImportCandidates(IWorkerContext workerContext, BuildUnitData data) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'detectBasedOnBuildUnits' must not be null";
        assert (data != null) : "Parameter 'data' of method 'detectBasedOnBuildUnits' must not be null";
        BuildUnitDetector.detectImportCandidates(workerContext, data);
    }

    @Override
    public ITextValidator getClassRootSegmentValidator(BuildUnitData data) {
        assert (data != null) : "Parameter 'data' of method 'getClassRootSegmentValidator' must not be null";
        return new RootSegmentValidator(data.getClassRootSegments());
    }

    @Override
    public ITextValidator getSourceRootSegmentValidator(BuildUnitData data) {
        assert (data != null) : "Parameter 'data' of method 'getSourceRootSegmentValidator' must not be null";
        return new RootSegmentValidator(data.getSourceRootSegments());
    }

    @Override
    public ITextValidator getClassRootDefinitionValidator(BuildUnitData data) {
        assert (data != null) : "Parameter 'data' of method 'getClassRootDefinitionValidator' must not be null";
        return new RootDefinitionValidator(data.getClassRootDefinitions());
    }

    @Override
    public ITextValidator getSourceRootDefinitionValidator(BuildUnitData data) {
        assert (data != null) : "Parameter 'data' of method 'getSourceRootDefinitionValidator' must not be null";
        return new RootDefinitionValidator(data.getSourceRootDefinitions());
    }

    @Override
    public ITextValidator getModuleValidator(final BuildUnitData data) {
        assert (data != null) : "Parameter 'data' of method 'getModuleValidator' must not be null";
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                String string = newInput = newInput != null ? newInput.trim() : null;
                if (newInput == null || newInput.isEmpty()) {
                    result.addError("Must not be empty");
                } else {
                    for (String string2 : data.getExistingModules()) {
                        if (!string2.equalsIgnoreCase(newInput)) continue;
                        result.addError("Already present");
                        break;
                    }
                    for (ImportModuleCandidate importModuleCandidate : data.getModuleCandidates()) {
                        if (!importModuleCandidate.getName().equalsIgnoreCase(newInput)) continue;
                        result.addError("Already present");
                        break;
                    }
                }
                return result;
            }
        };
    }

    IPathValidator getSourceRootDirectoryPathValidator(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getSourceRootDirectoryPathValidator' must not be null";
        return new RootDirectoryPathValidator(((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(Module.class), IPathValidator.PathType.ARCHIVE_OR_DIRECTORY, JavaSourceRootDirectoryPath.class);
    }

    RootDirectoryPath createSourceRootDirectoryPath(JavaModule module, TFile file) {
        assert (module != null) : "Parameter 'module' of method 'createSourceRootDirectoryPath' must not be null";
        SoftwareSystem softwareSystem = (SoftwareSystem)module.getParent(SoftwareSystem.class, new Class[0]);
        assert (softwareSystem != null) : "'softwareSystem' of method 'createSourceRootDirectoryPath' must not be null";
        ValidationResult validationResult = this.getSourceRootDirectoryPathValidator(softwareSystem).isValid(null, file);
        assert (validationResult.isSuccess()) : "Not a valid root: " + String.valueOf(file) + " with message " + (String)validationResult.getErrors().get(0);
        RootDirectoryPath rootDirectoryPath = module.createNonStandardRootDirectoryPath((IModelServiceProvider)softwareSystem, (NamedElement)module, file);
        module.addChild((NamedElement)rootDirectoryPath);
        softwareSystem.setNeedsSave(true);
        softwareSystem.setNeedsReparse(true);
        return rootDirectoryPath;
    }

    private void finish(IWorkerContext workerContext, SoftwareSystem softwareSystem, IJavaModulesExtension.Mode mode, EnumSet<Modification> modification, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finish' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finish' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'finish' must not be null";
        assert (modification != null) : "Parameter 'modification' of method 'finish' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finish' must not be null";
        switch (mode) {
            case SYSTEM_CREATION: {
                workerContext.working("Saving system", true);
                result.addMessagesFrom(((ISoftwareSystemController)softwareSystem.getExtension(ISoftwareSystemController.class)).saveSoftwareSystem());
                break;
            }
            case SYSTEM_MODIFICATION: {
                softwareSystem.setNeedsSave(true);
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)mode);
                break;
            }
        }
        this.m_finishModelProcessor.finishModification(workerContext, softwareSystem, modification, result);
    }

    @Override
    public OperationResult createAdditionalModulesAndRootDirectories(IWorkerContext workerContext, Set<ImportModuleCandidate> modules, String contextInfo, SoftwareSystem softwareSystem, IJavaModulesExtension.Mode mode) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createAdditionalModulesAndRootDirectories' must not be null";
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'createAdditionalModulesAndRootDirectories' must not be empty";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createAdditionalModulesAndRootDirectories' must not be null";
        assert (contextInfo != null && contextInfo.length() > 0) : "Parameter 'contextInfo' of method 'createModules' must not be empty";
        assert (mode != null) : "Parameter 'mode' of method 'createAdditionalModulesAndRootDirectories' must not be null";
        ((ISnapshotController)softwareSystem.getExtension(ISnapshotController.class)).cancelSaveSnapshot();
        ((IAnalyzerExecutionController)softwareSystem.getExtension(IAnalyzerExecutionController.class)).cancelAndResetAllAnalyzers(ResetMode.ALL);
        String message = "Create additional modules and root directories (" + contextInfo + ")";
        OperationResult result = new OperationResult(message);
        workerContext.working(message, true);
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)softwareSystem.getExtension(WorkspaceExtension.class);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        EnumSet<Modification> modification = EnumSet.noneOf(Modification.class);
        boolean modulesModified = false;
        for (ImportModuleCandidate nextModuleCandidate : modules) {
            if (!nextModuleCandidate.isIncluded()) continue;
            workerContext.working("Process module '" + nextModuleCandidate.getName() + "'", true);
            Module nextModule = (Module)workspace.getUniqueChild((NamedElement.IFilter)new ShortNameFilter(nextModuleCandidate.getName(), true), JavaModule.class);
            if (nextModule == null) {
                nextModule = workspaceExtension.createModule((Module.IModuleType)JavaModule.JavaModuleType.MANUAL, nextModuleCandidate.getName(), null, modification);
                modulesModified = true;
            }
            for (ImportRootDirectoryPathCandidate nextRootPathCandidate : nextModuleCandidate.getRootPaths()) {
                if (!nextRootPathCandidate.isIncluded()) continue;
                if (!nextRootPathCandidate.isAlreadyInWorkspace()) {
                    RootDirectoryPath found;
                    final TFile nextRootPathCandidateFile = nextRootPathCandidate.getFile();
                    if (nextRootPathCandidate.hasSource()) {
                        found = (JavaSourceRootDirectoryPath)((Object)nextModule.getUniqueChild(new NamedElement.IFilter(){

                            public boolean accept(NamedElement element) {
                                if (!$assertionsDisabled && element == null) {
                                    throw new AssertionError((Object)"Parameter 'element' of method 'accept' must not be null");
                                }
                                return FileUtility.areEqual((TFile)((JavaSourceRootDirectoryPath)element).getDirectoryFile(), (TFile)nextRootPathCandidateFile);
                            }
                        }, JavaSourceRootDirectoryPath.class));
                        if (found == null) {
                            this.createSourceRootDirectoryPath((JavaModule)nextModule, nextRootPathCandidate.getFile());
                            modulesModified = true;
                            continue;
                        }
                        LOGGER.warn(nextModule.getName() + " already contains source root: " + nextRootPathCandidate.getFile().getNormalizedAbsolutePath());
                        continue;
                    }
                    found = (JavaClassRootDirectoryPath)((Object)nextModule.getUniqueChild(new NamedElement.IFilter(){

                        public boolean accept(NamedElement element) {
                            if (!$assertionsDisabled && element == null) {
                                throw new AssertionError((Object)"Parameter 'element' of method 'accept' must not be null");
                            }
                            return FileUtility.areEqual((TFile)((JavaClassRootDirectoryPath)element).getDirectoryFile(), (TFile)nextRootPathCandidateFile);
                        }
                    }, JavaClassRootDirectoryPath.class));
                    if (found == null) {
                        workspaceExtension.createRootDirectoryPathInternal(nextModule, nextRootPathCandidate.getFile(), true);
                        modulesModified = true;
                        continue;
                    }
                    LOGGER.warn(nextModule.getName() + " already contains class root: " + nextRootPathCandidate.getFile().getNormalizedAbsolutePath());
                    continue;
                }
                LOGGER.warn("Candidate root is marked as 'already in workspace': " + nextRootPathCandidate.getFile().getNormalizedAbsolutePath());
            }
        }
        assert (modulesModified) : "No modules modified";
        this.finish(workerContext, softwareSystem, mode, modification, result);
        return result;
    }

    static final class PatternValidator
    implements ITextValidator {
        private final Collection<String> m_existing;

        PatternValidator(Collection<String> existing) {
            assert (existing != null) : "Parameter 'existing' of method 'PatterValidator' must not be null";
            this.m_existing = existing;
        }

        public ValidationResult isValid(String currentInput, String newInput) {
            ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
            String string = newInput = newInput != null ? newInput.trim() : null;
            if (newInput == null || newInput.isEmpty()) {
                result.addError("Must not be empty");
            } else {
                for (String next : this.m_existing) {
                    if (!next.equalsIgnoreCase(newInput)) continue;
                    result.addError("Already present");
                }
                if (!result.hasErrors()) {
                    try {
                        CustomPattern.compileWildcardPattern((String)newInput, (boolean)true);
                    }
                    catch (PatternSyntaxException e) {
                        result.addError("Not a valid pattern: " + e.getLocalizedMessage());
                    }
                }
            }
            return result;
        }
    }

    static final class RootDefinitionValidator
    implements ITextValidator {
        private final Collection<String> m_existing;

        RootDefinitionValidator(Collection<String> existing) {
            assert (existing != null) : "Parameter 'existing' of method 'RootDefinitionValidator' must not be null";
            this.m_existing = existing;
        }

        public ValidationResult isValid(String currentInput, String newInput) {
            ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
            String string = newInput = newInput != null ? newInput.trim() : null;
            if (newInput == null || newInput.isEmpty()) {
                result.addError("Must not be empty");
            } else if (!newInput.startsWith("/")) {
                result.addError("Must start with '/'");
            } else if (newInput.length() == 1) {
                result.addError("Must contain more than '/'");
            } else {
                for (String next : this.m_existing) {
                    if (!next.equalsIgnoreCase(newInput)) continue;
                    result.addError("Already present");
                    break;
                }
            }
            return result;
        }
    }

    static final class RootSegmentValidator
    implements ITextValidator {
        private final Collection<String> m_existing;

        RootSegmentValidator(Collection<String> existing) {
            assert (existing != null) : "Parameter 'existing' of method 'RootSegmentValidator' must not be null";
            this.m_existing = existing;
        }

        public ValidationResult isValid(String currentInput, String newInput) {
            ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
            String string = newInput = newInput != null ? newInput.trim() : null;
            if (newInput == null || newInput.isEmpty()) {
                result.addError("Must not be empty");
            } else if (!newInput.startsWith("/")) {
                result.addError("Must start with '/'");
            } else if (StringUtility.countChar((char)'/', (String)newInput) > 1) {
                result.addError("Must not contain more than 1 '/'");
            } else {
                for (String next : this.m_existing) {
                    if (!next.equalsIgnoreCase(newInput)) continue;
                    result.addError("Already present");
                    break;
                }
            }
            return result;
        }
    }
}

