/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.NumberValue;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FloatValue
extends NumberValue {
    private static final Logger LOGGER = LoggerFactory.getLogger(FloatValue.class);
    private static final String VALUE = "value";
    private float m_value;

    private static boolean isValueValid(float value, IMetricDescriptor metricDescriptor) {
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'isValueValid' must not be null";
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            LOGGER.error("Not a valid float metric for '" + String.valueOf(metricDescriptor.getMetricId()) + ":" + String.valueOf(metricDescriptor.getLevel()) + "'");
            return false;
        }
        return true;
    }

    public FloatValue(NamedElement parent) {
        super(parent);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeFloat(VALUE, this.m_value);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_value = reader.readFloat(VALUE).floatValue();
        FloatValue.isValueValid(this.m_value, this.getMetricDescriptor());
    }

    public FloatValue(NamedElement parent, NamedElement element, float value) {
        super(parent, element);
        this.m_value = value;
        FloatValue.isValueValid(this.m_value, this.getMetricDescriptor());
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.m_value);
    }

    @Override
    public boolean isValid() {
        return FloatValue.isValueValid(this.m_value, this.getMetricDescriptor()) && super.isValid();
    }
}

