/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecturediagram;

import com.hello2morrow.sonargraph.core.foundation.common.graph.IRepresentedNode;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IUmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IUmlComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IUmlComponentElement;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentConnector;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentInterface;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UmlComponent
extends NamedElementContainer
implements IUmlComponentContainer,
IUmlComponent,
IRepresentedNode<UmlComponent> {
    private final Set<AnchorBased> m_anchorBased = new TreeSet<AnchorBased>(new Comparator<AnchorBased>(){

        @Override
        public int compare(AnchorBased a1, AnchorBased a2) {
            if (!$assertionsDisabled && a1 == null) {
                throw new AssertionError((Object)"Parameter 'a1' of method 'enclosing_method' must not be null");
            }
            if (!$assertionsDisabled && a2 == null) {
                throw new AssertionError((Object)"Parameter 'a2' of method 'enclosing_method' must not be null");
            }
            return a1.toString().compareTo(a2.toString());
        }
    });
    private static final Logger LOGGER = LoggerFactory.getLogger(UmlComponent.class);
    private final Set<ExportedBy> m_exports = new THashSet();
    private final Artifact m_artifact;
    private Set<Uses> m_outgoingUses = new THashSet();
    private Set<Uses> m_incomingUses = new THashSet();
    private final int m_depth;
    private byte m_flags = 0;
    private int m_level = -1;

    public UmlComponent(NamedElement parent, Artifact artifact, int depth) {
        super(parent);
        assert (artifact != null) : "Parameter 'artifact' of method 'Component' must not be null";
        assert (depth >= 1) : "Invalid depth: " + depth;
        this.m_artifact = artifact;
        this.m_depth = depth;
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    public int getDepth() {
        return this.m_depth;
    }

    public void setLevel(int level) {
        assert (level >= 1) : "Invalid level: " + level;
        this.m_level = level;
    }

    @Override
    public int getLevel() {
        assert (this.m_level != -1) : "'level' not calculated";
        return this.m_level;
    }

    @Override
    public void sortComponents(Comparator<IUmlComponent> comparator) {
        assert (comparator != null) : "Parameter 'comparator' of method 'sortComponents' must not be null";
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null && !children.isEmpty()) {
            ArrayList<IUmlComponent> umlComponents = new ArrayList<IUmlComponent>();
            Iterator<NamedElement> iter = children.iterator();
            while (iter.hasNext()) {
                NamedElement next = iter.next();
                if (!(next instanceof IUmlComponent)) continue;
                iter.remove();
                umlComponents.add((IUmlComponent)((Object)next));
            }
            if (!umlComponents.isEmpty()) {
                Collections.sort(umlComponents, comparator);
                umlComponents.forEach(u -> {
                    boolean bl = children.add(u.getNamedElement());
                });
            }
            this.finishModification();
        }
    }

    private void logDifferentSizesUses(Set<Uses> uses, Set<Uses> sortedUses, String type) {
        assert (uses != null) : "Parameter 'uses' of method 'logDifferentSizesUses' must not be null";
        assert (sortedUses != null) : "Parameter 'sortedUses' of method 'logDifferentSizesUses' must not be null";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'logDifferentSizesUses' must not be empty";
        StringBuilder warn = new StringBuilder("Diffent size 'incoming' uses! Incoming/sorted:");
        warn.append("Diffent size '").append(type).append("' uses, uses/sorted uses:");
        warn.append(uses.size()).append("/").append(sortedUses.size());
        int i = 1;
        for (Uses next : uses) {
            warn.append("\n[").append(i).append("] ").append(next.toString());
            ++i;
        }
        i = 1;
        for (Uses next : sortedUses) {
            warn.append("\n[").append(i).append("] ").append(next.toString());
            ++i;
        }
        LOGGER.warn(warn.toString());
    }

    public void sortUses(Comparator<Uses> comparator) {
        assert (comparator != null) : "Parameter 'comparator' of method 'sortComponents' must not be null";
        if (this.m_outgoingUses.isEmpty()) {
            this.m_outgoingUses = Collections.emptySet();
        } else {
            TreeSet<Uses> outgoingSorted = new TreeSet<Uses>(comparator);
            outgoingSorted.addAll(this.m_outgoingUses);
            if (outgoingSorted.size() != this.m_outgoingUses.size()) {
                this.logDifferentSizesUses(this.m_outgoingUses, outgoingSorted, "outgoing");
            }
            this.m_outgoingUses = outgoingSorted;
        }
        if (this.m_incomingUses.isEmpty()) {
            this.m_incomingUses = Collections.emptySet();
        } else {
            TreeSet<Uses> incomingSorted = new TreeSet<Uses>(comparator);
            incomingSorted.addAll(this.m_incomingUses);
            if (incomingSorted.size() != this.m_incomingUses.size()) {
                this.logDifferentSizesUses(this.m_incomingUses, incomingSorted, "incoming'");
            }
            this.m_incomingUses = incomingSorted;
        }
    }

    @Override
    public String getPresentationKind() {
        return this.m_artifact.getPresentationKind();
    }

    private void addUsed(Uses used) {
        assert (used != null) : "Parameter 'used' of method 'addUsed' must not be null";
        assert (used.getTargetComponent() == this) : "Target component is different: " + String.valueOf(used.getTargetComponent()) + "/" + String.valueOf(this);
        assert (used.getSourceComponent() != this) : "No self references";
        boolean success = this.m_incomingUses.add(used);
        assert (success) : "'used' already added";
    }

    public boolean addUses(Uses uses) {
        assert (uses != null) : "Parameter 'uses' of method 'addUses' must not be null";
        assert (uses.getSourceComponent() == this) : "Source component is different: " + String.valueOf(uses.getSourceComponent()) + "/" + String.valueOf(this);
        assert (uses.getTargetComponent() != this) : "No self references";
        assert (uses.getSourceComponent().getDepth() == uses.getTargetComponent().getDepth()) : "Different depths";
        if (this.m_outgoingUses.add(uses)) {
            uses.getTargetComponent().addUsed(uses);
            return true;
        }
        return false;
    }

    public Set<Uses> getOutgoingUses() {
        return Collections.unmodifiableSet(this.m_outgoingUses);
    }

    @Override
    public int getNumberOfIncomingUses() {
        return this.m_incomingUses.size();
    }

    public Set<Uses> getIncomingUses() {
        return Collections.unmodifiableSet(this.m_incomingUses);
    }

    @Override
    public int getNumberOfOutgoingUses() {
        return this.m_outgoingUses.size();
    }

    private void addExports(ExportedBy exportedBy) {
        assert (exportedBy != null) : "Parameter 'anchorBased' of method 'addExports' must not be null";
        assert (exportedBy.getTargetComponent() == this) : "Target component is different: " + String.valueOf(exportedBy.getTargetComponent()) + "/" + String.valueOf(this);
        assert (exportedBy.getSourceComponent() != this) : "No self references";
        boolean success = this.m_exports.add(exportedBy);
        assert (success) : "'exports' already added";
    }

    public boolean addAnchorBased(AnchorBased anchorBased) {
        assert (anchorBased != null) : "Parameter 'anchorBased' of method 'addAnchorBased' must not be null";
        assert (anchorBased.getSourceComponent() == this) : "Source component is different: " + String.valueOf(anchorBased.getSourceComponent()) + "/" + String.valueOf(this);
        assert (anchorBased.getTargetComponent() != this) : "No self references";
        UmlComponent umlComponentParent = this.getParent(UmlComponent.class, ParentMode.class);
        assert (umlComponentParent != null) : "'umlComponentParent' of method 'addAnchorBased' must not be null";
        assert (anchorBased.getTargetComponent() == umlComponentParent) : "Target component is not valid: " + String.valueOf(anchorBased.getTargetComponent());
        if (this.m_anchorBased.add(anchorBased)) {
            if (anchorBased.getType() == DependencyType.EXPORTED_BY) {
                anchorBased.getTargetComponent().addExports((ExportedBy)anchorBased);
            }
            return true;
        }
        return false;
    }

    public Set<AnchorBased> getAnchorBased() {
        return Collections.unmodifiableSet(this.m_anchorBased);
    }

    public Set<UmlComponentInterface> getExported(UmlComponentInterface umlComponentInterface) {
        assert (umlComponentInterface != null) : "Parameter 'umlComponentInterface' of method 'getExported' must not be null";
        assert (umlComponentInterface.hasAsParent(this, true)) : "Not an interface of: " + this.getName();
        THashSet exported = new THashSet();
        for (ExportedBy next : this.m_exports) {
            if (next.getTargetAnchor() != umlComponentInterface) continue;
            exported.add(next.getSourceAnchor());
        }
        return exported;
    }

    public void setSelected(boolean selected) {
        this.m_flags = IUmlComponentElement.setEnabled(selected, this.m_flags, (byte)1);
    }

    public boolean isSelected() {
        return IUmlComponentElement.isEnabled(this.m_flags, (byte)1);
    }

    public void setHighlighted(boolean highlighted) {
        this.m_flags = IUmlComponentElement.setEnabled(highlighted, this.m_flags, (byte)2);
    }

    public boolean isHighlighted() {
        return IUmlComponentElement.isEnabled(this.m_flags, (byte)2);
    }

    public boolean isExpandable() {
        return this.hasChildren(false, UmlComponent.class);
    }

    public void setIsExpanded(boolean expanded) {
        assert (!expanded || this.isExpandable()) : "Not expandable";
        this.m_flags = IUmlComponentElement.setEnabled(expanded, this.m_flags, (byte)4);
    }

    public boolean isExpanded() {
        return IUmlComponentElement.isEnabled(this.m_flags, (byte)4);
    }

    @Override
    public String getShortName() {
        return this.m_artifact.getName();
    }

    public Artifact getArtifact() {
        return this.m_artifact;
    }

    public List<Artifact> getArtifactChildren() {
        return this.m_artifact.getChildren(Artifact.class);
    }

    @Override
    public Collection<UmlComponent> getConnectedElements() {
        if (this.m_outgoingUses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UmlComponent> uses = new ArrayList<UmlComponent>(this.m_outgoingUses.size());
        for (Uses next : this.m_outgoingUses) {
            uses.add(next.getTargetComponent());
        }
        return uses;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitUmlComponent(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String toString() {
        String stereotypes = this.m_artifact.getStereotypes();
        return this.getClass().getSimpleName() + ": " + this.getShortName() + (String)(stereotypes != null && !stereotypes.isEmpty() ? " <<" + stereotypes + ">>" : "") + " (Depth:" + this.m_depth + ", Level:" + this.m_level + ")";
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\nDepth:").append(this.m_depth).append(" Level:").append(this.m_level);
        return builder.toString();
    }

    public static abstract class AnchorBased
    extends UmlComponentDependency {
        private final UmlComponentAnchor<? extends ArchitectureElement> m_sourceAnchor;
        private final UmlComponentAnchor<? extends ArchitectureElement> m_targetAnchor;

        public AnchorBased(UmlComponentAnchor<? extends ArchitectureElement> sourceAnchor, UmlComponentAnchor<? extends ArchitectureElement> targetAnchor) {
            assert (sourceAnchor != null) : "Parameter 'sourceAnchor' of method 'AnchorBased' must not be null";
            assert (targetAnchor != null) : "Parameter 'targetAnchor' of method 'AnchorBased' must not be null";
            assert (sourceAnchor != targetAnchor) : "Same instances";
            this.m_sourceAnchor = sourceAnchor;
            this.m_targetAnchor = targetAnchor;
        }

        @Override
        public final UmlComponent getSourceComponent() {
            UmlComponent source = this.m_sourceAnchor.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (source != null) : "'source' of method 'getSourceComponent' must not be null";
            return source;
        }

        @Override
        public UmlComponentAnchor<? extends ArchitectureElement> getSourceAnchor() {
            return this.m_sourceAnchor;
        }

        @Override
        public final UmlComponent getTargetComponent() {
            UmlComponent target = this.m_targetAnchor.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (target != null) : "'target' of method 'getTargetComponent' must not be null";
            return target;
        }

        @Override
        public UmlComponentAnchor<? extends ArchitectureElement> getTargetAnchor() {
            return this.m_targetAnchor;
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.m_sourceAnchor.hashCode();
            result = 31 * result + this.m_targetAnchor.hashCode();
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AnchorBased other = (AnchorBased)obj;
            return this.m_sourceAnchor.equals(other.m_sourceAnchor) && this.m_targetAnchor.equals(other.m_targetAnchor);
        }
    }

    public static enum DependencyEndpoint {
        SOURCE,
        TARGET;

    }

    public static enum DependencyType {
        USES,
        INCLUDED_BY,
        EXPORTED_BY;

    }

    public static final class ExportedBy
    extends AnchorBased {
        public ExportedBy(UmlComponentInterface sourceAnchor, UmlComponentInterface targetAnchor) {
            super(sourceAnchor, targetAnchor);
        }

        @Override
        public DependencyType getType() {
            return DependencyType.EXPORTED_BY;
        }

        public UmlComponentInterface getSourceAnchor() {
            return (UmlComponentInterface)super.getSourceAnchor();
        }

        public UmlComponentInterface getTargetAnchor() {
            return (UmlComponentInterface)super.getTargetAnchor();
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitUmlComponent(UmlComponent var1);
    }

    public static final class IncludedBy
    extends AnchorBased {
        public IncludedBy(UmlComponentConnector sourceAnchor, UmlComponentConnector targetAnchor) {
            super(sourceAnchor, targetAnchor);
        }

        @Override
        public DependencyType getType() {
            return DependencyType.INCLUDED_BY;
        }

        public UmlComponentConnector getSourceAnchor() {
            return (UmlComponentConnector)super.getSourceAnchor();
        }

        public UmlComponentConnector getTargetAnchor() {
            return (UmlComponentConnector)super.getTargetAnchor();
        }
    }

    public static abstract class UmlComponentDependency
    implements IUmlComponentElement {
        private byte m_flags = 0;

        public abstract DependencyType getType();

        public abstract UmlComponent getSourceComponent();

        public abstract UmlComponent getTargetComponent();

        public abstract UmlComponentAnchor<? extends ArchitectureElement> getSourceAnchor();

        public abstract UmlComponentAnchor<? extends ArchitectureElement> getTargetAnchor();

        public final void setSelected(boolean selected) {
            this.m_flags = IUmlComponentElement.setEnabled(selected, this.m_flags, (byte)1);
        }

        public final boolean isSelected() {
            return IUmlComponentElement.isEnabled(this.m_flags, (byte)1);
        }

        public final void setHighlighted(boolean highlighted) {
            this.m_flags = IUmlComponentElement.setEnabled(highlighted, this.m_flags, (byte)2);
        }

        public final boolean isHighlighted() {
            return IUmlComponentElement.isEnabled(this.m_flags, (byte)2);
        }

        public final void setHidden(boolean hidden) {
            this.m_flags = IUmlComponentElement.setEnabled(hidden, this.m_flags, (byte)8);
        }

        public final boolean isHidden() {
            return IUmlComponentElement.isEnabled(this.m_flags, (byte)8);
        }

        public final String toString() {
            return String.valueOf((Object)this.getType()) + " [" + this.getSourceComponent().getName() + "] " + this.getSourceAnchor().getName() + " -> [" + this.getTargetComponent().getName() + "] " + this.getTargetAnchor().getName();
        }
    }

    public static final class Uses
    extends UmlComponentDependency {
        private final UmlComponentConnector m_sourceConnector;
        private final UmlComponentInterface m_targetInterface;

        public Uses(UmlComponentConnector sourceConnector, UmlComponentInterface targetInterface) {
            assert (sourceConnector != null) : "Parameter 'sourceConnector' of method 'UmlComponentDependency' must not be null";
            assert (targetInterface != null) : "Parameter 'targetInterface' of method 'UmlComponentDependency' must not be null";
            this.m_sourceConnector = sourceConnector;
            this.m_targetInterface = targetInterface;
            assert (this.getSourceComponent() != this.getTargetComponent()) : "No self references";
        }

        @Override
        public DependencyType getType() {
            return DependencyType.USES;
        }

        @Override
        public UmlComponent getSourceComponent() {
            UmlComponent source = this.m_sourceConnector.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (source != null) : "'source' of method 'getSourceComponent' must not be null";
            return source;
        }

        public UmlComponentConnector getSourceConnector() {
            return this.m_sourceConnector;
        }

        @Override
        public UmlComponent getTargetComponent() {
            UmlComponent target = this.m_targetInterface.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (target != null) : "'target' of method 'getTargetComponent' must not be null";
            return target;
        }

        public UmlComponentInterface getTargetInterface() {
            return this.m_targetInterface;
        }

        @Override
        public UmlComponentAnchor<? extends ArchitectureElement> getSourceAnchor() {
            return this.getSourceConnector();
        }

        @Override
        public UmlComponentAnchor<? extends ArchitectureElement> getTargetAnchor() {
            return this.getTargetInterface();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.m_sourceConnector.hashCode();
            result = 31 * result + this.m_targetInterface.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Uses other = (Uses)obj;
            return this.m_sourceConnector.equals(other.m_sourceConnector) && this.m_targetInterface.equals(other.m_targetInterface);
        }
    }
}

