/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.parser.ParserMessage;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParserResult {
    private final SourceFile m_sourceFile;
    private final List<ParserMessage> m_messages = new ArrayList<ParserMessage>();
    private final List<ParserMessage> m_errors = new ArrayList<ParserMessage>();

    public ParserResult(SourceFile sourceFile) {
        this.m_sourceFile = sourceFile;
    }

    public void addMessage(int line, int col, String msg) {
        this.m_messages.add(new ParserMessage(this.m_sourceFile, line, col, msg));
    }

    public void addMessage(SourceFile file, int line, int col, String msg) {
        this.m_messages.add(new ParserMessage(file, line, col, msg));
    }

    public void addError(int line, int col, String msg) {
        this.m_errors.add(new ParserMessage(this.m_sourceFile, line, col, msg));
    }

    public void addError(SourceFile file, int line, int col, String msg) {
        this.m_errors.add(new ParserMessage(file, line, col, msg));
    }

    public List<ParserMessage> getMessages() {
        return Collections.unmodifiableList(this.m_messages);
    }

    public List<ParserMessage> getErrors() {
        return Collections.unmodifiableList(this.m_errors);
    }

    public SourceFile getSourceFile() {
        return this.m_sourceFile;
    }

    public boolean hasMessagesOrErrors() {
        return this.m_messages.size() > 0 || this.m_errors.size() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.m_errors.forEach(m -> {
            StringBuilder stringBuilder2 = sb.append(m.toString()).append('\n');
        });
        this.m_messages.forEach(m -> {
            StringBuilder stringBuilder2 = sb.append(m.toString()).append('\n');
        });
        return sb.toString();
    }
}

