/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusApplyVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodesWithPotentialDependenciesCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.Weight;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewDependencyDescriptor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableContainer;
import com.hello2morrow.sonargraph.core.model.explorationview.IProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyState;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DependencyHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyHandler.class);

    private DependencyHandler() {
    }

    private static boolean isOwnDependency(IProgrammingElementNode node, ProgrammingElement from, ProgrammingElement to) {
        assert (node != null) : "Parameter 'node' of method 'isOwnDependency' must not be null";
        assert (from != null) : "Parameter 'from' of method 'isOwnDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isOwnDependency' must not be null";
        for (ProgrammingElement programmingElement : node.getUnderlyingProgrammingElements()) {
            if (from != programmingElement && to != programmingElement) continue;
            return true;
        }
        return false;
    }

    private static boolean includeParserDependency(ArchitecturalViewNode fromNode, ArchitecturalViewNode toNode, ParserDependencyEndPoints dependency) {
        ProgrammingElement to;
        boolean isSelfReference;
        assert (fromNode != null) : "Parameter 'fromNode' of method 'addParserDependency' must not be null";
        assert (toNode != null) : "Parameter 'toNode' of method 'addParserDependency' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'addParserDependency' must not be null";
        boolean fromNodeIsProgrammingElementNode = fromNode instanceof IProgrammingElementNode;
        boolean toNodeIsProgrammingElementNode = toNode instanceof IProgrammingElementNode;
        if (!fromNodeIsProgrammingElementNode && !toNodeIsProgrammingElementNode) {
            return fromNode != toNode;
        }
        ProgrammingElement from = dependency.getFrom();
        boolean bl = isSelfReference = from == (to = dependency.getTo());
        if (fromNode == toNode) {
            assert (fromNodeIsProgrammingElementNode && toNodeIsProgrammingElementNode) : "Both nodes must be programming element nodes";
            if (isSelfReference) {
                return DependencyHandler.isOwnDependency((IProgrammingElementNode)((Object)fromNode), from, to);
            }
            return false;
        }
        if (isSelfReference) {
            return false;
        }
        if (fromNodeIsProgrammingElementNode && fromNode.isExpanded() && !DependencyHandler.isOwnDependency((IProgrammingElementNode)((Object)fromNode), from, to)) {
            return false;
        }
        return !toNodeIsProgrammingElementNode || !toNode.isExpanded() || DependencyHandler.isOwnDependency((IProgrammingElementNode)((Object)toNode), from, to);
    }

    private static ArchitecturalViewNode getFromNodeOfIncomingDependency(ArchitecturalViewNode node, Map<ArchitecturalViewNode, ArchitecturalViewNode> mappedToLeafNode, ParserDependencyEndPoints endPoints, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'getFromNodeOfIncomingDependency' must not be null";
        assert (mappedToLeafNode != null) : "Parameter 'mappedToLeafNode' of method 'getFromNodeOfIncomingDependency' must not be null";
        assert (endPoints != null) : "Parameter 'endPoints' of method 'getFromNodeOfIncomingDependency' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'getFromNodeOfIncomingDependency' must not be null";
        ArchitecturalViewNode nextFromMapped = representation.getLeafNode(endPoints.getFrom());
        if (nextFromMapped == null) {
            return null;
        }
        ArchitecturalViewNode nextFromParent = mappedToLeafNode.get(nextFromMapped);
        if (nextFromParent != null) {
            if (nextFromParent == representation.getNullNode()) {
                return null;
            }
            if (!DependencyHandler.includeParserDependency(nextFromParent, node, endPoints)) {
                return null;
            }
            return nextFromParent;
        }
        nextFromParent = NodeHandler.getFirstVisibleParentOrSelf(nextFromMapped);
        if (nextFromParent != null && DependencyHandler.includeParserDependency(nextFromParent, node, endPoints)) {
            mappedToLeafNode.put(nextFromMapped, nextFromParent);
            return nextFromParent;
        }
        if (!(nextFromMapped instanceof IProgrammingElementNode)) {
            mappedToLeafNode.put(nextFromMapped, representation.getNullNode());
        }
        return null;
    }

    private static ArchitecturalViewNode getToNodeOfOutgoingDependency(ArchitecturalViewNode node, Map<ArchitecturalViewNode, ArchitecturalViewNode> mappedToLeafNode, ParserDependencyEndPoints endPoints, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'getToNodeOfOutgoingDependency' must not be null";
        assert (mappedToLeafNode != null) : "Parameter 'mappedToLeafNode' of method 'getToNodeOfOutgoingDependency' must not be null";
        assert (endPoints != null) : "Parameter 'endPoints' of method 'getToNodeOfOutgoingDependency' must not be null";
        assert (representation != null) : "Parameter 'name' of method 'getToNodeOfOutgoingDependency' must not be null";
        ArchitecturalViewNode nextToMapped = representation.getLeafNode(endPoints.getTo());
        if (nextToMapped == null) {
            return null;
        }
        ArchitecturalViewNode nextToParent = mappedToLeafNode.get(nextToMapped);
        if (nextToParent != null) {
            if (nextToParent == representation.getNullNode()) {
                return null;
            }
            if (!DependencyHandler.includeParserDependency(node, nextToParent, endPoints)) {
                return null;
            }
            return nextToParent;
        }
        nextToParent = NodeHandler.getFirstVisibleParentOrSelf(nextToMapped);
        if (nextToParent != null && DependencyHandler.includeParserDependency(node, nextToParent, endPoints)) {
            mappedToLeafNode.put(nextToMapped, nextToParent);
            return nextToParent;
        }
        if (!(nextToMapped instanceof IProgrammingElementNode)) {
            mappedToLeafNode.put(nextToMapped, representation.getNullNode());
        }
        return null;
    }

    private static boolean removeAggregatedParserDependencies(ArchitecturalViewNode node, ArchitecturalViewNode.ArchitecturalViewDependency dependency) {
        assert (node != null) : "Parameter 'node' of method 'removeAggregatedParserDependencies' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'removeAggregatedParserDependencies' must not be null";
        if (!(node instanceof IProgrammingElementNode)) {
            return true;
        }
        Iterator<ParserDependency> iter = dependency.getParserDependenciesIterator();
        boolean allDeleted = true;
        while (iter.hasNext()) {
            ParserDependency next = iter.next();
            if (DependencyHandler.isOwnDependency((IProgrammingElementNode)((Object)node), next.getFrom(), next.getTo())) {
                allDeleted = false;
                continue;
            }
            iter.remove();
        }
        return allDeleted;
    }

    private static IAssignableContainer getAssignableContainer(ArchitecturalViewNode node, Map<ArchitecturalViewNode, IAssignableContainer> cache) {
        assert (node != null) : "Parameter 'node' of method 'getAssignableContainer' must not be null";
        assert (cache != null) : "Parameter 'cache' of method 'getAssignableContainer' must not be null";
        IAssignableContainer assignableContainer = cache.get(node);
        if (assignableContainer == null) {
            assignableContainer = node.getParent(IAssignableContainer.class, new Class[0]);
            assert (assignableContainer != null) : "Parameter 'assignableContainer' of method 'getOutgoing' must not be null";
            cache.put(node, assignableContainer);
        }
        return assignableContainer;
    }

    private static void incWeight(ArchitecturalViewNode to, Map<ArchitecturalViewNode, Weight> outgoing, ExplorationViewRepresentation representation) {
        assert (to != null) : "Parameter 'to' of method 'incWeight' must not be null";
        assert (outgoing != null) : "Parameter 'outgoing' of method 'incWeight' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'incWeight' must not be null";
        Weight weight = outgoing.get(to);
        if (weight == null) {
            weight = new Weight();
            outgoing.put(to, weight);
        }
        weight.inc();
    }

    static Map<ArchitecturalViewNode, Weight> getOutgoing(ArchitecturalViewNode node, AssignablesOnly assignablesOnly, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'getOutgoing' must not be null";
        assert (!node.isSuppressed()) : "'node' is surpressed";
        assert (representation != null) : "Parameter 'representation' of method 'getOutgoing' must not be null";
        if (node.isExternal()) {
            return Collections.emptyMap();
        }
        THashMap outgoing = new THashMap();
        ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
        if (assignablesOnly == null) {
            for (ProgrammingElement nextProgrammingElement : node.getRelevantProgrammingElements()) {
                Iterator<ParserDependency> depIter = nextProgrammingElement.getDependencyIterator();
                while (depIter.hasNext()) {
                    ArchitecturalViewNode nextToNode;
                    ParserDependency nextParserDependency = depIter.next();
                    if (!representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded() || (nextToNode = representation.getLeafNode(endPoints.getTo())) == null) continue;
                    assert (nextToNode != null) : "'nextToNode' of method 'getOutgoing' must not be null";
                    assert (!nextToNode.isSuppressed()) : "'nextToNode' is surpressed";
                    DependencyHandler.incWeight(nextToNode, (Map<ArchitecturalViewNode, Weight>)outgoing, representation);
                }
            }
        } else {
            Map<ArtifactPropertiesNode, Set<ArtifactPropertiesNode>> fromToArtifactDependencies = assignablesOnly.getFromToArtifactDependencies();
            Map<ArchitecturalViewNode, IAssignableContainer> cache = assignablesOnly.getCache();
            IAssignableContainer fromNodeContainer = DependencyHandler.getAssignableContainer(node, cache);
            for (ProgrammingElement nextProgrammingElement : node.getRelevantProgrammingElements()) {
                Iterator<ParserDependency> depIter = nextProgrammingElement.getDependencyIterator();
                while (depIter.hasNext()) {
                    ArchitecturalViewElement to;
                    ArchitecturalViewNode nextToNode;
                    ParserDependency nextParserDependency = depIter.next();
                    if (!representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, false, endPoints).isIncluded() || (nextToNode = representation.getLeafNode(endPoints.getTo())) == null) continue;
                    assert (nextToNode != null) : "'nextToNode' of method 'getOutgoing' must not be null";
                    assert (!nextToNode.isSuppressed()) : "'nextToNode' is surpressed";
                    IAssignableContainer toNodeContainer = DependencyHandler.getAssignableContainer(nextToNode, cache);
                    if (fromNodeContainer == toNodeContainer) {
                        DependencyHandler.incWeight(nextToNode, (Map<ArchitecturalViewNode, Weight>)outgoing, representation);
                        continue;
                    }
                    ArchitecturalViewElement from = fromNodeContainer.getArchitecturalViewElement();
                    if (!(from instanceof ArtifactPropertiesNode) || !((to = toNodeContainer.getArchitecturalViewElement()) instanceof ArtifactPropertiesNode)) continue;
                    ArtifactPropertiesNode fromArtifact = (ArtifactPropertiesNode)from;
                    ArtifactPropertiesNode toArtifact = (ArtifactPropertiesNode)to;
                    THashSet toArtifacts = fromToArtifactDependencies.get(fromArtifact);
                    if (toArtifacts == null) {
                        toArtifacts = new THashSet();
                        fromToArtifactDependencies.put(fromArtifact, (Set<ArtifactPropertiesNode>)toArtifacts);
                    }
                    toArtifacts.add((ArtifactPropertiesNode)toArtifact);
                }
            }
        }
        return outgoing;
    }

    private static List<ArchitecturalViewNode> collect(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'collect' must not be null";
        LOGGER.debug("Collect nodes with potential dependencies");
        ArrayList<ArchitecturalViewNode> nodes = new ArrayList<ArchitecturalViewNode>();
        NodesWithPotentialDependenciesCollector visitor = new NodesWithPotentialDependenciesCollector((IWorkerContext)DefaultWorkerContext.INSTANCE, nodes);
        for (ArchitecturalViewNode next : representation.getVisibleNodeChildren()) {
            next.accept(visitor);
        }
        if (LOGGER.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder("Collect nodes with potential dependencies - done (");
            builder.append(nodes.size()).append(")");
            int i = 1;
            for (ArchitecturalViewNode next : nodes) {
                builder.append("\n(").append(i).append(") [").append(next.getClass().getSimpleName()).append("] ").append(next.getName());
                ++i;
            }
            LOGGER.trace(builder.toString());
        }
        return nodes;
    }

    private static void createDependencies(List<ArchitecturalViewNode> nodes, ExplorationViewRepresentation representation, IDependencyProcessorCreator creator) {
        Object partialNodesCollector;
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'createDependencies' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'createDependencies' must not be null";
        assert (creator != null) : "Parameter 'creator' of method 'createDependencies' must not be null";
        boolean skipExternal = creator.skipExternal();
        int threads = Math.max(Runtime.getRuntime().availableProcessors() - 2, 1);
        boolean useExecutorService = false;
        if (threads > 1) {
            int minimumNumberOfProgrammingElements = 50000;
            int numberOfProgrammingElements = 0;
            for (ArchitecturalViewNode nextNode : nodes) {
                assert (nextNode.isVisible()) : "Not visible: " + nextNode.getElementInfo();
                if (skipExternal && nextNode.isExternal() || (numberOfProgrammingElements += nextNode.getRelevantProgrammingElements().size()) < 50000) continue;
                useExecutorService = true;
                break;
            }
        }
        int processorId = 1;
        if (useExecutorService) {
            LOGGER.debug("Using executor service with " + threads + " threads");
            ExecutorService executorService = Executors.newFixedThreadPool(threads);
            partialNodesCollector = Collections.synchronizedSet(new THashSet());
            int maxPerProcessor = 10000;
            DependencyProcessor currentProcessor = null;
            int numberOfProgrammingElementsInProcessor = 0;
            for (ArchitecturalViewNode nextNode : nodes) {
                assert (nextNode.isVisible()) : "Not visible: " + nextNode.getElementInfo();
                if (skipExternal && nextNode.isExternal()) continue;
                if (currentProcessor != null && !currentProcessor.isEmpty()) {
                    LOGGER.debug("Submit processor: " + String.valueOf(currentProcessor));
                    executorService.submit(currentProcessor);
                }
                currentProcessor = creator.create(processorId, representation, nextNode, (Set<ArchitecturalViewNode>)partialNodesCollector);
                ++processorId;
                for (ProgrammingElement nextProgrammingElement : nextNode.getRelevantProgrammingElements()) {
                    currentProcessor.addProgrammingElement(nextProgrammingElement);
                    if (++numberOfProgrammingElementsInProcessor < 10000) continue;
                    LOGGER.debug("Submit processor: " + String.valueOf(currentProcessor));
                    assert (!currentProcessor.isEmpty()) : "Processor is empty: " + String.valueOf(currentProcessor);
                    executorService.submit(currentProcessor);
                    currentProcessor = creator.create(processorId, representation, nextNode, (Set<ArchitecturalViewNode>)partialNodesCollector);
                    ++processorId;
                    numberOfProgrammingElementsInProcessor = 0;
                }
            }
            if (currentProcessor != null && !currentProcessor.isEmpty()) {
                LOGGER.debug("Submit processor: " + String.valueOf(currentProcessor));
                executorService.submit(currentProcessor);
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Executor service exception", (Throwable)e);
            }
        } else {
            LOGGER.debug("Not using executor service");
            partialNodesCollector = new THashSet();
            for (ArchitecturalViewNode nextNode : nodes) {
                assert (nextNode.isVisible()) : "Not visible: " + nextNode.getElementInfo();
                if (skipExternal && nextNode.isExternal()) continue;
                DependencyProcessor nextDependencyProcessor = creator.create(processorId, representation, nextNode, (Set<ArchitecturalViewNode>)partialNodesCollector);
                nextDependencyProcessor.addProgrammingElements(nextNode.getRelevantProgrammingElements());
                nextDependencyProcessor.run();
                ++processorId;
            }
        }
        nodes.forEach(n -> n.finishDependenciesModification(representation));
        partialNodesCollector.forEach(n -> FocusApplyVisitor.hasPartialDependencies(n));
    }

    static void createDependencies(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'createDependencies' must not be null";
        long start = System.currentTimeMillis();
        LOGGER.debug("Create dependencies");
        List<ArchitecturalViewNode> nodes = DependencyHandler.collect(representation);
        if (!nodes.isEmpty()) {
            DependencyHandler.createDependencies(nodes, representation, new IDependencyProcessorCreator(){

                @Override
                public DependencyProcessor create(int id, ExplorationViewRepresentation representation, ArchitecturalViewNode node, Set<ArchitecturalViewNode> partialNodesCollector) {
                    if (!$assertionsDisabled && representation == null) {
                        throw new AssertionError((Object)"Parameter 'representation' of method 'create' must not be null");
                    }
                    if (!$assertionsDisabled && node == null) {
                        throw new AssertionError((Object)"Parameter 'node' of method 'create' must not be null");
                    }
                    if (!$assertionsDisabled && partialNodesCollector == null) {
                        throw new AssertionError((Object)"Parameter 'partialNodesCollector' of method 'create' must not be null");
                    }
                    return new CreationDependencyProcessor(id, representation, node, partialNodesCollector);
                }

                @Override
                public boolean skipExternal() {
                    return true;
                }
            });
        }
        LOGGER.debug("Create dependencies of " + nodes.size() + " node(s) - done [" + (System.currentTimeMillis() - start) + " ms]");
    }

    static void createDependenciesInExpandOrCollapse(List<ArchitecturalViewNode> nodes, ExplorationViewRepresentation representation) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'createDependenciesInExpandOrCollapse' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'createDependenciesInExpandOrCollapse' must not be null";
        long start = System.currentTimeMillis();
        LOGGER.debug("Create incoming and outgoing dependencies of " + nodes.size() + " node(s) in expand or collapse");
        DependencyHandler.createDependencies(nodes, representation, new IDependencyProcessorCreator(){

            @Override
            public DependencyProcessor create(int id, ExplorationViewRepresentation representation, ArchitecturalViewNode node, Set<ArchitecturalViewNode> partialNodesCollector) {
                if (!$assertionsDisabled && representation == null) {
                    throw new AssertionError((Object)"Parameter 'representation' of method 'create' must not be null");
                }
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'create' must not be null");
                }
                if (!$assertionsDisabled && partialNodesCollector == null) {
                    throw new AssertionError((Object)"Parameter 'partialNodesCollector' of method 'create' must not be null");
                }
                return new ExpandCollapseDependencyProcessor(id, representation, node, partialNodesCollector);
            }

            @Override
            public boolean skipExternal() {
                return false;
            }
        });
        LOGGER.debug("Create incoming and outgoing dependencies of " + nodes.size() + " node(s) in expand or collapse - done [" + (System.currentTimeMillis() - start) + " ms]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeDependencies(ArchitecturalViewNode node, boolean preserveNonAggregated, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'removeDependencies' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'removeDependencies' must not be null";
        ExplorationViewRepresentation explorationViewRepresentation = representation;
        synchronized (explorationViewRepresentation) {
            Iterator<ArchitecturalViewNode.ArchitecturalViewDependency> inIter = node.getIncomingDependenciesIterator();
            while (inIter.hasNext()) {
                ArchitecturalViewNode.ArchitecturalViewDependency nextIn = inIter.next();
                if (preserveNonAggregated && !DependencyHandler.removeAggregatedParserDependencies(node, nextIn)) continue;
                ArchitecturalViewNode nextFrom = nextIn.getFrom();
                nextFrom.removeDependencyTo(nextIn);
                nextIn.removed();
                inIter.remove();
            }
            Iterator<ArchitecturalViewNode.ArchitecturalViewDependency> outIter = node.getOutgoingDependenciesIterator();
            while (outIter.hasNext()) {
                ArchitecturalViewNode.ArchitecturalViewDependency nextOut = outIter.next();
                if (preserveNonAggregated && !DependencyHandler.removeAggregatedParserDependencies(node, nextOut)) continue;
                ArchitecturalViewNode nextTo = nextOut.getTo();
                nextTo.removeDependencyFrom(nextOut);
                nextOut.removed();
                outIter.remove();
            }
            node.finishDependenciesModification(representation);
        }
    }

    static void removeDependencies(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'removeDependencies' must not be null";
        DependencyHandler.collect(representation).forEach(n -> DependencyHandler.removeDependencies(n, false, representation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateDependencies(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'updateDependencies' must not be null";
        ExplorationViewRepresentation explorationViewRepresentation = representation;
        synchronized (explorationViewRepresentation) {
            DependencyHandler.collect(representation).forEach(n -> n.getOutgoingDependencies().forEach(d -> d.update(representation)));
        }
    }

    private static boolean isValidDependency(ArchitecturalViewNode from, ArchitecturalViewNode to) {
        assert (from != null) : "Parameter 'from' of method 'isValidDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isValidDependency' must not be null";
        if (from != to) {
            return true;
        }
        return from instanceof IProgrammingElementNode;
    }

    static List<ParserDependency> isDeleteDependenciesPossible(PresentationMode presentationMode, ArchitecturalViewNode from, boolean fromIsAggregated, ArchitecturalViewNode to, boolean toIsAggregated, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'isDeleteDependenciesPossible' must not be null";
        assert (from != null) : "Parameter 'from' of method 'isDeleteDependenciesPossible' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isDeleteDependenciesPossible' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'isDeleteDependenciesPossible' must not be null";
        if (DependencyHandler.isValidDependency(from, to)) {
            THashSet fromProgrammingElements = !fromIsAggregated && from instanceof IProgrammingElementNode ? new THashSet(((IProgrammingElementNode)((Object)from)).getUnderlyingProgrammingElements()) : new THashSet(from.getRelevantProgrammingElements(NodeHandler.recursively(from, presentationMode) == null));
            THashSet toProgrammingElements = !toIsAggregated && to instanceof IProgrammingElementNode ? new THashSet(((IProgrammingElementNode)((Object)to)).getUnderlyingProgrammingElements()) : new THashSet(to.getRelevantProgrammingElements(NodeHandler.recursively(to, presentationMode) == null));
            ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
            ArrayList<ParserDependency> parserDependencies = new ArrayList<ParserDependency>();
            for (ProgrammingElement nextFrom : fromProgrammingElements) {
                Iterator<ParserDependency> depIter = nextFrom.getDependencyIterator();
                while (depIter.hasNext()) {
                    ParserDependency nextParserDependency = depIter.next();
                    if (representation.includeOutgoingParserDependency(nextFrom, nextParserDependency, true, endPoints).isIncluded() && toProgrammingElements.contains(endPoints.getTo())) {
                        parserDependencies.add(nextParserDependency);
                    }
                    endPoints.reset();
                }
            }
            return parserDependencies;
        }
        return Collections.emptyList();
    }

    private static boolean isAggregated(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'isAggregated' must not be null";
        return node instanceof IProgrammingElementNode ? !node.isExpanded() : true;
    }

    static Set<ParserDependency> aboutToDelete(List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, List<ArchitecturalViewDependencyDescriptor> collector) {
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'aboutToDelete' must not be empty";
        assert (collector != null) : "Parameter 'collector' of method 'aboutToDelete' must not be null";
        THashSet all = new THashSet();
        for (ArchitecturalViewNode.ArchitecturalViewDependency next : dependencies) {
            Collection<ParserDependency> nextParserDependencies = next.getParserDependencies();
            all.addAll(nextParserDependencies);
            collector.add(new ArchitecturalViewDependencyDescriptor(next.getFrom().getRelativePath(), DependencyHandler.isAggregated(next.getFrom()), next.getTo().getRelativePath(), DependencyHandler.isAggregated(next.getTo()), nextParserDependencies.size()));
        }
        return all;
    }

    static final class AssignablesOnly {
        private final Map<ArchitecturalViewNode, IAssignableContainer> m_cache = new THashMap();
        private final Map<ArtifactPropertiesNode, Set<ArtifactPropertiesNode>> m_fromToArtifactDependencies = new THashMap();

        AssignablesOnly() {
        }

        Map<ArchitecturalViewNode, IAssignableContainer> getCache() {
            return this.m_cache;
        }

        Map<ArtifactPropertiesNode, Set<ArtifactPropertiesNode>> getFromToArtifactDependencies() {
            return this.m_fromToArtifactDependencies;
        }
    }

    static final class CreationDependencyProcessor
    extends DependencyProcessor {
        CreationDependencyProcessor(int id, ExplorationViewRepresentation representation, ArchitecturalViewNode node, Set<ArchitecturalViewNode> partialNodesCollector) {
            super(id, representation, node, partialNodesCollector);
        }

        @Override
        void process(ExplorationViewRepresentation representation, ArchitecturalViewNode node, List<ProgrammingElement> programmingElements, Set<ArchitecturalViewNode> partialNodesCollector) {
            assert (representation != null) : "Parameter 'representation' of method 'process' must not be null";
            assert (node != null) : "Parameter 'node' of method 'process' must not be null";
            assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'process' must not be empty";
            assert (partialNodesCollector != null) : "Parameter 'partialNodesCollector' of method 'process' must not be null";
            THashMap mappedToLeafNode = new THashMap(50);
            ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
            for (ProgrammingElement nextProgrammingElement : programmingElements) {
                Iterator<ParserDependency> depIter = nextProgrammingElement.getDependencyIterator();
                while (depIter.hasNext()) {
                    ParserDependency nextParserDependency = depIter.next();
                    ParserDependencyState includeOutgoing = representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, true, endPoints);
                    if (includeOutgoing.isIncluded()) {
                        ArchitecturalViewNode nextToNode = DependencyHandler.getToNodeOfOutgoingDependency(node, (Map<ArchitecturalViewNode, ArchitecturalViewNode>)mappedToLeafNode, endPoints, representation);
                        if (nextToNode != null) {
                            node.addDependendencyTo(nextToNode, nextParserDependency, false);
                        }
                    } else if (includeOutgoing == ParserDependencyState.EXCLUDED_BY_FOCUS) {
                        partialNodesCollector.add(node);
                    }
                    endPoints.reset();
                }
            }
        }
    }

    static abstract class DependencyProcessor
    implements Runnable {
        private final List<ProgrammingElement> m_programmingElements = new ArrayList<ProgrammingElement>(10000);
        private final Set<ArchitecturalViewNode> m_partialNodesCollector;
        private final ExplorationViewRepresentation m_representation;
        private final ArchitecturalViewNode m_node;
        private final int m_id;

        DependencyProcessor(int id, ExplorationViewRepresentation representation, ArchitecturalViewNode node, Set<ArchitecturalViewNode> partialNodesCollector) {
            assert (representation != null) : "Parameter 'representation' of method 'DependencyProcessor' must not be null";
            assert (node != null) : "Parameter 'node' of method 'DependencyProcessor' must not be null";
            assert (partialNodesCollector != null) : "Parameter 'partialNodesCollector' of method 'DependencyProcessor' must not be null";
            this.m_partialNodesCollector = partialNodesCollector;
            this.m_representation = representation;
            this.m_node = node;
            this.m_id = id;
        }

        final void addProgrammingElement(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'addProgrammingElement' must not be null";
            this.m_programmingElements.add(element);
        }

        final void addProgrammingElements(Collection<ProgrammingElement> elements) {
            assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'addProgrammingElements' must not be empty";
            this.m_programmingElements.addAll(elements);
        }

        abstract void process(ExplorationViewRepresentation var1, ArchitecturalViewNode var2, List<ProgrammingElement> var3, Set<ArchitecturalViewNode> var4);

        @Override
        public final void run() {
            this.process(this.m_representation, this.m_node, this.m_programmingElements, this.m_partialNodesCollector);
        }

        final int getNumberOfProgrammingElements() {
            return this.m_programmingElements.size();
        }

        final boolean isEmpty() {
            return this.m_programmingElements.isEmpty();
        }

        public final String toString() {
            return "<" + this.m_id + "> [" + String.valueOf(this.m_node.getClass()) + "] " + this.m_node.getName() + ": " + this.getNumberOfProgrammingElements();
        }
    }

    static final class ExpandCollapseDependencyProcessor
    extends DependencyProcessor {
        ExpandCollapseDependencyProcessor(int id, ExplorationViewRepresentation representation, ArchitecturalViewNode node, Set<ArchitecturalViewNode> partialNodesCollector) {
            super(id, representation, node, partialNodesCollector);
        }

        @Override
        void process(ExplorationViewRepresentation representation, ArchitecturalViewNode node, List<ProgrammingElement> programmingElements, Set<ArchitecturalViewNode> partialNodesCollector) {
            assert (representation != null) : "Parameter 'representation' of method 'process' must not be null";
            assert (node != null) : "Parameter 'node' of method 'process' must not be null";
            assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'process' must not be empty";
            assert (partialNodesCollector != null) : "Parameter 'partialNodesCollector' of method 'process' must not be null";
            THashMap mappedToLeafNode = new THashMap(50);
            ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
            for (ProgrammingElement nextProgrammingElement : programmingElements) {
                Iterator<ParserDependency> depIter = nextProgrammingElement.getDependencyIterator();
                while (depIter.hasNext()) {
                    ParserDependency nextParserDependency = depIter.next();
                    ParserDependencyState includeOutgoing = representation.includeOutgoingParserDependency(nextProgrammingElement, nextParserDependency, true, endPoints);
                    if (includeOutgoing.isIncluded()) {
                        ArchitecturalViewNode nextToNode = DependencyHandler.getToNodeOfOutgoingDependency(node, (Map<ArchitecturalViewNode, ArchitecturalViewNode>)mappedToLeafNode, endPoints, representation);
                        if (nextToNode != null) {
                            node.addDependendencyTo(nextToNode, nextParserDependency, true);
                        }
                    } else if (includeOutgoing == ParserDependencyState.EXCLUDED_BY_DIRECTION) {
                        ArchitecturalViewNode nextFromNode;
                        if (representation.includeIncomingParserDependency(nextProgrammingElement, nextParserDependency, true, endPoints).isIncluded() && (nextFromNode = DependencyHandler.getFromNodeOfIncomingDependency(node, (Map<ArchitecturalViewNode, ArchitecturalViewNode>)mappedToLeafNode, endPoints, representation)) != null) {
                            node.addDependendencyFromInExpandOrCollapse(nextFromNode, nextParserDependency);
                        }
                    } else if (includeOutgoing == ParserDependencyState.EXCLUDED_BY_FOCUS) {
                        partialNodesCollector.add(node);
                    }
                    endPoints.reset();
                }
            }
        }
    }

    static interface IDependencyProcessorCreator {
        public DependencyProcessor create(int var1, ExplorationViewRepresentation var2, ArchitecturalViewNode var3, Set<ArchitecturalViewNode> var4);

        public boolean skipExternal();
    }
}

