/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.DependencyHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.LeafArtifactPropertiesNodeCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.Weight;
import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAndLevelAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetComputer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.ICycleAndLevelAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchitecturalViewUpwardDependencyMinimizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewUpwardDependencyMinimizer.class);

    private ArchitecturalViewUpwardDependencyMinimizer() {
    }

    private static ArchitecturalViewNode getArchitecturalViewNodeParent(ArchitecturalViewNode node, ExplorationViewSortMode mode) {
        assert (node != null) : "Parameter 'node' of method 'getArchitecturalViewNodeParent' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'getArchitecturalViewNodeParent' must not be null";
        assert (!node.isSuppressed()) : "Node is supressed: " + node.getElementInfo();
        switch (mode) {
            case LEVELIZE_ALL: {
                return node.getNodeParent();
            }
            case LEVELIZE: {
                ArchitecturalViewNode parent = node.getNodeParent();
                return !(parent instanceof ArtifactPropertiesNode) ? parent : null;
            }
        }
        assert (false) : "Unhandled mode: " + String.valueOf((Object)mode);
        return null;
    }

    private static ArchitecturalViewNodeProxy getOrCreateParentArchitecturalViewNodeProxy(ArchitecturalViewNode leafNode, Map<ArchitecturalViewNode, ArchitecturalViewNodeProxy> nodeToNodeProxy, List<ArchitecturalViewNodeProxy> nonLeafNodeProxies, ExplorationViewSortMode mode) {
        assert (leafNode != null) : "Parameter 'leafNode' of method 'getOrCreateParentArchitecturalViewNodeProxy' must not be null";
        assert (!leafNode.isSuppressed()) : "Node is supressed: " + leafNode.getElementInfo();
        assert (nodeToNodeProxy != null) : "Parameter 'nodeToNodeProxy' of method 'getOrCreateParentArchitecturalViewNodeProxy' must not be null";
        assert (nonLeafNodeProxies != null) : "Parameter 'nonLeafNodeProxies' of method 'getOrCreateParentArchitecturalViewNodeProxy' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'getOrCreateParentArchitecturalViewNodeProxy' must not be null";
        ArchitecturalViewNodeProxy directParentNodeProxy = null;
        ArchitecturalViewNode currentParentNode = ArchitecturalViewUpwardDependencyMinimizer.getArchitecturalViewNodeParent(leafNode, mode);
        ArchitecturalViewNodeProxy lastCreated = null;
        while (currentParentNode != null) {
            ArchitecturalViewNodeProxy currentParentNodeProxy = nodeToNodeProxy.get(currentParentNode);
            if (currentParentNodeProxy == null) {
                currentParentNodeProxy = new ArchitecturalViewNodeProxy(currentParentNode);
                nonLeafNodeProxies.add(currentParentNodeProxy);
                if (lastCreated != null) {
                    currentParentNodeProxy.addChild(lastCreated);
                }
                lastCreated = currentParentNodeProxy;
                nodeToNodeProxy.put(currentParentNode, currentParentNodeProxy);
                currentParentNode = ArchitecturalViewUpwardDependencyMinimizer.getArchitecturalViewNodeParent(currentParentNode, mode);
            } else {
                if (lastCreated != null) {
                    currentParentNodeProxy.addChild(lastCreated);
                }
                currentParentNode = null;
            }
            if (directParentNodeProxy != null) continue;
            assert (currentParentNodeProxy != null) : "'currentParentNodeProxy' of method 'getOrCreateParentNodeProxy' must not be null";
            directParentNodeProxy = currentParentNodeProxy;
        }
        return directParentNodeProxy;
    }

    private static void processCycleGroups(IWorkerContext workerContext, Map<Integer, Set<ArchitecturalViewNodeProxy>> cycleGroupIndexToCycleGroup) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'processCycleGroups' must not be null";
        assert (cycleGroupIndexToCycleGroup != null) : "Parameter 'cycleGroupIndexToCycleGroup' of method 'processCycleGroups' must not be null";
        if (!cycleGroupIndexToCycleGroup.isEmpty()) {
            for (final Set<ArchitecturalViewNodeProxy> nextCycleGroup : cycleGroupIndexToCycleGroup.values()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                Set<INode.IEdge> nextFas = FeedbackArcSetComputer.compute(workerContext, nextCycleGroup);
                THashMap fromTo = new THashMap(nextFas.size());
                for (INode.IEdge nextEdge : nextFas) {
                    Set to = (Set)fromTo.get(nextEdge.getFrom());
                    if (to == null) {
                        to = new THashSet(5);
                        fromTo.put((ArchitecturalViewNodeProxy)nextEdge.getFrom(), to);
                    }
                    to.add((ArchitecturalViewNodeProxy)nextEdge.getTo());
                }
                CycleAndLevelAnalyzer.process(new ICycleAndLevelAnalyzerAdapter<ArchitecturalViewNodeProxy>((Map)fromTo){
                    private final /* synthetic */ Map val$fromTo;
                    {
                        this.val$fromTo = map;
                    }

                    @Override
                    public Collection<ArchitecturalViewNodeProxy> getIncoming(ArchitecturalViewNodeProxy node) {
                        if (!$assertionsDisabled && node == null) {
                            throw new AssertionError((Object)"Parameter 'node' of method 'getIncoming' must not be null");
                        }
                        return node.getIncoming().keySet().stream().filter(in -> {
                            if (nextCycleGroup.contains(in)) {
                                Set to = (Set)this.val$fromTo.get(in);
                                return to == null ? true : !to.contains(node);
                            }
                            return false;
                        }).collect(Collectors.toList());
                    }

                    @Override
                    public Collection<ArchitecturalViewNodeProxy> getOutgoing(ArchitecturalViewNodeProxy node) {
                        if (!$assertionsDisabled && node == null) {
                            throw new AssertionError((Object)"Parameter 'node' of method 'getOutgoing' must not be null");
                        }
                        return node.getOutgoing().keySet().stream().filter(out -> {
                            if (nextCycleGroup.contains(out)) {
                                Set to = (Set)this.val$fromTo.get(node);
                                return to == null ? true : !to.contains(out);
                            }
                            return false;
                        }).collect(Collectors.toList());
                    }

                    @Override
                    public void setIsCyclic(ArchitecturalViewNodeProxy node, int cycleIndex) {
                        if (!$assertionsDisabled && node == null) {
                            throw new AssertionError((Object)"Parameter 'node' of method 'setIsCyclic' must not be null");
                        }
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("No cyclic node expected: " + String.valueOf(node)));
                        }
                    }

                    @Override
                    public void setLevel(ArchitecturalViewNodeProxy node, int level) {
                        if (!$assertionsDisabled && node == null) {
                            throw new AssertionError((Object)"Parameter 'node' of method 'setLevel' must not be null");
                        }
                        node.setLevelInCycle(level);
                    }
                }, nextCycleGroup, true, workerContext);
            }
        }
    }

    private static void levelize(IWorkerContext workerContext, ArchitecturalViewElement parent, List<ArchitecturalViewNodeProxy> nodeProxies, ExplorationViewSortMode mode, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'levelize' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'levelize' must not be null";
        assert (nodeProxies != null) : "Parameter 'nodeProxies' of method 'levelize' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'levelize' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'levelize' must not be null";
        THashMap cycleGroupIndexToCycleGroup = new THashMap();
        CycleAndLevelAnalyzer.process(new ICycleAndLevelAnalyzerAdapter<ArchitecturalViewNodeProxy>((Map)cycleGroupIndexToCycleGroup){
            private final /* synthetic */ Map val$cycleGroupIndexToCycleGroup;
            {
                this.val$cycleGroupIndexToCycleGroup = map;
            }

            @Override
            public Collection<ArchitecturalViewNodeProxy> getIncoming(ArchitecturalViewNodeProxy node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'getIncoming' must not be null");
                }
                return node.getIncoming().keySet();
            }

            @Override
            public Collection<ArchitecturalViewNodeProxy> getOutgoing(ArchitecturalViewNodeProxy node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'getOutgoing' must not be null");
                }
                return node.getOutgoing().keySet();
            }

            @Override
            public void setIsCyclic(ArchitecturalViewNodeProxy node, int cycleIndex) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'setIsCyclic' must not be null");
                }
                node.setCycleIndex(cycleIndex);
                Integer cycleGroupIndexAsInteger = cycleIndex;
                Set cycleGroup = (Set)this.val$cycleGroupIndexToCycleGroup.get(cycleGroupIndexAsInteger);
                if (cycleGroup == null) {
                    cycleGroup = new THashSet();
                    this.val$cycleGroupIndexToCycleGroup.put(cycleGroupIndexAsInteger, cycleGroup);
                }
                cycleGroup.add(node);
            }

            @Override
            public void setLevel(ArchitecturalViewNodeProxy node, int level) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'setLevel' must not be null");
                }
                node.setLevel(level);
            }
        }, nodeProxies, true, workerContext);
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        ArchitecturalViewUpwardDependencyMinimizer.processCycleGroups(workerContext, (Map<Integer, Set<ArchitecturalViewNodeProxy>>)cycleGroupIndexToCycleGroup);
        Collections.sort(nodeProxies, new NodeComparator(representation));
        switch (mode) {
            case LEVELIZE_ALL: {
                int nodePos = 0;
                for (ArchitecturalViewNodeProxy next : nodeProxies) {
                    next.getNode().setRelativeIndex(nodePos);
                    ++nodePos;
                }
                break;
            }
            case LEVELIZE: {
                int nodePos = parent.getNumberOfChildren(ArtifactPropertiesNode.class);
                for (ArchitecturalViewNodeProxy next : nodeProxies) {
                    ArchitecturalViewNode nextNode = next.getNode();
                    assert (!(nextNode instanceof ArtifactPropertiesNode)) : "Unexpected artifact node: " + nextNode.getElementInfo(true, false);
                    nextNode.setRelativeIndex(nodePos);
                    ++nodePos;
                }
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)mode);
                break;
            }
        }
    }

    private static ArtifactPropertiesNodeProxy getOrCreateParentArtifactPropertiesNodeProxy(ArtifactPropertiesNode leafArtifact, Map<ArtifactPropertiesNode, ArtifactPropertiesNodeProxy> nodeToNodeProxy) {
        assert (leafArtifact != null) : "Parameter 'leafArtifact' of method 'getOrCreateParentArtifactPropertiesNodeProxy' must not be null";
        assert (nodeToNodeProxy != null) : "Parameter 'nodeToNodeProxy' of method 'getOrCreateParentArtifactPropertiesNodeProxy' must not be null";
        ArtifactPropertiesNodeProxy directParentNodeProxy = null;
        ArtifactPropertiesNode currentParentNode = leafArtifact.getParent(ArtifactPropertiesNode.class, ParentMode.ONLY_DIRECT_PARENT);
        NodeProxy lastCreated = null;
        while (currentParentNode != null) {
            ArtifactPropertiesNodeProxy currentParentNodeProxy = nodeToNodeProxy.get(currentParentNode);
            if (currentParentNodeProxy == null) {
                currentParentNodeProxy = new ArtifactPropertiesNodeProxy(currentParentNode);
                if (lastCreated != null) {
                    lastCreated.setParent(currentParentNodeProxy);
                }
                lastCreated = currentParentNodeProxy;
                nodeToNodeProxy.put(currentParentNode, currentParentNodeProxy);
                currentParentNode = currentParentNode.getParent(ArtifactPropertiesNode.class, ParentMode.ONLY_DIRECT_PARENT);
            } else {
                if (lastCreated != null) {
                    lastCreated.setParent(currentParentNodeProxy);
                }
                currentParentNode = null;
            }
            if (directParentNodeProxy != null) continue;
            assert (currentParentNodeProxy != null) : "'currentParentNodeProxy' of method 'getOrCreateParentNodeProxy' must not be null";
            directParentNodeProxy = currentParentNodeProxy;
        }
        return directParentNodeProxy;
    }

    private static void analyzeArtifactCycles(IWorkerContext workerContext, Map<ArtifactPropertiesNode, Set<ArtifactPropertiesNode>> fromToArtifactDependencies, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'analyzeArtifactCycles' must not be null";
        assert (fromToArtifactDependencies != null && !fromToArtifactDependencies.isEmpty()) : "Parameter 'fromToArtifactDependencies' of method 'analyzeArtifactCycles' must not be empty";
        THashMap artifactToProxy = new THashMap();
        ArrayList<ArtifactPropertiesNode> leafArtifacts = new ArrayList<ArtifactPropertiesNode>();
        representation.accept(new LeafArtifactPropertiesNodeCollector(leafArtifacts));
        for (ArtifactPropertiesNode artifactPropertiesNode : leafArtifacts) {
            ArtifactPropertiesNodeProxy nextLeafProxy = new ArtifactPropertiesNodeProxy(artifactPropertiesNode);
            artifactToProxy.put(artifactPropertiesNode, nextLeafProxy);
            ArtifactPropertiesNodeProxy nextParentProxy = ArchitecturalViewUpwardDependencyMinimizer.getOrCreateParentArtifactPropertiesNodeProxy(artifactPropertiesNode, (Map<ArtifactPropertiesNode, ArtifactPropertiesNodeProxy>)artifactToProxy);
            if (nextParentProxy == null) continue;
            nextLeafProxy.setParent(nextParentProxy);
        }
        for (Map.Entry entry : fromToArtifactDependencies.entrySet()) {
            ArtifactPropertiesNode nextFrom = (ArtifactPropertiesNode)entry.getKey();
            ArtifactPropertiesNodeProxy nextFromNodeProxy = (ArtifactPropertiesNodeProxy)artifactToProxy.get(nextFrom);
            assert (nextFromNodeProxy != null) : "'nextFromNodeProxy' of method 'analyzeArtifactCycles' must not be null";
            ArtifactPropertiesNodeProxy nextFromNodeProxyParent = (ArtifactPropertiesNodeProxy)nextFromNodeProxy.getParent();
            for (ArtifactPropertiesNode nextTo : (Set)entry.getValue()) {
                ArtifactPropertiesNodeProxy nextToNodeProxy = (ArtifactPropertiesNodeProxy)artifactToProxy.get(nextTo);
                assert (nextToNodeProxy != null) : "'nextToNodeProxy' of method 'analyzeArtifactCycles' must not be null";
                ArtifactPropertiesNodeProxy nextToNodeProxyParent = (ArtifactPropertiesNodeProxy)nextToNodeProxy.getParent();
                if (nextFromNodeProxyParent == nextToNodeProxyParent) {
                    nextFromNodeProxy.addOutgoing(nextToNodeProxy);
                    continue;
                }
                if (nextFromNodeProxyParent == null) {
                    assert (nextToNodeProxyParent != null) : "Parameter 'nextToNodeProxyParent' of method 'analyzeArtifactCycles' must not be null";
                    ArtifactPropertiesNodeProxy currentToNodeProxy = nextToNodeProxyParent;
                    while (currentToNodeProxy.getParent() != null) {
                        currentToNodeProxy = (ArtifactPropertiesNodeProxy)currentToNodeProxy.getParent();
                    }
                    nextFromNodeProxy.addOutgoing(currentToNodeProxy);
                    continue;
                }
                if (nextToNodeProxyParent == null) {
                    assert (nextFromNodeProxyParent != null) : "Parameter 'nextFromNodeProxyParent' of method 'analyzeArtifactCycles' must not be null";
                    ArtifactPropertiesNodeProxy currentFromNodeProxy = nextFromNodeProxyParent;
                    while (currentFromNodeProxy.getParent() != null) {
                        currentFromNodeProxy = (ArtifactPropertiesNodeProxy)currentFromNodeProxy.getParent();
                    }
                    currentFromNodeProxy.addOutgoing(nextToNodeProxy);
                    continue;
                }
                int nextFromNodeProxyParentDepth = nextFromNodeProxyParent.getProxyDepth();
                int nextToNodeProxyParentDepth = nextToNodeProxyParent.getProxyDepth();
                ArtifactPropertiesNodeProxy currentFromNodeProxyParent = nextFromNodeProxyParent;
                ArtifactPropertiesNodeProxy currentToNodeProxyParent = nextToNodeProxyParent;
                if (nextFromNodeProxyParentDepth > nextToNodeProxyParentDepth) {
                    while ((currentFromNodeProxyParent = (ArtifactPropertiesNodeProxy)currentFromNodeProxyParent.getParent()) != null && currentFromNodeProxyParent.getProxyDepth() > nextToNodeProxyParentDepth) {
                    }
                } else if (nextToNodeProxyParentDepth > nextFromNodeProxyParentDepth) {
                    while ((currentToNodeProxyParent = (ArtifactPropertiesNodeProxy)currentToNodeProxyParent.getParent()) != null && currentToNodeProxyParent.getProxyDepth() > nextFromNodeProxyParentDepth) {
                    }
                }
                while (currentFromNodeProxyParent != null && currentToNodeProxyParent != null && currentFromNodeProxyParent.getParent() != currentToNodeProxyParent.getParent()) {
                    currentFromNodeProxyParent = (ArtifactPropertiesNodeProxy)currentFromNodeProxyParent.getParent();
                    currentToNodeProxyParent = (ArtifactPropertiesNodeProxy)currentToNodeProxyParent.getParent();
                }
                if (currentFromNodeProxyParent == null || currentToNodeProxyParent == null) continue;
                currentFromNodeProxyParent.addOutgoing(currentToNodeProxyParent);
            }
        }
        CycleAndLevelAnalyzer.process(new ICycleAndLevelAnalyzerAdapter<ArtifactPropertiesNodeProxy>(){

            @Override
            public Collection<ArtifactPropertiesNodeProxy> getIncoming(ArtifactPropertiesNodeProxy node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'getIncoming' must not be null");
                }
                return node.getIncoming();
            }

            @Override
            public Collection<ArtifactPropertiesNodeProxy> getOutgoing(ArtifactPropertiesNodeProxy node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'getOutgoing' must not be null");
                }
                return node.getOutgoing();
            }

            @Override
            public void setIsCyclic(ArtifactPropertiesNodeProxy node, int cycleIndex) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'setIsCyclic' must not be null");
                }
                node.setCycleIndex(cycleIndex);
            }

            @Override
            public void setLevel(ArtifactPropertiesNodeProxy node, int level) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'setLevel' must not be null");
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unexpected");
                }
            }
        }, artifactToProxy.values(), false, workerContext);
    }

    private static DependencyHandler.AssignablesOnly getAssignablesOnly(ExplorationViewSortMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'getAssignablesOnly' must not be null";
        switch (mode) {
            case LEVELIZE_ALL: {
                return null;
            }
            case LEVELIZE: {
                return new DependencyHandler.AssignablesOnly();
            }
        }
        assert (false) : "Unhandled mode: " + String.valueOf((Object)mode);
        return null;
    }

    private static void levelize(IWorkerContext workerContext, List<ArchitecturalViewNodeProxy> nonLeafNodeProxies, DependencyHandler.AssignablesOnly assignablesOnly, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'levelize' must not be null";
        assert (nonLeafNodeProxies != null && !nonLeafNodeProxies.isEmpty()) : "Parameter 'nonLeafNodeProxies' of method 'levelize' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'levelize' must not be null";
        ExplorationViewSortMode mode = representation.getSortMode();
        switch (mode) {
            case LEVELIZE_ALL: {
                ArrayList<ArchitecturalViewNodeProxy> inRoot = new ArrayList<ArchitecturalViewNodeProxy>();
                for (ArchitecturalViewNodeProxy nextNonLeafNodeProxy : nonLeafNodeProxies) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    List<ArchitecturalViewNodeProxy> nextChildren = nextNonLeafNodeProxy.getChildren();
                    if (!nextChildren.isEmpty()) {
                        ArchitecturalViewUpwardDependencyMinimizer.levelize(workerContext, nextNonLeafNodeProxy.getNode(), nextChildren, mode, representation);
                    }
                    if (nextNonLeafNodeProxy.getParent() != null) continue;
                    inRoot.add(nextNonLeafNodeProxy);
                }
                assert (!inRoot.isEmpty()) : "'inRoot' of method 'process' must not be empty";
                ArchitecturalViewUpwardDependencyMinimizer.levelize(workerContext, representation, inRoot, mode, representation);
                break;
            }
            case LEVELIZE: {
                THashMap inRoots = new THashMap();
                for (ArchitecturalViewNodeProxy architecturalViewNodeProxy : nonLeafNodeProxies) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    List<ArchitecturalViewNodeProxy> nextChildren = architecturalViewNodeProxy.getChildren();
                    if (!nextChildren.isEmpty()) {
                        ArchitecturalViewUpwardDependencyMinimizer.levelize(workerContext, architecturalViewNodeProxy.getNode(), nextChildren, mode, representation);
                    }
                    if (architecturalViewNodeProxy.getParent() != null) continue;
                    ArchitecturalViewElement nextParent = architecturalViewNodeProxy.getNode().getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextParent != null) : "Parameter 'nextParent' of method 'levelize' must not be null";
                    ArrayList<ArchitecturalViewNodeProxy> nextInRoot = (ArrayList<ArchitecturalViewNodeProxy>)inRoots.get(nextParent);
                    if (nextInRoot == null) {
                        nextInRoot = new ArrayList<ArchitecturalViewNodeProxy>();
                        inRoots.put(nextParent, nextInRoot);
                    }
                    nextInRoot.add(architecturalViewNodeProxy);
                }
                assert (!inRoots.isEmpty()) : "'inRoots' of method 'process' must not be empty";
                for (Map.Entry entry : inRoots.entrySet()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    ArchitecturalViewUpwardDependencyMinimizer.levelize(workerContext, (ArchitecturalViewElement)entry.getKey(), (List)entry.getValue(), mode, representation);
                }
                assert (assignablesOnly != null) : "'assignablesOnly' of method 'process' must not be null";
                if (assignablesOnly.getFromToArtifactDependencies().isEmpty()) break;
                ArchitecturalViewUpwardDependencyMinimizer.analyzeArtifactCycles(workerContext, assignablesOnly.getFromToArtifactDependencies(), representation);
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)mode);
                break;
            }
        }
    }

    static void levelizeCreatedProgrammingElementNodes(IWorkerContext workerContext, List<ProgrammingElementNode> created, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'levelizeCreatedProgrammingElementNodes' must not be null";
        assert (created != null && !created.isEmpty()) : "Parameter 'created' of method 'levelizeCreatedProgrammingElementNodes' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'levelizeCreatedProgrammingElementNodes' must not be null";
        LOGGER.debug("Levelize " + created.size() + " created programming element nodes");
        ArchitecturalViewNode parent = null;
        THashMap nodeToNodeProxy = new THashMap();
        for (ProgrammingElementNode next : created) {
            ArchitecturalViewNode nextParent = next.getNodeParent();
            assert (nextParent != null) : "'nextParent' of method 'levelizeCreatedProgrammingElementNodes' must not be null";
            if (parent == null) {
                parent = nextParent;
            } else assert (parent == nextParent) : "Not same parent";
            nodeToNodeProxy.put(next, new ArchitecturalViewNodeProxy(next));
        }
        for (ArchitecturalViewNodeProxy nextFromNodeProxy : nodeToNodeProxy.values()) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            for (Map.Entry<ArchitecturalViewNode, Weight> nextEntry : DependencyHandler.getOutgoing(nextFromNodeProxy.getNode(), null, representation).entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                ArchitecturalViewNodeProxy nextToNodeProxy = (ArchitecturalViewNodeProxy)nodeToNodeProxy.get(nextEntry.getKey());
                if (nextToNodeProxy == null) continue;
                nextFromNodeProxy.addOutgoing(nextToNodeProxy, nextEntry.getValue());
            }
        }
        assert (parent != null) : "'parent' of method 'levelizeCreatedProgrammingElementNodes' must not be null";
        ArchitecturalViewUpwardDependencyMinimizer.levelize(workerContext, parent, new ArrayList<ArchitecturalViewNodeProxy>(nodeToNodeProxy.values()), ExplorationViewSortMode.LEVELIZE_ALL, representation);
        LOGGER.debug("Levelize " + created.size() + " created programming element nodes - done");
    }

    /*
     * Unable to fully structure code
     */
    static void levelizeLeafNodes(IWorkerContext workerContext, List<ArchitecturalViewNode> leafNodes, ExplorationViewRepresentation representation) {
        if (!ArchitecturalViewUpwardDependencyMinimizer.$assertionsDisabled && workerContext == null) {
            throw new AssertionError((Object)"Parameter 'workerContext' of method 'levelizeLeafNodes' must not be null");
        }
        if (!ArchitecturalViewUpwardDependencyMinimizer.$assertionsDisabled && (leafNodes == null || leafNodes.isEmpty())) {
            throw new AssertionError((Object)"Parameter 'leafNodes' of method 'levelizeLeafNodes' must not be empty");
        }
        if (!ArchitecturalViewUpwardDependencyMinimizer.$assertionsDisabled && representation == null) {
            throw new AssertionError((Object)"Parameter 'representation' of method 'levelizeLeafNodes' must not be null");
        }
        isDebugEnabled = ArchitecturalViewUpwardDependencyMinimizer.LOGGER.isDebugEnabled();
        if (isDebugEnabled) {
            ArchitecturalViewUpwardDependencyMinimizer.LOGGER.debug("Levelize " + leafNodes.size() + " leaf nodes");
        }
        nodeToNodeProxy = new THashMap();
        leafNodeProxies = new ArrayList<ArchitecturalViewNodeProxy>();
        nonLeafNodeProxies = new ArrayList<ArchitecturalViewNodeProxy>();
        mode = representation.getSortMode();
        assignablesOnly = ArchitecturalViewUpwardDependencyMinimizer.getAssignablesOnly(mode);
        for (ArchitecturalViewNode nextLeafNode : leafNodes) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            nextLeafNodeProxy = new ArchitecturalViewNodeProxy(nextLeafNode);
            leafNodeProxies.add(nextLeafNodeProxy);
            nodeToNodeProxy.put(nextLeafNode, nextLeafNodeProxy);
            nextParentNodeProxy = ArchitecturalViewUpwardDependencyMinimizer.getOrCreateParentArchitecturalViewNodeProxy(nextLeafNode, (Map<ArchitecturalViewNode, ArchitecturalViewNodeProxy>)nodeToNodeProxy, nonLeafNodeProxies, mode);
            if (nextParentNodeProxy != null) {
                nextParentNodeProxy.addChild(nextLeafNodeProxy);
                continue;
            }
            if (assignablesOnly != null && nextLeafNode instanceof ArtifactPropertiesNode) continue;
            nextLeafNode.setLevel(1);
            nonLeafNodeProxies.add(nextLeafNodeProxy);
        }
        for (ArchitecturalViewNodeProxy nextFromNodeProxy : leafNodeProxies) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            for (Map.Entry<ArchitecturalViewNode, Weight> nextEntry : DependencyHandler.getOutgoing(nextFromNodeProxy.getNode(), assignablesOnly, representation).entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                nextToNodeProxy = (ArchitecturalViewNodeProxy)nodeToNodeProxy.get(nextEntry.getKey());
                if (nextToNodeProxy == null) continue;
                nextWeight = nextEntry.getValue();
                if (nextFromNodeProxy.getParent() == nextToNodeProxy.getParent()) {
                    nextFromNodeProxy.addOutgoing(nextToNodeProxy, nextWeight);
                    continue;
                }
                currentFromNodeProxy = nextFromNodeProxy;
                currentToNodeProxy = nextToNodeProxy;
                if (currentFromNodeProxy.getProxyDepth() > currentToNodeProxy.getProxyDepth()) {
                    while ((currentFromNodeProxy = (ArchitecturalViewNodeProxy)currentFromNodeProxy.getParent()).getProxyDepth() > currentToNodeProxy.getProxyDepth()) {
                    }
                } else if (nextToNodeProxy.getProxyDepth() > nextFromNodeProxy.getProxyDepth()) {
                    while ((currentToNodeProxy = (ArchitecturalViewNodeProxy)currentToNodeProxy.getParent()).getProxyDepth() > currentFromNodeProxy.getProxyDepth()) {
                    }
                }
                if (ArchitecturalViewUpwardDependencyMinimizer.$assertionsDisabled || currentFromNodeProxy.getProxyDepth() == currentToNodeProxy.getProxyDepth()) ** GOTO lbl65
                throw new AssertionError((Object)("Proxy depth is different (from/to): " + String.valueOf(currentFromNodeProxy) + "/" + String.valueOf(currentToNodeProxy)));
lbl-1000:
                // 1 sources

                {
                    nextParentOfCurrentFromNodeProxy = (ArchitecturalViewNodeProxy)currentFromNodeProxy.getParent();
                    nextParentOfCurrentToNodeProxy = (ArchitecturalViewNodeProxy)currentToNodeProxy.getParent();
                    if (nextParentOfCurrentFromNodeProxy == null) {
                        if (!ArchitecturalViewUpwardDependencyMinimizer.$assertionsDisabled) {
                            throw new AssertionError((Object)("From node proxy parent is null - from/to:\n" + String.valueOf(currentFromNodeProxy) + "/" + String.valueOf(currentToNodeProxy)));
                        }
                    } else if (nextParentOfCurrentToNodeProxy == null) if (!ArchitecturalViewUpwardDependencyMinimizer.$assertionsDisabled) {
                        throw new AssertionError((Object)("To node proxy parent is null - from/to:\n" + String.valueOf(currentFromNodeProxy) + "/" + String.valueOf(currentToNodeProxy)));
                    }
                    currentFromNodeProxy = nextParentOfCurrentFromNodeProxy;
                    currentToNodeProxy = nextParentOfCurrentToNodeProxy;
lbl65:
                    // 2 sources

                    ** while (currentFromNodeProxy.getParent() != currentToNodeProxy.getParent())
                }
lbl66:
                // 1 sources

                currentFromNodeProxy.addOutgoing(currentToNodeProxy, nextWeight);
            }
        }
        ArchitecturalViewUpwardDependencyMinimizer.levelize(workerContext, nonLeafNodeProxies, assignablesOnly, representation);
        if (isDebugEnabled) {
            ArchitecturalViewUpwardDependencyMinimizer.LOGGER.debug("Levelize " + leafNodes.size() + " leaf nodes - done");
        }
    }

    static final class ArchitecturalViewNodeProxy
    extends NodeProxy<ArchitecturalViewNodeProxy>
    implements INode<ArchitecturalViewNodeProxy> {
        private Map<ArchitecturalViewNodeProxy, Weight> m_incoming;
        private Map<ArchitecturalViewNodeProxy, Weight> m_outgoing;
        private List<ArchitecturalViewNodeProxy> m_children;

        ArchitecturalViewNodeProxy(ArchitecturalViewNode node) {
            super(node);
        }

        void addChild(ArchitecturalViewNodeProxy child) {
            assert (child != null) : "Parameter 'child' of method 'addChild' must not be null";
            if (this.m_children == null) {
                this.m_children = new ArrayList<ArchitecturalViewNodeProxy>(5);
            }
            this.m_children.add(child);
            child.setParent(this);
        }

        List<ArchitecturalViewNodeProxy> getChildren() {
            return this.m_children == null ? Collections.emptyList() : this.m_children;
        }

        private void addIncoming(ArchitecturalViewNodeProxy node, Weight weight) {
            assert (node != null) : "Parameter 'node' of method 'addIncoming' must not be null";
            assert (weight != null) : "Parameter 'weight' of method 'addIncoming' must not be null";
            if (this.m_incoming == null) {
                this.m_incoming = new THashMap();
                this.m_incoming.put(node, new Weight(weight));
            } else {
                Weight existingWeight = this.m_incoming.get(node);
                if (existingWeight == null) {
                    this.m_incoming.put(node, new Weight(weight));
                } else {
                    existingWeight.inc(weight);
                }
            }
        }

        void addOutgoing(ArchitecturalViewNodeProxy node, Weight weight) {
            assert (node != null) : "Parameter 'node' of method 'addOutgoing' must not be null";
            assert (weight != null) : "Parameter 'weight' of method 'addOutgoing' must not be null";
            if (this.m_outgoing == null) {
                this.m_outgoing = new THashMap();
                this.m_outgoing.put(node, new Weight(weight));
            } else {
                Weight existingWeight = this.m_outgoing.get(node);
                if (existingWeight == null) {
                    this.m_outgoing.put(node, new Weight(weight));
                } else {
                    existingWeight.inc(weight);
                }
            }
            node.addIncoming(this, weight);
        }

        Map<ArchitecturalViewNodeProxy, Weight> getIncoming() {
            return this.m_incoming == null ? Collections.emptyMap() : this.m_incoming;
        }

        Map<ArchitecturalViewNodeProxy, Weight> getOutgoing() {
            return this.m_outgoing == null ? Collections.emptyMap() : this.m_outgoing;
        }

        @Override
        public ArchitecturalViewNodeProxy getUnderlyingObject() {
            return this;
        }

        @Override
        public Collection<? extends INode.IEdge> getIncomingEdges() {
            if (this.m_incoming == null) {
                return Collections.emptyList();
            }
            ArrayList<ArchitecturalViewNodeProxyEdge> in = new ArrayList<ArchitecturalViewNodeProxyEdge>(this.m_incoming.size());
            for (Map.Entry<ArchitecturalViewNodeProxy, Weight> nextIn : this.m_incoming.entrySet()) {
                in.add(new ArchitecturalViewNodeProxyEdge(nextIn.getKey(), this, nextIn.getValue().get()));
            }
            return in;
        }

        @Override
        public Collection<? extends INode.IEdge> getOutgoingEdges() {
            if (this.m_outgoing == null) {
                return Collections.emptyList();
            }
            ArrayList<ArchitecturalViewNodeProxyEdge> out = new ArrayList<ArchitecturalViewNodeProxyEdge>(this.m_outgoing.size());
            for (Map.Entry<ArchitecturalViewNodeProxy, Weight> nextOut : this.m_outgoing.entrySet()) {
                out.add(new ArchitecturalViewNodeProxyEdge(this, nextOut.getKey(), nextOut.getValue().get()));
            }
            return out;
        }
    }

    static final class ArchitecturalViewNodeProxyEdge
    implements INode.IEdge {
        private final ArchitecturalViewNodeProxy m_from;
        private final ArchitecturalViewNodeProxy m_to;
        private final int m_weight;

        public ArchitecturalViewNodeProxyEdge(ArchitecturalViewNodeProxy from, ArchitecturalViewNodeProxy to, int weight) {
            assert (from != null) : "Parameter 'from' of method 'Edge' must not be null";
            assert (to != null) : "Parameter 'to' of method 'Edge' must not be null";
            assert (weight > 0) : "Parameter 'weight' of method 'Edge' must be greater than '0'";
            this.m_from = from;
            this.m_to = to;
            this.m_weight = weight;
        }

        public ArchitecturalViewNodeProxy getFrom() {
            return this.m_from;
        }

        public ArchitecturalViewNodeProxy getTo() {
            return this.m_to;
        }

        @Override
        public int getWeight() {
            return this.m_weight;
        }

        public String toString() {
            return String.valueOf(this.m_from) + " -> " + String.valueOf(this.m_to) + " [" + this.m_weight + "]";
        }
    }

    static final class ArtifactPropertiesNodeProxy
    extends NodeProxy<ArtifactPropertiesNodeProxy> {
        private Set<ArtifactPropertiesNodeProxy> m_incoming;
        private Set<ArtifactPropertiesNodeProxy> m_outgoing;

        ArtifactPropertiesNodeProxy(ArchitecturalViewNode node) {
            super(node);
        }

        private void addIncoming(ArtifactPropertiesNodeProxy node) {
            assert (node != null) : "Parameter 'node' of method 'addIncoming' must not be null";
            if (this.m_incoming == null) {
                this.m_incoming = new THashSet();
            }
            this.m_incoming.add(node);
        }

        void addOutgoing(ArtifactPropertiesNodeProxy node) {
            assert (node != null) : "Parameter 'node' of method 'addOutgoing' must not be null";
            if (this.m_outgoing == null) {
                this.m_outgoing = new THashSet();
            }
            this.m_outgoing.add(node);
            node.addIncoming(this);
        }

        Set<ArtifactPropertiesNodeProxy> getIncoming() {
            return this.m_incoming == null ? Collections.emptySet() : this.m_incoming;
        }

        Set<ArtifactPropertiesNodeProxy> getOutgoing() {
            return this.m_outgoing == null ? Collections.emptySet() : this.m_outgoing;
        }
    }

    static interface IArchitecturalViewNodeCategoryProvider {
        public int getCategory(ArchitecturalViewNode var1);
    }

    static final class NodeComparator
    implements Comparator<ArchitecturalViewNodeProxy> {
        private final ExplorationViewRepresentation m_representation;

        NodeComparator(ExplorationViewRepresentation representation) {
            assert (representation != null) : "Parameter 'representation' of method 'NodeComparator' must not be null";
            this.m_representation = representation;
        }

        @Override
        public int compare(ArchitecturalViewNodeProxy n1, ArchitecturalViewNodeProxy n2) {
            boolean n2IsExternal;
            assert (n1 != null) : "Parameter 'n1' of method 'compare' must not be null";
            assert (n2 != null) : "Parameter 'n2' of method 'compare' must not be null";
            if (n1 == n2) {
                return 0;
            }
            boolean n1IsExternal = n1.getNode().isExternal();
            if (n1IsExternal != (n2IsExternal = n2.getNode().isExternal())) {
                return n1IsExternal ? 1 : -1;
            }
            int compared = n2.getLevel() - n1.getLevel();
            if (compared == 0 && (compared = n1.getCycleGroupIndex() - n2.getCycleGroupIndex()) == 0) {
                if (n1.isCyclic()) {
                    compared = n2.getLevelInCycle() - n1.getLevelInCycle();
                }
                if (compared == 0 && (compared = this.m_representation.getCategoryProvider().getCategory((Object)n2.getNode()) - this.m_representation.getCategoryProvider().getCategory((Object)n1.getNode())) == 0) {
                    compared = n1.getName().compareTo(n2.getName());
                }
            }
            return compared;
        }
    }

    static abstract class NodeProxy<T extends NodeProxy<T>> {
        private final ArchitecturalViewNode m_node;
        private T m_parent;
        private int m_depth = -1;
        private String m_nameCache;

        NodeProxy(ArchitecturalViewNode node) {
            assert (node != null) : "Parameter 'node' of method 'NodeProxy' must not be null";
            assert (!node.isSuppressed()) : "'node' is surpressed";
            this.m_node = node;
        }

        final ArchitecturalViewNode getNode() {
            return this.m_node;
        }

        public final String getName() {
            if (this.m_nameCache == null) {
                this.m_nameCache = this.m_node.getName();
            }
            return this.m_nameCache;
        }

        final int getLevel() {
            return this.m_node.getLevel();
        }

        final boolean isCyclic() {
            return this.m_node.getCycleIndex() != -1;
        }

        final int getCycleGroupIndex() {
            return this.m_node.getCycleIndex();
        }

        final void setLevel(int level) {
            this.m_node.setLevel(level);
        }

        final void setCycleIndex(int index) {
            this.m_node.setCycleIndex(index);
        }

        final void setLevelInCycle(int level) {
            this.m_node.setLevelInCycle(level);
        }

        final int getLevelInCycle() {
            return this.m_node.getLevelInCycle();
        }

        final void setParent(T parent) {
            assert (parent != null) : "Parameter 'parent' of method 'setParent' must not be null";
            this.m_parent = parent;
            this.m_depth = -1;
        }

        final int getProxyDepth() {
            if (this.m_depth == -1) {
                this.m_depth = this.m_parent == null ? 0 : ((NodeProxy)this.m_parent).getProxyDepth() + 1;
            }
            return this.m_depth;
        }

        final T getParent() {
            return this.m_parent;
        }

        public final String toString() {
            return "[" + this.m_node.getClass().getSimpleName() + " | proxy depth:" + this.getProxyDepth() + ", node depth:" + this.m_node.getDepth() + "] " + this.getName() + " Parent:" + (String)(this.m_parent == null ? " <none>" : " [" + ((NodeProxy)this.m_parent).getNode().getClass().getSimpleName() + " | Proxy depth:" + ((NodeProxy)this.m_parent).getProxyDepth() + ", node depth:" + ((NodeProxy)this.m_parent).getNode().getDepth() + "] " + ((NodeProxy)this.m_parent).getName());
        }
    }
}

