/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.complexity;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IThresholdController;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComplexityMetricsAdapter
extends AnalyzerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexityMetricsAdapter.class);
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.COMPLEXITY_SYSTEM_METRICS;
    private final IMetricDescriptor m_fullyAnalyzedStatements;
    private final IMetricDescriptor m_cyclomaticComplexity;
    private final IMetricDescriptor m_maxNesting;
    private final IMetricDescriptor m_complexStatements;
    private final IMetricDescriptor m_complexStatementsPercent;
    private final IMetricDescriptor m_complexStatementsIgnored;
    private final IMetricDescriptor m_complexStatementsIgnoredPercent;
    private final IMetricDescriptor m_complexStatementsToBeFixed;
    private final IMetricDescriptor m_complexStatementsToBeFixedPercent;

    public ComplexityMetricsAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_cyclomaticComplexity = this.findMetricDescriptor(mp, CoreMetricId.CORE_MODIFIED_EXTENDED_CCN, CoreMetricLevel.ROUTINE);
        this.m_maxNesting = this.findMetricDescriptor(mp, CoreMetricId.CORE_MAX_NESTING, CoreMetricLevel.ROUTINE);
        this.m_fullyAnalyzedStatements = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STATEMENTS_FULLY_ANALYZED, CoreMetricLevel.SYSTEM);
        this.m_complexStatements = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS, CoreMetricLevel.SYSTEM);
        this.m_complexStatementsPercent = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_PERCENT, CoreMetricLevel.SYSTEM);
        this.m_complexStatementsIgnored = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_IGNORED, CoreMetricLevel.SYSTEM);
        this.m_complexStatementsIgnoredPercent = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_IGNORED_PERCENT, CoreMetricLevel.SYSTEM);
        this.m_complexStatementsToBeFixed = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_TO_FIX, CoreMetricLevel.SYSTEM);
        this.m_complexStatementsToBeFixedPercent = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STATEMENTS_COMPLEX_METHODS_TO_FIX_PERCENT, CoreMetricLevel.SYSTEM);
    }

    @Override
    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        return null;
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    @Override
    protected void resultSuccessfullyRestored(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        if (result.getMetricValue(this.getSoftwareSystem(), this.m_complexStatementsPercent) == null) {
            throw new RestoreException("Missing expected metric value for fully analyzed lines of code.");
        }
        super.resultSuccessfullyRestored(result);
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        ComplexityMetricsJob job = new ComplexityMetricsJob(this.getGroup(), result, this.getController(), this.getRequiredResults());
        job.start();
    }

    private final class ComplexityMetricsJob
    extends AnalyzerJob {
        private static final int CYCLOMATIC_COMPLEXITY_DEFAULT_UPPER = 15;
        private static final int MAX_NESTING_DEFAULT_UPPER = 4;

        protected ComplexityMetricsJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, Collection<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
        }

        @Override
        protected void internalRun() {
            IThresholdController thresholdController = this.getSoftwareSystem().getExtension(IThresholdController.class);
            Map<IMetricDescriptor, IMetricThreshold> thresholds = thresholdController.getThresholdsFor(Arrays.asList(ComplexityMetricsAdapter.this.m_cyclomaticComplexity, ComplexityMetricsAdapter.this.m_maxNesting));
            Number maxCyclomaticThresholdValue = this.getUpperThreshold(thresholds, ComplexityMetricsAdapter.this.m_cyclomaticComplexity);
            boolean maxCyclomaticThresholdDefined = maxCyclomaticThresholdValue != null;
            int maxCyclomaticThreshold = maxCyclomaticThresholdDefined ? maxCyclomaticThresholdValue.intValue() : 15;
            Number maxNestingThresholdValue = this.getUpperThreshold(thresholds, ComplexityMetricsAdapter.this.m_maxNesting);
            boolean maxNestingThresholdDefined = maxNestingThresholdValue != null;
            int maxNestingThreshold = maxNestingThresholdDefined ? maxNestingThresholdValue.intValue() : 4;
            Workspace workspace = this.getSoftwareSystem().getUniqueExistingChild(Workspace.class);
            int fullyAnalyzedStatements = 0;
            int complexStatements = 0;
            int complexStatementsIgnored = 0;
            int complexStatementsToBeFixed = 0;
            for (Module nextModule : workspace.getChildren(Module.class)) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return;
                }
                for (SourceFile nextSource : nextModule.getChildrenRecursively(SourceFile.class, SourceFile.class)) {
                    if (this.getWorkerContext().hasBeenCanceled()) {
                        return;
                    }
                    if (nextSource.isExcluded()) continue;
                    List<IRoutine> componentRoutines = nextSource.getChildrenRecursively(IRoutine.class, IRoutine.class);
                    for (IRoutine nextRoutine : componentRoutines) {
                        ThresholdViolationIssue issue;
                        int numberOfStatements;
                        if (this.getWorkerContext().hasBeenCanceled()) {
                            return;
                        }
                        NamedElement routine = (NamedElement)((Object)nextRoutine);
                        if (routine.ignoreIssues() || (numberOfStatements = nextRoutine.getNumberOfStatements()) <= 0) continue;
                        int maxNesting = nextRoutine.getMaxNesting();
                        int cyclomaticComplexity = nextRoutine.getModifiedExtendedCyclomaticComplexity();
                        boolean cyclomaticComplexityViolated = cyclomaticComplexity > maxCyclomaticThreshold;
                        boolean nestingViolated = maxNesting > maxNestingThreshold;
                        boolean isComplex = cyclomaticComplexityViolated || nestingViolated;
                        fullyAnalyzedStatements += numberOfStatements;
                        if (!isComplex) continue;
                        boolean isIgnored = false;
                        boolean hasTask = false;
                        if (cyclomaticComplexityViolated && maxCyclomaticThresholdDefined) {
                            issue = this.getThresholdViolationIssue(nextRoutine, ComplexityMetricsAdapter.this.m_cyclomaticComplexity);
                            if (issue != null) {
                                if (issue.isIgnored()) {
                                    isIgnored = true;
                                } else if (issue.getResolution() instanceof TaskDefinition) {
                                    hasTask = true;
                                }
                            } else {
                                LOGGER.warn("Cyclomatic complexity threshold issue not found (own/max/defined): " + cyclomaticComplexity + "/" + maxCyclomaticThreshold + "/" + String.valueOf(maxCyclomaticThresholdValue) + " for routine:\n" + String.valueOf(nextRoutine));
                            }
                        }
                        if (nestingViolated && maxNestingThresholdDefined && !isIgnored) {
                            issue = this.getThresholdViolationIssue(nextRoutine, ComplexityMetricsAdapter.this.m_maxNesting);
                            if (issue != null) {
                                if (issue.isIgnored()) {
                                    isIgnored = true;
                                } else if (issue.getResolution() instanceof TaskDefinition) {
                                    hasTask = true;
                                }
                            } else {
                                LOGGER.warn("Max Block Nesting Depth threshold issue not found (own/max/defined): " + maxNesting + "/" + maxNestingThreshold + "/" + String.valueOf(maxNestingThresholdValue) + " for routine:\n" + String.valueOf(nextRoutine));
                            }
                        }
                        complexStatements += numberOfStatements;
                        if (isIgnored) {
                            complexStatementsIgnored += numberOfStatements;
                            continue;
                        }
                        if (!hasTask) continue;
                        complexStatementsToBeFixed += numberOfStatements;
                    }
                }
            }
            ComplexityMetricsAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), fullyAnalyzedStatements, ComplexityMetricsAdapter.this.m_fullyAnalyzedStatements);
            ComplexityMetricsAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), complexStatements, ComplexityMetricsAdapter.this.m_complexStatements);
            ComplexityMetricsAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(this.percentage(complexStatements, fullyAnalyzedStatements)), ComplexityMetricsAdapter.this.m_complexStatementsPercent);
            ComplexityMetricsAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), complexStatementsIgnored, ComplexityMetricsAdapter.this.m_complexStatementsIgnored);
            ComplexityMetricsAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(this.percentage(complexStatementsIgnored, fullyAnalyzedStatements)), ComplexityMetricsAdapter.this.m_complexStatementsIgnoredPercent);
            ComplexityMetricsAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), complexStatementsToBeFixed, ComplexityMetricsAdapter.this.m_complexStatementsToBeFixed);
            ComplexityMetricsAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), Float.valueOf(this.percentage(complexStatementsToBeFixed, fullyAnalyzedStatements)), ComplexityMetricsAdapter.this.m_complexStatementsToBeFixedPercent);
        }

        private Number getUpperThreshold(Map<IMetricDescriptor, IMetricThreshold> thresholds, IMetricDescriptor descriptor) {
            assert (thresholds != null) : "Parameter 'thresholds' of method 'getUpperThreshold' must not be null";
            assert (descriptor != null) : "Parameter 'descriptor' of method 'getUpperThreshold' must not be null";
            IMetricThreshold threshold = thresholds.get(descriptor);
            if (threshold != null) {
                return threshold.getUpperThreshold();
            }
            return null;
        }

        private ThresholdViolationIssue getThresholdViolationIssue(IRoutine routine, IMetricDescriptor metricDescriptor) {
            assert (routine != null) : "Parameter 'routine' of method 'getThresholdViolationIssue' must not be null";
            assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'getThresholdViolationIssue' must not be null";
            NamedElement method = (NamedElement)((Object)routine);
            return method.getIssues(CoreIssueId.THRESHOLD_VIOLATION).stream().filter(i -> i instanceof ThresholdViolationIssue).map(i -> (ThresholdViolationIssue)i).filter(t -> t.getMetricDescriptor() == metricDescriptor).findFirst().orElse(null);
        }
    }
}

