/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

final class ModuleNameValidator
implements ITextValidator {
    private final SoftwareSystem m_softwareSystem;

    ModuleNameValidator(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ModuleNameValidator' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        String newInputString;
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
        String string = newInputString = newInput != null ? newInput.trim() : null;
        if (newInputString == null || newInputString.isEmpty()) {
            result.addError("Must not be empty");
        } else if (result.inputModified()) {
            for (Module nextModule : this.m_softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (!nextModule.getName().equals(newInputString)) continue;
                result.addError("Module with name '" + newInputString + "' already exists");
                break;
            }
        }
        return result;
    }
}

