/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.controller.system.IDeltaDetector;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.core.controller.system.RelevantSourceFileIterator;
import com.hello2morrow.sonargraph.core.controller.system.SoftwareSystemSettingsExtension;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceModification;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.complexity.WeightedAverageCalculator;
import com.hello2morrow.sonargraph.core.controller.system.analysis.size.SourceCodeMetricAnalyzer;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.parser.SourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.script.CoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.ScriptApi;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLinesScanner;
import com.hello2morrow.sonargraph.core.foundation.common.parser.IdentifierInfo;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.QualityModelFileDescriptor;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.TargetInSource;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalModuleNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.UnresolvedWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependencyElementIdFilter;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.system.IAdditionalDynamicInfoProvider;
import com.hello2morrow.sonargraph.core.model.system.IRelevantSourceFileIterator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PhysicalInfo;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.system.SystemPropertiesPersistenceProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LanguageProvider
implements IMetricAwareLanguageProvider,
IAddedOrChangedSourceFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageProvider.class);
    private static final String IGNORE_PROPERTY_NAME = "IgnoreDirectories";
    private static List<String> s_ignoreDirectories;
    private final Language m_language;
    private final SimpleSynchronizationLock m_identifierResolvingSyncLock = new SimpleSynchronizationLock();
    private boolean m_enableIdentifierResolving = true;
    private Installation m_installation;

    public LanguageProvider(Language language) {
        assert (language != null) : "Parameter 'language' of method 'LanguageProvider' must not be null";
        this.m_language = language;
    }

    protected ISourceLineProcessor createSourceLineProcessor() {
        return new SourceLineProcessor();
    }

    public static final synchronized List<String> getIgnoreDirectories() {
        if (s_ignoreDirectories == null) {
            s_ignoreDirectories = new ArrayList<String>();
            URL resourceUrl = CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.PROPERTIES, IGNORE_PROPERTY_NAME);
            List resourcePath = CoreResourceProviderAdapter.getInstance().getResourcePaths((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.PROPERTIES, IGNORE_PROPERTY_NAME);
            Properties loadedProperties = FileUtility.loadProperties((URL)resourceUrl, (String)IGNORE_PROPERTY_NAME, (List)resourcePath);
            Enumeration<Object> enumKeys = loadedProperties.keys();
            while (enumKeys.hasMoreElements()) {
                String key = (String)enumKeys.nextElement();
                s_ignoreDirectories.add(key.trim());
            }
        }
        return Collections.unmodifiableList(s_ignoreDirectories);
    }

    @Override
    public final Language getLanguage() {
        return this.m_language;
    }

    public abstract Set<? extends IIssueId> getIssueIds();

    public Set<? extends IConfigurableAnalyzerId> getAnalyzerIds() {
        return Collections.emptySet();
    }

    public List<? extends AnalyzerAdapter> getAnalyzerAdapters(IAnalyzerController controller, Set<IConfigurableAnalyzerId> licensedAnalyzerIds) {
        assert (controller != null) : "Parameter 'controller' of method 'getAnalyzerAdapters' must not be null";
        assert (licensedAnalyzerIds != null) : "Parameter 'licensedAnalyzerIds' of method 'getAnalyzerAdapters' must not be null";
        return Collections.emptyList();
    }

    @Override
    public final void processAddedOrChangedSourceFile(SourceFile sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'processAddedOrChangedSourceFile' must not be null";
        if (!sourceFile.getFile().canRead()) {
            return;
        }
        try {
            List lines = FileUtility.getFileLinesWithoutLineBreaks((TFile)sourceFile.getFile());
            new SourceCodeMetricAnalyzer(this.createSourceLineProcessor()).processAddedOrChangedFile(sourceFile, lines);
        }
        catch (IOException e) {
            LOGGER.error("Problem with reading file " + sourceFile.getName(), (Throwable)e);
        }
    }

    public void initialize(Installation installation, IFinishModelProcessor finishModelProcessor) {
        assert (installation != null) : "Parameter 'installation' of method 'initialize' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'initialize' must not be null";
        this.m_installation = installation;
    }

    protected final Installation getInstallation() {
        return this.m_installation;
    }

    public void initialize(SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initialize' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'initialize' must not be null";
    }

    public void aboutToCreateFirstModule(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'firstModuleCreated' must not be null";
        for (SoftwareSystemSettingsExtension next : softwareSystem.getExtensions(SoftwareSystemSettingsExtension.class)) {
            if (next.getLanguage() != this.getLanguage()) continue;
            next.aboutToCreateFirstModule();
            break;
        }
    }

    public void softwareSystemClosed(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'softwareSystemClosed' must not be null";
    }

    public void lastModuleDeleted(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'firstModuleCreated' must not be null";
        for (SoftwareSystemSettingsExtension next : softwareSystem.getExtensions(SoftwareSystemSettingsExtension.class)) {
            if (next.getLanguage() != this.getLanguage()) continue;
            next.lastModuleDeleted();
            break;
        }
    }

    protected boolean isRefreshable(RootDirectoryPath rootDirectoryPath) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'isRefreshable' must not be null";
        return true;
    }

    protected boolean setNeedsReparseOnWorkspaceModification(WorkspaceModification modification) {
        assert (modification != null) : "Parameter 'modification' of method 'setNeedsReparseOnWorkspaceModification' must not be null";
        return true;
    }

    protected boolean isRefreshable(Module module) {
        assert (module != null) : "Parameter 'module' of method 'isRefreshable' must not be null";
        for (RootDirectoryPath nextRootDirectoryPath : module.getChildren(RootDirectoryPath.class)) {
            if (!this.isRefreshable(nextRootDirectoryPath)) continue;
            return true;
        }
        return false;
    }

    public final boolean isRefreshPossible(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'isRefreshPossible' must not be null";
        for (Module module : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(this.getModuleClass())) {
            if (!this.isRefreshable(module)) continue;
            return true;
        }
        return false;
    }

    public final boolean isRefreshPossible(Module module) {
        assert (module != null) : "Parameter 'module' of method 'isRefreshPossible' must not be null";
        if (this.getModuleClass().isAssignableFrom(module.getClass())) {
            return this.isRefreshable(module);
        }
        return false;
    }

    public abstract boolean prepareRefresh(IWorkerContext var1, SoftwareSystem var2, PrepareRefreshResult var3);

    public abstract LanguageProviderRefactoringAdapter getRefactoringAdapter();

    public abstract LanguageProviderRefactoringDescriptorProvider getRefactoringDescriptorProvider();

    protected abstract RelevantSourceLinesScanner.ScannerInfo getScannerInfo();

    protected abstract Class<? extends Module> getModuleClass();

    protected abstract Class<? extends External> getExternalClass();

    public final IRelevantSourceFileIterator getRelevantSourceFileIterator(SoftwareSystem softwareSystem) {
        Class<? extends Module> moduleClazz = this.getModuleClass();
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        for (Module module : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(moduleClazz)) {
            for (SourceFile nextSourceFile : module.getChildrenRecursively(SourceFile.class, ProgrammingElement.class)) {
                if (nextSourceFile.ignoreIssues()) continue;
                sourceFiles.add(nextSourceFile);
            }
        }
        return new RelevantSourceFileIterator(sourceFiles, this.getScannerInfo());
    }

    public IDeltaDetector createDeltaDetector(IWorkerContext workerContext, IWorkspaceFilter filter, Module module, PrepareRefreshResult result) {
        return null;
    }

    public void refreshModule(IWorkerContext workerContext, ModuleDelta delta, IFilePathListener listener, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshModule' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshModule' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshModule' must not be null";
    }

    public abstract IAdditionalFileInfoProvider getPersistenceProvider(Installation var1);

    public IAdditionalDynamicInfoProvider getDynamicSystemInfoProvider() {
        return null;
    }

    @Override
    public abstract IProviderId getProviderId();

    public void workspaceFilterApplied(IWorkerContext workerContext, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'workspaceFilterApplied' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'workspaceFilterApplied' must not be null";
    }

    public void finishSystemFilesRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modifications) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishSystemFilesRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSystemFilesRefresh' must not be null";
    }

    public void finishApplySnapshot(IWorkerContext workerContext, SoftwareSystem softwareSystem, IFilePathListener listener) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishApplySnapshot' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishApplySnapshot' must not be null";
    }

    public void visitPresentFilePaths(IFilePathListener listener, IModule ... modules) {
        assert (listener != null) : "Parameter 'listener' of method 'visitPresentFilePaths' must not be null";
        assert (modules != null && modules.length > 0) : "Parameter 'modules' of method 'visitPresentFilePaths' must not be empty";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aboutToRefreshModules(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result, Set<ISoftwareSystemProvider.IRefreshOption> refreshOptions, List<ModuleDelta> moduleDeltas, IFilePathListener listener) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'prepareRefresh' must not be null";
        assert (result != null);
        SimpleSynchronizationLock simpleSynchronizationLock = this.m_identifierResolvingSyncLock;
        synchronized (simpleSynchronizationLock) {
            this.m_enableIdentifierResolving = false;
        }
    }

    public void aboutToRefreshSystem(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToRefreshSystem' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToRefreshSystem' must not be null";
        assert (result != null) : "Parameter 'result' of method 'aboutToRefreshSystem' must not be null";
    }

    public boolean refreshSystem(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result, boolean systemWillBeCleared) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishRefresh' must not be null";
        for (Module simpleSynchronizationLock : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(this.getModuleClass())) {
            simpleSynchronizationLock.clearClosure();
        }
        SystemPropertiesPersistenceProvider.storeProperties(softwareSystem, result);
        SimpleSynchronizationLock simpleSynchronizationLock = this.m_identifierResolvingSyncLock;
        synchronized (simpleSynchronizationLock) {
            this.m_enableIdentifierResolving = true;
        }
        return !systemWillBeCleared;
    }

    protected void clearModules(SoftwareSystem softwareSystem, boolean onRefresh) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clearModules' must not be null";
        List<? extends Module> modules = softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(this.getModuleClass());
        for (Module module : modules) {
            module.clearClosure();
            List<RootDirectoryPath> rootDirectories = module.getChildren(RootDirectoryPath.class);
            for (RootDirectoryPath nextRootDirectoryPath : rootDirectories) {
                this.clearRootDirectoryPath(module, nextRootDirectoryPath);
            }
        }
    }

    protected void clearRootDirectoryPath(Module module, RootDirectoryPath rootDir) {
        assert (module != null) : "Parameter 'module' of method 'clearRootDirectoryPath' must not be null";
        assert (rootDir != null) : "Parameter 'rootDir' of method 'clearRootDirectoryPath' must not be null";
        rootDir.forgetChildren(true);
    }

    protected void clearExternal(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clearExternal' must not be null";
        External external = softwareSystem.getUniqueExistingChild(Workspace.class).getUniqueChild(this.getExternalClass());
        assert (external != null) : "Parameter 'external' of method 'clearExternal' must not be null";
        external.forgetChildren(true);
    }

    protected void clearSystem(SoftwareSystem softwareSystem, boolean onRefresh) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clearSystem' must not be null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(SoftwareSystem softwareSystem, boolean onRefresh) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clear' must not be null";
        SimpleSynchronizationLock simpleSynchronizationLock = this.m_identifierResolvingSyncLock;
        synchronized (simpleSynchronizationLock) {
            this.m_enableIdentifierResolving = false;
        }
        try {
            this.clearSystem(softwareSystem, onRefresh);
            this.clearModules(softwareSystem, onRefresh);
            this.clearExternal(softwareSystem);
        }
        catch (Throwable throwable) {
            SimpleSynchronizationLock simpleSynchronizationLock2 = this.m_identifierResolvingSyncLock;
            synchronized (simpleSynchronizationLock2) {
                this.m_enableIdentifierResolving = true;
            }
            throw throwable;
        }
        SimpleSynchronizationLock simpleSynchronizationLock3 = this.m_identifierResolvingSyncLock;
        synchronized (simpleSynchronizationLock3) {
            this.m_enableIdentifierResolving = true;
        }
    }

    protected abstract Module.IModuleType getModuleType(String var1);

    protected abstract Module createModule(SoftwareSystem var1, Module.IModuleType var2, String var3, String var4, String var5);

    @Override
    public FilePath getSourceFile(NamedElement element) {
        assert (element != null) : "Parameter 'namedElement' of method 'getSourceFile' must not be null";
        assert (element.isValid()) : "Not a valid element: " + String.valueOf(element);
        if ((element = element.getElement()) instanceof LogicalProgrammingElement) {
            element = ((LogicalProgrammingElement)element).getPrimaryProgrammingElement();
        }
        if (element instanceof SourceFile) {
            return (FilePath)element;
        }
        if (element instanceof ProgrammingElement) {
            return element.getParent(SourceFile.class, new Class[0]);
        }
        return null;
    }

    @Override
    public String hasTimestampChangedOnDisk(FilePath sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'hasTimestampChangedOnDisk' must not be null";
        TFile file = sourceFile.getFile();
        if (file != null && sourceFile.getTimestamp() != file.lastModified()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    @Override
    public PhysicalInfo getPhysicalInfo(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getPhysicalInfo' must not be null";
        if (element instanceof DirectoryFragment) {
            DirectoryFragment directoryFragment = (DirectoryFragment)element;
            RootDirectoryPath rootDirectoryPath = directoryFragment.getOriginalParent(RootDirectoryPath.class);
            if (rootDirectoryPath != null) {
                return new PhysicalInfo(rootDirectoryPath, "./" + directoryFragment.getOriginalName(), directoryFragment.getOriginalShortName());
            }
        } else {
            FilePath originalSource;
            RootDirectoryPath originalRootDirectoryPath;
            FilePath source = this.getSourceFile(element);
            if (source != null && (originalRootDirectoryPath = (originalSource = (FilePath)source.getOriginal()).getOriginalParent(RootDirectoryPath.class)) != null) {
                return new PhysicalInfo(originalRootDirectoryPath, originalSource.getPresentationName(false), originalSource.getPresentationName(true));
            }
        }
        return null;
    }

    private IdentifierInfo getValidIdentifier(String lineContent, int lineNumber, int offsetInLine) {
        assert (lineContent != null && lineContent.length() > 0) : "Parameter 'lineContent' of method 'getValidIdentifier' must not be empty";
        assert (offsetInLine >= 0 && offsetInLine <= lineContent.length()) : "'offsetInLine' out of range";
        int currentOffsetInLine = 0;
        int currentStartPosOfValidIdentifier = -1;
        int currentLengthOfValidIdentifier = 0;
        boolean specifiedOffsetInLineReached = false;
        do {
            char currentChar;
            if (Character.isJavaIdentifierStart(currentChar = lineContent.charAt(currentOffsetInLine++))) {
                if (specifiedOffsetInLineReached) {
                    return null;
                }
                currentStartPosOfValidIdentifier = currentOffsetInLine - 1;
                currentLengthOfValidIdentifier = 1;
                if (currentOffsetInLine == offsetInLine) {
                    specifiedOffsetInLineReached = true;
                }
            } else {
                currentStartPosOfValidIdentifier = -1;
                currentLengthOfValidIdentifier = 0;
            }
            if (currentStartPosOfValidIdentifier == -1) continue;
            while (currentOffsetInLine < lineContent.length() && Character.isJavaIdentifierPart(currentChar = lineContent.charAt(currentOffsetInLine))) {
                ++currentLengthOfValidIdentifier;
                if (++currentOffsetInLine != offsetInLine) continue;
                specifiedOffsetInLineReached = true;
            }
            if (!specifiedOffsetInLineReached) continue;
            return new IdentifierInfo(lineContent.substring(currentStartPosOfValidIdentifier, currentStartPosOfValidIdentifier + currentLengthOfValidIdentifier), currentStartPosOfValidIdentifier, lineNumber, lineContent);
        } while (currentOffsetInLine < lineContent.length());
        return null;
    }

    protected boolean elementMatchesName(ProgrammingElement element, String name) {
        assert (element != null) : "Parameter 'element' of method 'elementMatchesName' must not be null";
        return element.getShortName().equals(name);
    }

    private TargetInSource getTargetInSource(IVirtualModel mapper, FilePath filePath, IdentifierInfo identifierInfo) {
        assert (mapper != null) : "Parameter 'mapper' of method 'getTargetInSource' must not be null";
        assert (filePath != null) : "Parameter 'filePath' of method 'getTargetInSource' must not be null";
        assert (identifierInfo != null) : "Parameter 'identifierInfo' of method 'getTargetInSource' must not be null";
        List<ProgrammingElement> programmingElements = filePath.getChildrenRecursively(ProgrammingElement.class, new Class[0]);
        for (ProgrammingElement nextProgrammingElement : programmingElements) {
            List<ParserDependency> dependencies = nextProgrammingElement.getOutgoingDependencies(new IParserDependencyType[0]);
            for (ParserDependency nextDependency : dependencies) {
                FilePath toFilePath;
                ProgrammingElement toElement = nextDependency.getTo();
                if (toElement.isExternal() || !toElement.isDefinedInEnclosingElement() || nextDependency.getLineNumber() != identifierInfo.getLineNumber() || !this.elementMatchesName(toElement, identifierInfo.getIdentifier()) || (toFilePath = this.getSourceFile(toElement)) == null) continue;
                return new TargetInSource(toFilePath, toElement.getElement(), identifierInfo);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TargetInSource getTargetInSource(IVirtualModel model, FilePath filePath, String lineContent, int lineNumber, int offsetInLine) {
        SimpleSynchronizationLock simpleSynchronizationLock = this.m_identifierResolvingSyncLock;
        synchronized (simpleSynchronizationLock) {
            IdentifierInfo identifierInfo;
            if (this.m_enableIdentifierResolving && (identifierInfo = this.getValidIdentifier(lineContent, lineNumber, offsetInLine)) != null) {
                return this.getTargetInSource(model, filePath, identifierInfo);
            }
        }
        return null;
    }

    public void aboutToDeleteWorkspaceElements(IWorkerContext workerContext, SoftwareSystem softwareSystem, Module module, List<NamedElement> workspaceElements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToDeleteWorkspaceElements' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToDeleteWorkspaceElements' must not be null";
        assert (module != null) : "Parameter 'module' of method 'aboutToDeleteWorkspaceElements' must not be null";
        assert (workspaceElements != null && !workspaceElements.isEmpty()) : "Parameter 'workspaceElements' of method 'aboutToDeleteWorkspaceElements' must not be empty";
        this.clearModules(softwareSystem, false);
        this.clearExternal(softwareSystem);
        softwareSystem.setState(SoftwareSystemState.OPENED);
    }

    protected void checkSoftwareSystemSettings(Workspace sourceWorkspace, Workspace targetWorkspace, OperationResult result) {
        assert (sourceWorkspace != null) : "Parameter 'sourceWorkspace' of method 'checkSoftwareSystemSettings' must not be null";
        assert (targetWorkspace != null) : "Parameter 'targetWorkspace' of method 'checkSoftwareSystemSettings' must not be null";
        assert (result != null) : "Parameter 'result' of method 'checkSoftwareSystemSettings' must not be null";
    }

    protected EnumSet<Modification> moveSoftwareSystemElements(Workspace sourceWorkspace, Workspace targetWorkspace) {
        assert (sourceWorkspace != null) : "Parameter 'sourceWorkspace' of method 'moveSoftwareSystemElements' must not be null";
        assert (targetWorkspace != null) : "Parameter 'targetWorkspace' of method 'moveSoftwareSystemElements' must not be null";
        assert (sourceWorkspace != targetWorkspace) : "Same instances";
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        for (Module module : sourceWorkspace.getChildren(this.getModuleClass())) {
            Module targetModule = targetWorkspace.getUniqueChild(new WorkspaceDependencyElementIdFilter(module.getId(), false), Module.class);
            if (targetModule == null) continue;
            if (!module.getName().equals(targetModule.getName())) {
                targetModule.setName(module.getName());
                modifications.add(Modification.WORKSPACE_MODIFIED);
            }
            if (!module.getDescription().equals(targetModule.getDescription())) {
                targetModule.setDescription(module.getDescription());
                modifications.add(Modification.WORKSPACE_MODIFIED);
            }
            for (WorkspaceDependency sourceDep : module.getOutgoingWorkspaceDependencies()) {
                IWorkspaceDependencyElement targetEndpoint = this.findEndpointOfExistingDependency(targetWorkspace, targetModule, sourceDep.getType(), sourceDep.getToId(), sourceDep.getToName(), sourceDep.getAdditionalDependencyData());
                assert (targetEndpoint != null) : "Endpoint of dependency '" + String.valueOf(sourceDep) + "' not found in target workspace";
                WorkspaceDependency targetDep = targetModule.getOutgoingWorkspaceDependency(targetEndpoint);
                assert (targetDep != null) : "Dependency '" + String.valueOf(sourceDep) + "' does not exist in target workspace";
                targetDep.setAdditionalDependencyData(sourceDep.getAdditionalDependencyData());
            }
        }
        return modifications;
    }

    protected abstract List<StructureItem> getPhysicalStructureItems();

    public boolean isSuitableForIncludeDependenciesGraph(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'isSuitableForIncludeDependenciesGraph' must not be null";
        return false;
    }

    protected abstract CoreAccess getSystemAccess(Installation var1, SoftwareSystem var2, IMetricIdProvider var3, ScriptApi var4);

    public OperationResult.IMessageCause manualWorkspaceDependencyCreationSupported(IWorkspaceDependencyElement from, IWorkspaceDependencyElement to) {
        assert (from != null) : "Parameter 'from' of method 'manualWorkspaceDependencyCreationSupported' must not be null";
        assert (to != null) : "Parameter 'to' of method 'manualWorkspaceDependencyCreationSupported' must not be null";
        assert (from != to) : "Same instance";
        return LanguageProviderMessageCause.MANUAL_WORKSPACE_DEPENDENCY_NOT_SUPPORTED;
    }

    public WorkspaceDependency createManualWorkspaceDependency(SoftwareSystem softwareSystem, IWorkspaceDependencyElement from, IWorkspaceDependencyElement to) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createManualWorkspaceDependency' must not be null";
        assert (this.manualWorkspaceDependencyCreationSupported(from, to) == null) : "Dependency creation not supported: " + String.valueOf(from) + "->" + String.valueOf(to);
        return null;
    }

    public abstract WorkspaceDependency createWorkspaceDependency(SoftwareSystem var1, IWorkspaceDependencyElement var2, String var3, String var4, String var5, WorkspaceDependency.AdditionalDependencyData var6);

    public abstract LogicalNamespaceRoot createLogicalNamespaceRoot(NamedElement var1);

    public abstract ExternalLogicalNamespaceRoot createExternalLogicalNamespaceRoot(NamedElement var1, NamedElement var2, LogicalNamespaceScope var3);

    public String getExternalElementContainerName(NamedElement parent, NamedElement container) {
        assert (parent != null) : "Parameter 'parent' of method 'createExternalElementContainer' must not be null";
        assert (container != null) : "Parameter 'container' of method 'createExternalElementContainer' must not be null";
        return container.getShortName();
    }

    public void finishSaveSoftwareSystemAs(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'finishSaveSoftwareSystemAs' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishSaveSoftwareSystemAs' must not be null";
    }

    public void finishLoadFromPersistence(Installation installation, SoftwareSystem softwareSystem, OperationResult result, boolean snapshotOrUndoRedoMode) {
        assert (installation != null) : "Parameter 'installation' of method 'finishLoadFromPersistence' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'finishLoadFromPersistence' must not be null";
    }

    public boolean hasInstallationConfigurationChanged(SoftwareSystem systemFromSnapshot, OperationResult result) {
        assert (systemFromSnapshot != null) : "Parameter 'systemFromSnapshot' of method 'hasInstallationConfigurationChanged' must not be null";
        assert (result != null) : "Parameter 'result' of method 'hasInstallationConfigurationChanged' must not be null";
        return false;
    }

    public final List<IWorkspaceDependencyElement> getWorkspaceDependencyElements(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getWorkspaceDependencyElements' must not be null";
        Workspace ws = softwareSystem.getUniqueExistingChild(Workspace.class);
        ArrayList<IWorkspaceDependencyElement> result = new ArrayList<IWorkspaceDependencyElement>();
        result.addAll(ws.getChildren(IWorkspaceDependencyElement.class));
        for (External anExternal : ws.getChildren(External.class)) {
            result.addAll(anExternal.getChildren(IWorkspaceDependencyElement.class));
        }
        return result;
    }

    public abstract LogicalSystemNamespace createLogicalSystemNamespace(NamedElement var1, String var2);

    public abstract LogicalModuleNamespace createLogicalModuleNamespace(NamedElement var1, String var2);

    public abstract String getBundleId();

    public final QualityModelFileDescriptor getQualityModelFileDescriptor() {
        return new QualityModelFileDescriptor(this.getBundleId(), this.getLanguage().getStandardName() + CoreFileType.QUALITY_MODEL.getDefaultExtension(), this.getLanguage().getStandardName() + "/Default" + CoreFileType.QUALITY_MODEL.getDefaultExtension(), this.getLanguage());
    }

    public final int hashCode() {
        return this.m_language.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageProvider other = (LanguageProvider)obj;
        return this.m_language.equals(other.m_language);
    }

    public IWorkspaceDependencyElement findEndpointOfExistingDependency(Workspace workspace, IWorkspaceDependencyElement fromElement, WorkspaceDependency.IWorkspaceDependencyType type, final String toId, String toName, WorkspaceDependency.AdditionalDependencyData additionalDependencyData) {
        assert (workspace != null) : "Parameter 'workspace' of method 'findDependencyEndpoint' must not be null";
        assert (fromElement != null) : "Parameter 'fromElement' of method 'findDependencyEndpoint' must not be null";
        assert (fromElement instanceof NamedElement) : "Unexpected class: " + fromElement.getClass().getName();
        assert (type != null) : "Parameter 'type' of method 'findDependencyEndpoint' must not be null";
        assert (toId != null && toId.length() > 0) : "Parameter 'toId' of method 'findDependencyEndpoint' must not be empty";
        assert (toName != null && toName.length() > 0) : "Parameter 'toName' of method 'findDependencyEndpoint' must not be empty";
        assert (additionalDependencyData != null) : "Parameter 'additionalDependencyData' of method 'findDependencyEndpoint' must not be null";
        for (IWorkspaceDependencyElement next : workspace.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!($assertionsDisabled || namedElement != null && namedElement instanceof IWorkspaceDependencyElement)) {
                    throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(namedElement)));
                }
                return toId.equals(((IWorkspaceDependencyElement)((Object)namedElement)).getId()) && (LanguageProvider.this.getModuleClass().isAssignableFrom(namedElement.getClass()) || namedElement instanceof UnresolvedWorkspaceDependencyElement);
            }
        }, IWorkspaceDependencyElement.class)) {
            if (fromElement.getOutgoingWorkspaceDependency(next) == null) continue;
            return next;
        }
        return null;
    }

    public IWorkspaceDependencyElement findWorkspaceDependencyElement(Workspace workspace, IWorkspaceDependencyElement fromElement, WorkspaceDependency.IWorkspaceDependencyType type, final String toId, String toName, WorkspaceDependency.AdditionalDependencyData additionalDependencyData, boolean needsReparse) {
        assert (workspace != null) : "Parameter 'workspace' of method 'findDependencyEndpoint' must not be null";
        assert (fromElement != null) : "Parameter 'fromElement' of method 'findDependencyEndpoint' must not be null";
        assert (fromElement instanceof NamedElement) : "Unexpected class: " + fromElement.getClass().getName();
        assert (type != null) : "Parameter 'type' of method 'findDependencyEndpoint' must not be null";
        assert (toId != null && toId.length() > 0) : "Parameter 'toId' of method 'findDependencyEndpoint' must not be empty";
        assert (toName != null && toName.length() > 0) : "Parameter 'toName' of method 'findDependencyEndpoint' must not be empty";
        assert (additionalDependencyData != null) : "Parameter 'additionalDependencyData' of method 'findDependencyEndpoint' must not be null";
        return workspace.getUniqueChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!($assertionsDisabled || namedElement != null && namedElement instanceof Module)) {
                    throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(namedElement)));
                }
                return toId.equals(((Module)namedElement).getId());
            }
        }, this.getModuleClass());
    }

    public void applyInstallationParameters(Map<String, String> instSpecificParameters, OperationResult result) {
        assert (instSpecificParameters != null && !instSpecificParameters.isEmpty()) : "Parameter 'instSpecificParameters' of method 'applyInstallationParameters' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'applyInstallationParameters' must not be null";
    }

    public RootPathType getRootPathTypeForModuleMatching() {
        return RootPathType.STANDARD;
    }

    public List<? extends RootDirectoryPath> getRootDirectoryPaths(Module module, RootPathType type) {
        assert (module != null) : "Parameter 'module' of method 'getRootDirectoryPaths' must not be null";
        assert (type != null) : "Parameter 'type' of method 'getRootDirectoryPaths' must not be null";
        return module.getChildren(RootDirectoryPath.class);
    }

    public boolean createMissingRootDirectoryPathOnSync(RootPathType type) {
        assert (type != null) : "Parameter 'type' of method 'createMissingRootDirectoryPathOnSync' must not be null";
        return false;
    }

    protected void aboutToLoadSoftwareSystem(Properties systemProps, OperationResult result) {
        assert (systemProps != null) : "Parameter 'systemProps' of method 'aboutToLoadSoftwareSystem' must not be null";
        assert (result != null) : "Parameter 'result' of method 'aboutToLoadSoftwareSystem' must not be null";
    }

    public abstract List<IAssignableAttributeRetriever> createAssignableAttributeRetrievers();

    public abstract Collection<String> getSourceExtensions();

    @Override
    public IMetricAwareLanguageProvider.IWeightedAverageCalculator createWeightedAverageCalculator() {
        return new WeightedAverageCalculator();
    }

    public boolean delayedParsing() {
        return false;
    }

    public boolean controlsParserModelRefresh() {
        return false;
    }

    public boolean checkWorkspaceDependenciesFromSnapshot() {
        return true;
    }

    public boolean moduleOrderIsRelevant() {
        return true;
    }

    public boolean supportsDeltaRefresh() {
        return true;
    }

    private static final class SimpleSynchronizationLock {
        private SimpleSynchronizationLock() {
        }
    }
}

