/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.treemap;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.treemap.ITreeMapCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.treemap.ITreeMapCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.treemap.TreeMapCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ITreeMapExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DeleteTreeMapFilesCommand
extends TreeMapCommand<IDeleteTreeMapFilesInteraction> {
    public DeleteTreeMapFilesCommand(ISoftwareSystemProvider provider, IDeleteTreeMapFilesInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_TREE_MAPS;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        DeleteTreeMapFilesData data = new DeleteTreeMapFilesData();
        if (((IDeleteTreeMapFilesInteraction)this.getInteraction()).collect(data)) {
            StringBuilder question = new StringBuilder("This will delete ");
            question.append(data.getFiles().size()).append(" treemap(s):\n");
            int i = 1;
            for (TreeMapFile nextFile : data.getFiles()) {
                question.append("\n(").append(i).append(") ").append(nextFile.getIdentifyingPath());
                ++i;
            }
            question.append("\n\nThis cannot be undone. Continue?");
            if (!((IDeleteTreeMapFilesInteraction)this.getInteraction()).confirmDeletion(question.toString())) {
                return;
            }
            ITreeMapExtension extension = this.getController().getSoftwareSystem().getExtension(ITreeMapExtension.class);
            OperationResult result = extension.deleteTreeMaps(workerContext, data.getFiles());
            ((IDeleteTreeMapFilesInteraction)this.getInteraction()).processDeleteTreeMapFilesResult(result);
        }
    }

    public static final class DeleteTreeMapFilesData
    implements ITreeMapCommandInteractionData {
        private List<TreeMapFile> m_files;

        DeleteTreeMapFilesData() {
        }

        public final void setFiles(List<TreeMapFile> files) {
            assert (files != null && !files.isEmpty()) : "Parameter 'files' of method 'setFiles' must not be empty";
            this.m_files = new ArrayList<TreeMapFile>(files);
        }

        final List<TreeMapFile> getFiles() {
            assert (this.m_files != null && !this.m_files.isEmpty()) : "'m_files' of method 'getFiles' must not be empty";
            return Collections.unmodifiableList(this.m_files);
        }
    }

    public static interface IDeleteTreeMapFilesInteraction
    extends ITreeMapCommandInteraction {
        public boolean collect(DeleteTreeMapFilesData var1);

        public boolean confirmDeletion(String var1);

        public void processDeleteTreeMapFilesResult(OperationResult var1);
    }
}

