/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.diff;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionWithResult;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISystemDiffExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.Baseline;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.List;

public final class DeleteBaselinesCommand
extends SoftwareSystemBasedCommand<IDeleteInteraction> {
    public DeleteBaselinesCommand(ISoftwareSystemProvider provider, IDeleteInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_BASELINES;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        ISystemDiffExtension extension = this.getSoftwareSystem().getExtension(ISystemDiffExtension.class);
        InteractionData data = new InteractionData();
        if (!((IDeleteInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        ((IDeleteInteraction)this.getInteraction()).processResult(extension.deleteBaselines(workerContext, data.getToDelete()));
    }

    public static interface IDeleteInteraction
    extends ICommandInteractionWithResult {
        public boolean collect(InteractionData var1);

        public boolean confirmDeletion(String var1);
    }

    public static final class InteractionData {
        private final List<Baseline> m_toDelete = new ArrayList<Baseline>();

        public void addBaseline(Baseline toDelete) {
            assert (toDelete != null) : "Parameter 'toDelete' of method 'addBaseline' must not be null";
            this.m_toDelete.add(toDelete);
        }

        List<Baseline> getToDelete() {
            return this.m_toDelete;
        }
    }
}

