/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeConnection;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class CreateAllowedArtifactConnectionCommand
extends ArchitecturalViewCommand<ICreateAllowedArtifactConnectionInteraction> {
    public CreateAllowedArtifactConnectionCommand(ISoftwareSystemProvider provider, ICreateAllowedArtifactConnectionInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_ALLOWED_ARCHITECTURAL_VIEW_ARTIFACT_CONNECTION;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        CreateAllowedArtifactConnectionData data = new CreateAllowedArtifactConnectionData();
        if (!((ICreateAllowedArtifactConnectionInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.createAllowedArtifactConnection(workerContext, data.getDependency());
        ((ICreateAllowedArtifactConnectionInteraction)this.getInteraction()).processCreateAllowedArtifactConnectionResult(result);
    }

    public static final class CreateAllowedArtifactConnectionData
    implements IArchitecturalViewCommandInteractionData {
        private ArtifactNodeConnection m_dependency;

        public final void setDependency(ArtifactNodeConnection dependency) {
            assert (dependency != null) : "Parameter 'dependency' of method 'setDependency' must not be null";
            this.m_dependency = dependency;
        }

        final ArtifactNodeConnection getDependency() {
            assert (this.m_dependency != null) : "'m_dependency' of method 'getDependency' must not be null";
            return this.m_dependency;
        }
    }

    public static interface ICreateAllowedArtifactConnectionInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(CreateAllowedArtifactConnectionData var1);

        public void processCreateAllowedArtifactConnectionResult(OperationResult var1);
    }
}

