/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public abstract class EditFilterPatternCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public EditFilterPatternCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    protected final void internalRun(IWorkerContext workerContext) {
        Data data = new Data();
        if (!((IInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IWorkspaceExtension.class).editPattern(workerContext, data.getOriginalPattern(), data.getNewPattern());
        ((IInteraction)this.getInteraction()).processEditResult(result);
    }

    public static final class Data
    implements ICommandInteractionData {
        private Pattern m_originalPattern;
        private String m_newPattern;

        Data() {
        }

        public void setData(Pattern originalPattern, String newPattern) {
            assert (originalPattern != null) : "Parameter 'originalPattern' of method 'setData' must not be null";
            assert (newPattern != null) : "Parameter 'newPattern' of method 'setData' must not be null";
            this.m_originalPattern = originalPattern;
            this.m_newPattern = newPattern;
        }

        String getNewPattern() {
            assert (this.m_newPattern != null) : "'m_newPattern' of method 'getNewPattern' must not be null";
            return this.m_newPattern;
        }

        Pattern getOriginalPattern() {
            assert (this.m_originalPattern != null) : "Parameter 'm_originalPattern' of method 'getOriginalPattern' must not be null";
            return this.m_originalPattern;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(Data var1);

        public void processEditResult(OperationResult var1);
    }
}

