/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class CreateManualWorkspaceDependencyCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public CreateManualWorkspaceDependencyCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_MANUAL_WORKSPACE_DEPENDENCY;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        WorkspaceDependencyData data = new WorkspaceDependencyData();
        if (((IInteraction)this.getInteraction()).collect(data)) {
            OperationResult result = this.getController().getSoftwareSystem().getExtension(IWorkspaceExtension.class).createManualDependency(workerContext, data.getFrom(), data.getTo());
            ((IInteraction)this.getInteraction()).processWorkspaceDependencyCreationResult(result);
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(WorkspaceDependencyData var1);

        public void processWorkspaceDependencyCreationResult(OperationResult var1);
    }

    public static final class WorkspaceDependencyData
    implements ICommandInteractionData {
        private IWorkspaceDependencyElement m_from;
        private IWorkspaceDependencyElement m_to;

        public void setEndpoints(IWorkspaceDependencyElement from, IWorkspaceDependencyElement to) {
            assert (from != null) : "Parameter 'from' of method 'setEndpoints' must not be null";
            assert (to != null) : "Parameter 'to' of method 'setEndpoints' must not be null";
            assert (from != to) : "Same instance";
            this.m_from = from;
            this.m_to = to;
        }

        IWorkspaceDependencyElement getFrom() {
            assert (this.m_from != null) : "'m_from' of method 'getFrom' must not be null";
            return this.m_from;
        }

        IWorkspaceDependencyElement getTo() {
            assert (this.m_to != null) : "'m_to' of method 'getTo' must not be null";
            return this.m_to;
        }
    }
}

