/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.CreateRepresentationFromScratchCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graph.GraphMode;
import com.hello2morrow.sonargraph.core.model.graph.GraphRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public abstract class CreateGraphRepresentationFromScratchCommand
extends CreateRepresentationFromScratchCommand<GraphRepresentation> {
    public static final ICommandId ID = CoreCommandId.CREATE_GRAPH_REPRESENTATION_FROM_SELECTION;
    private final EndpointType m_endpointType;
    private final boolean m_applyCycleAnalysis;
    private final GraphMode m_graphMode;

    public CreateGraphRepresentationFromScratchCommand(ISoftwareSystemProvider controller, Set<NamedElement> mainNodes, FocusMode focusMode, PresentationMode presentationMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, Set<CoreParserDependencyType> parserDependencyTypes, EndpointType endpointType, GraphMode graphMode, boolean applyCycleAnalysis) {
        super(controller, mainNodes, focusMode, presentationMode, properties, parserDependencyTypes, false);
        assert (endpointType != null) : "Parameter 'endpointType' of method 'CreateGraphRepresentationFromScratchCommand' must not be null";
        this.m_endpointType = endpointType;
        this.m_graphMode = graphMode;
        this.m_applyCycleAnalysis = applyCycleAnalysis;
    }

    @Override
    protected final void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'performRun' must not be null";
        EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties = this.getProperties();
        if (this.m_graphMode != null) {
            properties.add(NodeAndEdgeRepresentation.RepresentationProperty.TYPE_BASED_GRAPH);
            if (this.m_graphMode == GraphMode.TYPE_BASED_EXCLUDING_NESTED_TYPES) {
                properties.add(NodeAndEdgeRepresentation.RepresentationProperty.DONT_COLLECT_TYPES_RECURSIVELY);
            }
        }
        this.setRepresentation(this.createGraphRepresentation(workerContext, this.getMainNodes(), this.getParserDependencyTypes(), this.getFocusMode(), this.getPresentationMode(), this.m_endpointType, properties, this.m_applyCycleAnalysis));
    }

    @Override
    public final List<String> getAdditionalExecutionInfo() {
        List<String> additionalExecutionInfo = super.getAdditionalExecutionInfo();
        additionalExecutionInfo.add("Endpoint type: " + String.valueOf((Object)this.m_endpointType));
        additionalExecutionInfo.add("Apply cycle analysis?: " + this.m_applyCycleAnalysis);
        additionalExecutionInfo.add("Graph Mode: " + String.valueOf((Object)this.m_graphMode));
        return additionalExecutionInfo;
    }

    protected abstract GraphRepresentation createGraphRepresentation(IWorkerContext var1, Set<NamedElement> var2, Set<CoreParserDependencyType> var3, FocusMode var4, PresentationMode var5, EndpointType var6, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> var7, boolean var8);
}

