/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.installation;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SignatureElement;
import com.hello2morrow.sonargraph.core.model.system.settings.InstallationSettings;
import com.hello2morrow.sonargraph.foundation.file.SectionedData;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusInstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionModel;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GeneratedInstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerDefinitionPersistence;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromBundle;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionFromFile;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompilerDefinitionPersistenceProvider
implements ICompilerDefinitionPersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompilerDefinitionPersistenceProvider.class);
    private final CPlusPlusInstallationSettings m_installationSettings;

    public CompilerDefinitionPersistenceProvider(InstallationSettings installationSettings) {
        assert (installationSettings != null) : "Parameter 'installationSettings' of method 'CompilerDefinitionPersistenceProvider' must not be null";
        assert (installationSettings instanceof CPlusPlusInstallationSettings) : "installationSettings must be of type '" + CPlusPlusInstallationSettings.class.getName() + "'";
        this.m_installationSettings = (CPlusPlusInstallationSettings)installationSettings;
    }

    @Override
    public OperationResultWithOutcome<InstCompilerDefinition> writeDefinition(InstCompilerDefinition definition, TFile file) {
        if (definition == null) {
            return this.deleteDefinition(file);
        }
        return this.updateDefinition(definition, file);
    }

    @Override
    public void addSignatureToDefinition(InstCompilerDefinition definition) {
        assert (definition != null) : "Parameter 'definition' of method 'addSignatureToDefinition' must not be null";
        definition.removeChildren(new Class[]{SignatureElement.class});
        InstCompilerDefinitionBuilder builder = new InstCompilerDefinitionBuilder(definition);
        CompilerDefinitionSignature signature = new CompilerDefinitionSignature((NamedElement)definition, this.createDefinitionSignature(definition.getName(), builder.createSectionedData()));
        definition.addChild((NamedElement)signature);
    }

    private OperationResultWithOutcome<InstCompilerDefinition> updateDefinition(InstCompilerDefinition definition, TFile file) {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Saving compiler definition '" + String.valueOf((Object)definition) + "'");
        InstCompilerDefinitionBuilder builder = new InstCompilerDefinitionBuilder(definition);
        SectionedData data = builder.createSectionedData();
        try {
            data.writeToFile(file);
            CompilerDefinitionSignature signature = new CompilerDefinitionSignature((NamedElement)definition, this.createDefinitionSignature(definition.getName(), data));
            definition.removeChildren(new Class[]{SignatureElement.class});
            definition.addChild((NamedElement)signature);
            result.setOutcome((Object)definition);
        }
        catch (Exception ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, "Failed to save compiler definition to file '" + file.getNormalizedAbsolutePath() + "'", new Object[]{ex});
        }
        return result;
    }

    private void addDetailsToDefinitionPojo(OperationResult result, SectionedData data, InstCompilerDefinition definition) {
        String fixedConfigSection;
        String headerSection = data.getRawContent("Header");
        if (headerSection == null) {
            result.addError((OperationResult.IMessageCause)CppCauses.INSTALLATION_COMPILER_DEFINITION_HAS_ERRORS, "Missing mandatory file section [%s]", new Object[]{"Header"});
            return;
        }
        InstCompilerDefinitionBuilder builder = new InstCompilerDefinitionBuilder(definition);
        builder.processHeader(headerSection, result);
        if (result.isFailure()) {
            return;
        }
        String cSectionText = data.getRawContent("C Options");
        String cppSectionText = data.getRawContent("CPlusPlus Options");
        String commonSectionText = data.getRawContent("Common Options");
        builder.processOptions(cSectionText, cppSectionText, commonSectionText, result);
        String translationSection = data.getRawContent("Option Translations");
        if (translationSection != null) {
            builder.processOptions("Option Translations", translationSection);
        }
        if ((fixedConfigSection = data.getRawContent("Fixed Configuration Properties")) != null) {
            builder.setFixedConfigProperties(fixedConfigSection);
        }
        definition.addChild((NamedElement)new CompilerDefinitionSignature((NamedElement)definition, this.createDefinitionSignature(definition.getName(), data)));
    }

    private String createDefinitionSignature(String name, SectionedData data) {
        return HashSupport.SHA.getHexString(name + data.toString());
    }

    private OperationResultWithOutcome<InstCompilerDefinition> deleteDefinition(TFile file) {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Deleting compiler definition '" + file.getNormalizedAbsolutePath() + "'");
        try {
            file.rm();
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)CppCauses.INSTALLATION_COMPILER_DEFINITION_DELETION_FAILED, (Throwable)ex);
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<InstCompilerDefinition> readDefinition(TFile file, boolean isGeneratedDefinition) {
        SectionedData data;
        assert (file != null) : "Parameter 'file' of method 'readDefinition' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome(String.format("Loading compiler definition '%s'", file.getPath()));
        try {
            data = SectionedData.fromFile((TFile)file);
            if (data == null) {
                String errorMsg = "Cannot load context from file '" + file.getAbsolutePath() + "'. It does not exist.";
                LOGGER.warn(errorMsg);
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, errorMsg, new Object[0]);
                return result;
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Cannot load context from file {}: {}", (Object)file.getAbsolutePath(), (Object)ioe.getMessage());
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ioe);
            return result;
        }
        try {
            LOGGER.debug("Loading compiler definition from: {}", (Object)file.getAbsolutePath());
            result.setOutcome((Object)this.convertCompilerContextToPojo((OperationResult)result, this.m_installationSettings, file, data, isGeneratedDefinition));
        }
        catch (Throwable ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Error processing compiler options from file '" + file.getAbsolutePath() + "': " + ExceptionUtility.collectFirstAndLast((Throwable)ex), new Object[0]);
        }
        if (result.containsError()) {
            result.setOutcome(null);
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<InstCompilerDefinition> readDefinition(URL url) {
        assert (url != null);
        OperationResultWithOutcome result = new OperationResultWithOutcome(String.format("Load compiler definition '%s' from bundle", url));
        URLConnection urlConnection = null;
        try {
            urlConnection = url.openConnection();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load compiler definition from: {}", (Object)url.toString());
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "unable to process '%s'", new Object[]{e, url.toString()});
            return result;
        }
        try {
            Throwable e = null;
            Object var5_8 = null;
            try (InputStream in = urlConnection.getInputStream();){
                LOGGER.debug("Loading compiler definition from: {}", (Object)url.toString());
                SectionedData data = SectionedData.fromStream((InputStream)in);
                OperationResult processingDefinition = new OperationResult("Processing compiler definition");
                result.setOutcome((Object)this.convertCompilerContextToPojo(processingDefinition, this.m_installationSettings, url, data));
                if (processingDefinition.containsError()) {
                    result.addWarning((OperationResult.IMessageCause)CppCauses.INSTALLATION_COMPILER_DEFINITION_HAVE_ERRORS, "Definition file contains errors", new Object[]{processingDefinition});
                } else {
                    result.addMessagesFrom(processingDefinition);
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Error processing compiler definition from bundle '%s'", new Object[]{url.toString()});
        }
        if (result.containsError()) {
            result.setOutcome(null);
        }
        return result;
    }

    private String getNameWithoutExtension(String name) {
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos != -1) {
            name = name.substring(0, lastDotPos);
        }
        return name;
    }

    private InstCompilerDefinitionFromBundle convertCompilerContextToPojo(OperationResult result, InstallationSettings installationSettings, URL url, SectionedData data) {
        TFile path = new TFile(url.getPath());
        String compilerName = this.getNameWithoutExtension(path.getName());
        InstCompilerDefinitionFromBundle definition = new InstCompilerDefinitionFromBundle((NamedElement)installationSettings, url, compilerName);
        this.addDetailsToDefinitionPojo(result, data, definition);
        return definition;
    }

    private InstCompilerDefinition convertCompilerContextToPojo(OperationResult result, InstallationSettings installationSettings, TFile file, SectionedData data, boolean isGenerated) {
        String compilerName = this.getNameWithoutExtension(file.getName());
        InstCompilerDefinitionFromFile definition = null;
        definition = isGenerated ? new GeneratedInstCompilerDefinition((NamedElement)installationSettings, file, compilerName) : new InstCompilerDefinitionFromFile((NamedElement)installationSettings, file, compilerName);
        this.addDetailsToDefinitionPojo(result, data, definition);
        return definition;
    }

    private static void writeCppOptions(PrintWriter out, CompilerDefinitionModel model) {
        assert (out != null) : "Parameter 'out' of method 'writeCppOptions' must not be null";
        assert (model != null) : "Parameter 'model' of method 'writeCppOptions' must not be null";
        if (model.isGnuMode()) {
            out.println("--g++");
            out.println("--parse_templates");
            out.println("--type_traits_helpers");
        } else {
            out.println("--c++");
        }
        if (model.isCpp03()) {
            out.println("--c++03");
        }
        if (model.isCpp11()) {
            out.println("--c++11");
        }
        if (model.isCpp14()) {
            out.println("--c++14");
        }
        if (model.isCpp17()) {
            out.println("--c++17");
        }
        if (model.isCpp20()) {
            out.println("--c++20");
        }
        if (model.isCfront21()) {
            out.println("--cfront_2.1");
        }
        if (model.isCfront30()) {
            out.println("--cfront_3.0");
        }
        if (model.isEnableExceptionHandling()) {
            out.println("--x");
        }
        for (String opt : model.getCppModel().getOptions()) {
            out.println(opt);
        }
        out.println("-tnone");
        for (String dir : model.getCppModel().getSystemIncludes()) {
            out.format("--sys_include=%s\n", dir);
        }
    }

    private static void writeCOptions(PrintWriter out, CompilerDefinitionModel model) {
        assert (out != null) : "Parameter 'out' of method 'writeCOptions' must not be null";
        assert (model != null) : "Parameter 'model' of method 'writeCOptions' must not be null";
        if (model.isGnuMode()) {
            out.println("--gcc");
        } else {
            out.println("--c");
        }
        if (model.isC89()) {
            out.println("--c89");
        }
        if (model.isC99()) {
            out.println("--c99");
        }
        if (model.isC11()) {
            out.println("--c11");
        }
        for (String opt : model.getcModel().getOptions()) {
            out.println(opt);
        }
        for (String dir : model.getcModel().getSystemIncludes()) {
            out.format("--sys_include=%s\n", dir);
        }
    }

    public static OperationResult createCompilerDefinition(CompilerDefinitionModel model, TFile file, OperationResult result) {
        assert (model != null) : "Parameter 'model' of method 'createCompilerDefinition' must not be null";
        assert (file != null) : "Parameter 'file' of method 'createCompilerDefinition' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createCompilerDefinition' must not be null";
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (PrintWriter out = new PrintWriter((File)file, "UTF-8");){
                int version;
                String[] versionItems;
                out.println("[Header]");
                out.format("Description=%s\n", model.getDescription());
                out.format("LongSize=%d\n", model.getLongSize());
                out.format("PointerSize=%d\n", model.getPointerSize());
                out.format("WideCharSize=%d\n\n", model.getWcharSize());
                out.println("[C Options]");
                if (model.isAllCpp()) {
                    CompilerDefinitionPersistenceProvider.writeCppOptions(out, model);
                } else if (model.isAllowC()) {
                    CompilerDefinitionPersistenceProvider.writeCOptions(out, model);
                } else {
                    out.println("# C parsing disabled");
                }
                out.println("[CPlusPlus Options]");
                if (model.isAllowCpp()) {
                    CompilerDefinitionPersistenceProvider.writeCppOptions(out, model);
                } else {
                    out.println("# C++ parsing disabled");
                }
                out.println("[Common Options]");
                if (model.isMicrosoftMode()) {
                    out.println("--microsoft");
                    out.format("--microsoft_version=%s\n", model.getMicrosoftVersion());
                }
                if (model.isClangMode()) {
                    out.println("--clang");
                    versionItems = model.getClangVersion().split("\\.");
                    version = Integer.valueOf(versionItems[0]) * 10000 + Integer.valueOf(versionItems[1]) * 100 + Integer.valueOf(versionItems[2]);
                    out.format("--clang_version=%d\n", version);
                }
                if (model.isGnuMode()) {
                    versionItems = model.getGnuVersion().split("\\.");
                    version = Integer.valueOf(versionItems[0]) * 10000 + Integer.valueOf(versionItems[1]) * 100 + Integer.valueOf(versionItems[2]);
                    out.format("--gnu_version=%d\n", version);
                }
                if (model.isUnsignedCharacters()) {
                    out.println("--unsigned_chars");
                }
                if (model.isVla()) {
                    out.println("--vla");
                }
                if (out.checkError()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, e.getMessage(), new Object[0]);
        }
        catch (UnsupportedEncodingException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.UNSUPPORTED_ENCODING);
        }
        return result;
    }
}

