/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotSourceFilePath;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.RootDirectorySettings;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModuleType;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CPlusPlusModule
extends Module {
    private final Set<TFile> m_associatedHeaders = new HashSet<TFile>();

    public CPlusPlusModule(NamedElement parent) {
        super(parent);
    }

    public CPlusPlusModule(NamedElement parent, String name, String id) {
        super(parent, name, id);
    }

    public Language getLanguage() {
        return CPlusPlusLanguage.INSTANCE;
    }

    public final String getRootDirectoryPathFileTypePresentationKind(boolean lowerCase) {
        return lowerCase ? "C,C++ source" : "C,C++ Source";
    }

    public Set<TFile> getManuallyAssociatedHeaders() {
        return Collections.unmodifiableSet(this.m_associatedHeaders);
    }

    public Set<TFile> getAssociatedHeaders() {
        return this.getManuallyAssociatedHeaders();
    }

    public void clearAssociatedHeaders() {
        this.m_associatedHeaders.clear();
    }

    public void assignAssociatedHeader(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'assignAssociatedHeader' must not be null";
        this.m_associatedHeaders.add(file);
    }

    public void removeAssociatedHeader(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'removeAssociatedHeader' must not be null";
        this.m_associatedHeaders.remove(file);
    }

    public final String getPresentationKind() {
        return "C,C++ Module";
    }

    public final StructureItem getStructureItem() {
        return StructureItem.MODULE;
    }

    public final RootDirectoryPath createRootDirectoryPath(IModelServiceProvider msp, NamedElement parent, TFile file) {
        return new CppRootDirectoryPath(parent, msp, file);
    }

    public final Class<? extends RootDirectoryPath> getRootDirectoryPathClass() {
        return CppRootDirectoryPath.class;
    }

    public abstract CPlusPlusModuleType getType();

    public final List<? extends ISnapshotSourceFilePath> getSourceFiles() {
        return this.getChildrenRecursively(CppSource.class, new Class[]{ProgrammingElement.class});
    }

    public CompilerOptions getSourceFileOptions(SourceFile sourceFile) {
        ModuleSettings moduleSettings = (ModuleSettings)this.getUniqueChild(ModuleSettings.class);
        SourceFileSettings sourceFileSettings = (SourceFileSettings)((Object)moduleSettings.getUniqueChild(SourceFileSettings.class));
        if (sourceFileSettings != null) {
            return (CompilerOptions)((Object)sourceFileSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(FileUtility.getIdentifyingPath((TFile)sourceFile.getFile())), SourceFileCompilerOptions.class));
        }
        RootDirectoryPath root = (RootDirectoryPath)sourceFile.getParent(RootDirectoryPath.class, new Class[0]);
        assert (root != null);
        RootDirectorySettings settings = (RootDirectorySettings)root.getUniqueChild(RootDirectorySettings.class);
        if (settings == null) {
            return null;
        }
        for (SourceFileNode node : settings.getChildren(SourceFileNode.class)) {
            if (!node.getPath().equals(sourceFile.getName())) continue;
            return node.getCompilerOptions();
        }
        return null;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCPlusPlusModule(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCPlusPlusModule(CPlusPlusModule var1);
    }
}

