/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioProjectReference;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VisualStudioProjectFile
extends FilePath {
    private SolutionFileInfo.ConfigurationAndPlatform m_configuration;
    private String m_projectName;
    private String m_projectGuid;
    private final Map<String, List<TFile>> m_sourceFiles = new HashMap<String, List<TFile>>();
    private final Set<String> m_sourceFileExtensions = new HashSet<String>();
    private final List<TFile> m_headerFiles = new ArrayList<TFile>();
    private List<VisualStudioProjectReference> m_projectReferences = new ArrayList<VisualStudioProjectReference>();
    private TFile m_solutionDir;
    private String m_filePathWithEnvVars;

    public VisualStudioProjectFile(NamedElement parent) {
        super(parent);
    }

    public VisualStudioProjectFile(NamedElement parent, TFile file) {
        super(parent, file);
    }

    public void setSolutionDir(TFile solutionDir) {
        this.m_solutionDir = solutionDir;
    }

    public TFile getSolutionDir() {
        return this.m_solutionDir;
    }

    public IFileType getFileType() {
        return new VisualStudioProjectFileType();
    }

    public void setConfiguration(SolutionFileInfo.ConfigurationAndPlatform configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'setConfigurationName' must not be null";
        this.m_configuration = configuration;
    }

    public SolutionFileInfo.ConfigurationAndPlatform getConfiguration() {
        return this.m_configuration;
    }

    public void setHeaderFiles(Collection<TFile> headers) {
        this.m_headerFiles.clear();
        this.m_headerFiles.addAll(headers);
    }

    public Collection<TFile> getAssociatedHeaders() {
        return Collections.unmodifiableList(this.m_headerFiles);
    }

    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public void addSourceFile(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'addSourceFile' must not be null";
        String directoryPath = file.getParentFile().getNormalizedAbsolutePath();
        if (!this.m_sourceFiles.containsKey(directoryPath)) {
            this.m_sourceFiles.put(directoryPath, new ArrayList());
        }
        this.m_sourceFiles.get(directoryPath).add(file);
        this.m_sourceFileExtensions.add(FileUtility.getExtension((TFile)file));
    }

    public List<TFile> getSourceFiles() {
        ArrayList<TFile> sourceFiles = new ArrayList<TFile>();
        for (List<TFile> files : this.m_sourceFiles.values()) {
            sourceFiles.addAll(files);
        }
        return Collections.unmodifiableList(sourceFiles);
    }

    public Set<String> getCppSourceFileExtensions() {
        return Collections.unmodifiableSet(this.m_sourceFileExtensions);
    }

    public List<TFile> getSourceFilesForDirectory(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'getSourceFilesForDirectory' must not be null";
        assert (dir.isDirectory()) : "Paramater 'dir' of method 'getSourceFilesForDirectory' must be a directory";
        String path = dir.getNormalizedAbsolutePath();
        if (!this.m_sourceFiles.containsKey(path)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_sourceFiles.get(path));
    }

    public void removeSourceFiles() {
        this.m_sourceFiles.clear();
    }

    public String getProjectGuid() {
        return this.m_projectGuid;
    }

    public void setProjectGuid(String projectGuid) {
        assert (projectGuid != null) : "Parameter 'projectGuid' of method 'setProjectGuid' must not be null";
        this.m_projectGuid = projectGuid;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public void setProjectName(String projectName) {
        assert (projectName != null && projectName.length() > 0) : "Parameter 'projectName' of method 'setProjectName' must not be empty";
        this.m_projectName = projectName;
    }

    public void addProjectReference(VisualStudioProjectReference reference) {
        assert (reference != null) : "Parameter 'reference' of method 'addProjectReference' must not be null";
        if (!this.m_projectReferences.contains(reference)) {
            this.m_projectReferences.add(reference);
        }
    }

    public List<VisualStudioProjectReference> getProjectReferences() {
        return Collections.unmodifiableList(this.m_projectReferences);
    }

    public void setProjectReferences(List<VisualStudioProjectReference> references) {
        assert (references != null) : "Parameter 'references' of method 'setProjectReferences' must not be null";
        this.m_projectReferences = references;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitVisualStudioProjectFile(this);
        } else {
            super.accept(visitor);
        }
    }

    public void setFilePathWithEnvVars(String filePathWithEnvVars) {
        assert (filePathWithEnvVars != null && filePathWithEnvVars.length() > 0) : "Parameter 'filePathWithEnvVars' of method 'setFilePathWithEnvVars' must not be empty";
        this.m_filePathWithEnvVars = filePathWithEnvVars;
    }

    public String getFilePathWithEnvVars() {
        return this.m_filePathWithEnvVars;
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitVisualStudioProjectFile(VisualStudioProjectFile var1);
    }

    public static class VisualStudioProjectFileType
    implements IFileType {
        public String getStandardName() {
            return "Visual Studio File Type";
        }

        public String getPresentationName() {
            return this.getStandardName();
        }

        public String[] getExtensions() {
            return new String[]{this.getDefaultExtension()};
        }

        public String getDefaultExtension() {
            return CPlusPlusFileType.VISUAL_STUDIO_PROJECT_FILE.getDefaultExtension();
        }

        public boolean hasExtension(String extension) {
            assert (extension != null) : "Parameter 'extension' of method 'hasExtension' must not be null";
            return extension.isEmpty();
        }

        public boolean endsWith(String name) {
            assert (name != null) : "'name' must not be null";
            String[] stringArray = this.getExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nextExtension = stringArray[n2];
                if (name.endsWith(nextExtension)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

