/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.ArrayOf;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.BasicType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.ConstVolatileModifier;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.ConstVolatilePointerTo;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignatureDecoder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignatureVisitorBase;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.FunctionReturning;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.LiteralTypeName;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.PointerTo;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.PointerToMember;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.ReferenceTo;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.TemplateType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.Type;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.VariableParameterList;
import java.util.List;

public class CppSignaturePrinter
extends CppSignatureVisitorBase {
    protected final StringBuilder m_builder = new StringBuilder();
    protected final boolean m_includeReturnType;

    protected CppSignaturePrinter(boolean includeReturnType) {
        this.m_includeReturnType = includeReturnType;
    }

    private void printTypeList(List<Type> typeList) {
        String prefix = "";
        this.m_builder.append('(');
        for (Type t : typeList) {
            this.m_builder.append(prefix);
            this.m_builder.append(this.print(t, this.m_includeReturnType));
            prefix = ", ";
        }
        this.m_builder.append(')');
    }

    protected void printFunction(FunctionReturning f, String core, boolean isConst, boolean isVolatile, boolean printReturnType) {
        if (printReturnType && core != null && core.length() > 0) {
            f.getReturnType().accept(this);
            printReturnType = false;
        }
        this.m_builder.append(core);
        this.printTypeList(f.getParameters());
        if (isConst) {
            this.m_builder.append(" const");
        }
        if (isVolatile) {
            this.m_builder.append(" volatile");
        }
        if (printReturnType) {
            this.m_builder.append(": ");
            f.getReturnType().accept(this);
        }
    }

    @Override
    public void visitArrayOf(ArrayOf type) {
        type.getType().accept(this);
        this.m_builder.append("[]");
    }

    @Override
    public void visitBasicType(BasicType type) {
        this.m_builder.append(type.getKind().getLiteral());
    }

    @Override
    public void visitConstVolatileModifier(ConstVolatileModifier type) {
        Type target = type.getType();
        if (target instanceof FunctionReturning) {
            FunctionReturning f = (FunctionReturning)target;
            this.printFunction(f, "", type.isConst(), type.isVolatile(), this.m_includeReturnType);
        } else {
            if (type.isConst()) {
                this.m_builder.append("const ");
            }
            if (type.isVolatile()) {
                this.m_builder.append("volatile ");
            }
            type.getType().accept(this);
        }
    }

    @Override
    public void visitConstVolatilePointerTo(ConstVolatilePointerTo type) {
        Type target = type.getType();
        if (target instanceof FunctionReturning) {
            FunctionReturning f = (FunctionReturning)target;
            if (type.isConst() && type.isVolatile()) {
                this.printFunction(f, "(*const volatile)", false, false, true);
            } else if (type.isConst()) {
                this.printFunction(f, "(*const)", false, false, true);
            } else {
                this.printFunction(f, "(*volatile)", false, false, true);
            }
        } else {
            target.accept(this);
            if (type.isConst() && type.isVolatile()) {
                this.m_builder.append("*const volatile");
            } else if (type.isConst()) {
                this.m_builder.append("*const");
            } else {
                this.m_builder.append("*volatile");
            }
        }
    }

    protected String getAndResetBuffer() {
        String result = this.m_builder.toString();
        this.m_builder.setLength(0);
        return result;
    }

    @Override
    public void visitFunctionReturning(FunctionReturning type) {
        this.printFunction(type, "", false, false, this.m_includeReturnType);
    }

    @Override
    public void visitLiteralTypeName(LiteralTypeName type) {
        this.m_builder.append(type.getLiteral());
    }

    @Override
    public void visitPointerTo(PointerTo type) {
        Type target = type.getType();
        if (target instanceof FunctionReturning) {
            FunctionReturning f = (FunctionReturning)target;
            this.printFunction(f, "(*)", false, false, true);
        } else {
            target.accept(this);
            this.m_builder.append("*");
        }
    }

    @Override
    public void visitPointerToMember(PointerToMember type) {
        Type target = type.getType();
        if (target instanceof FunctionReturning) {
            FunctionReturning f = (FunctionReturning)target;
            this.printFunction(f, "(" + type.getMemberOfName() + "::*)", false, false, true);
        } else {
            target.accept(this);
            this.m_builder.append(" " + type.getMemberOfName() + "::*");
        }
    }

    @Override
    public void visitReferenceTo(ReferenceTo type) {
        type.getType().accept(this);
        this.m_builder.append(type.isRvalueReference() ? "&&" : "&");
    }

    protected String truncateName(String typeName) {
        int ltPos = typeName.indexOf(60);
        if (ltPos > 0) {
            typeName = typeName.substring(0, ltPos);
        }
        return typeName;
    }

    @Override
    public void visitTemplateType(TemplateType type) {
        String prefix = "";
        this.m_builder.append(this.truncateName(type.getTemplate().getLiteral()));
        this.m_builder.append('<');
        for (Type t : type.getParameters()) {
            this.m_builder.append(prefix);
            this.m_builder.append(this.print(t, this.m_includeReturnType));
            prefix = ", ";
        }
        this.m_builder.append('>');
    }

    @Override
    public void visitVariableParameterList(VariableParameterList type) {
        this.m_builder.append("...");
    }

    public String toString() {
        return this.m_builder.toString();
    }

    protected String print(Type type, boolean includeReturnType) {
        CppSignaturePrinter printer = new CppSignaturePrinter(includeReturnType);
        type.accept(printer);
        return printer.toString();
    }

    public static String print(String sig, boolean includeReturnType) {
        CppSignaturePrinter printer = new CppSignaturePrinter(includeReturnType);
        Type type = CppSignatureDecoder.decode(sig);
        type.accept(printer);
        return printer.toString();
    }

    public static String print(String sig) {
        return CppSignaturePrinter.print(sig, true);
    }
}

