/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CppAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.ICppHasAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppHasSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceMember;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.IHasFqnSerialNumber;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.NameHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDeclaresDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignatureParser;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.OldSignatureHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CppVariable
extends ProgrammingElement
implements ICppHasSignature,
ICppNamespaceMember,
ICppHasAccessSpecifier,
IHasFqnSerialNumber {
    private String m_signature = CppSignatureParser.UNDEFINED;
    private CppAccessSpecifier m_accessSpecifier = CppAccessSpecifier.PUBLIC;
    private boolean m_isDefinition;
    private boolean m_isStatic;
    private boolean m_residesInAnonymousNamespace = false;
    private short m_serialNumberForQualifiedName = 0;

    public CppVariable(NamedElement parent) {
        super(parent);
    }

    public CppVariable(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, boolean isDefinition, boolean isStatic, boolean residesInAnonynousNamespace) {
        super(msp, parent, name, lineNumber);
        this.m_isDefinition = isDefinition;
        this.m_isStatic = isStatic;
        this.m_residesInAnonymousNamespace = residesInAnonynousNamespace;
    }

    @Override
    public boolean residesInAnonymousNamespace() {
        return this.m_residesInAnonymousNamespace;
    }

    public ProgrammingElement getOriginal() {
        return (ProgrammingElement)this.getOriginal(this.getModelServiceProvider());
    }

    public ProgrammingElement getRepresentative() {
        return (ProgrammingElement)this.getRepresentative(this.getModelServiceProvider());
    }

    public final String getImageResourceName() {
        return CppVariable.class.getSimpleName();
    }

    public String getInformation() {
        return this.m_isDefinition ? "Definition" : "Declaration";
    }

    @Property
    public boolean isStatic() {
        return this.m_isStatic;
    }

    public String getName() {
        return NameHelper.getFullName((NamedElement)this);
    }

    public boolean isMember() {
        return this.getParent() instanceof CppClassStructUnion;
    }

    public boolean isConst() {
        return Type.fromSignature(this.m_signature).isConst();
    }

    @Override
    public String getSignature() {
        return this.m_signature;
    }

    @Override
    public void setSignature(String signature) {
        this.m_signature = signature;
    }

    public List<? extends ProgrammingElement> getDefinitions() {
        if (this.isDefinition()) {
            return super.getDefinitions();
        }
        ArrayList<CppVariable> result = new ArrayList<CppVariable>();
        for (ParserDependency dep : this.getOutgoingDependencies(new IParserDependencyType[]{CppDependencyType.DECLARES})) {
            result.add((CppVariable)dep.getTo());
        }
        return result;
    }

    public CppVariable getDefinition() {
        if (this.m_isDefinition) {
            return this;
        }
        ParserDependency dep = this.getFirstDependencyByDependencyType(CppDependencyType.DECLARES);
        return dep == null ? null : (CppVariable)dep.getTo();
    }

    public void setAccessSpecifier(CppAccessSpecifier a) {
        this.m_accessSpecifier = a;
    }

    @Override
    public CppAccessSpecifier getAccessSpecifier() {
        return this.m_accessSpecifier;
    }

    @Override
    public boolean isDefinition() {
        return this.m_isDefinition;
    }

    @Override
    public ProgrammingElement getProgrammingElement() {
        return this;
    }

    public void markAsDefinition() {
        this.m_isDefinition = true;
    }

    public int clearInvalidDefinitions() {
        int count = 0;
        for (ParserDependency dep : this.getOutgoingDependencies(new IParserDependencyType[]{CppDependencyType.DECLARES})) {
            if (!dep.getTo().isValid()) {
                dep.getFrom().removeDependency(dep);
                continue;
            }
            ++count;
        }
        return count;
    }

    public int addDefinition(CppVariable definition) {
        assert (definition != null) : "Parameter 'definition' of method 'addDefinition' must not be null";
        boolean found = false;
        int count = 0;
        for (ParserDependency dep : this.getOutgoingDependencies(new IParserDependencyType[]{CppDependencyType.DECLARES})) {
            if (dep.getTo() == definition) {
                found = true;
            }
            ++count;
        }
        if (!found) {
            this.addDependency(new CppDeclaresDependency(this, definition));
            ++count;
        }
        return count;
    }

    @Override
    public void setSerialNumberForQualifiedName(short serialNumberFoQualifiedName) {
        this.m_serialNumberForQualifiedName = serialNumberFoQualifiedName;
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        String result = "v" + INNER_NAME_PARTS_SEPARATOR + super.getFullyQualifiedNamePart();
        if (this.m_serialNumberForQualifiedName > 0) {
            result = result + INNER_NAME_PARTS_SEPARATOR + Short.toString(this.m_serialNumberForQualifiedName);
        }
        return result;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_signature);
        writer.writeByte((byte)this.m_accessSpecifier.ordinal());
        writer.writeByte((byte)((this.m_isDefinition ? 1 : 0) | (this.m_isStatic ? 2 : 0)));
        writer.writeShort(this.m_serialNumberForQualifiedName);
        writer.writeBoolean(this.m_residesInAnonymousNamespace);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        if (reader.getVersion() <= 16) {
            CppSignature sig = new CppSignature(reader);
            this.m_signature = OldSignatureHelper.convert(sig, CppSignatureParser.UNDEFINED);
        } else {
            this.m_signature = reader.readString();
        }
        this.m_accessSpecifier = CppAccessSpecifier.values()[reader.readByte()];
        byte b = reader.readByte();
        this.m_isDefinition = (b & 1) != 0;
        boolean bl = this.m_isStatic = (b & 2) != 0;
        if (reader.getVersion() >= 21) {
            this.m_serialNumberForQualifiedName = reader.readShort();
        }
        if (reader.getVersion() >= 22) {
            this.m_residesInAnonymousNamespace = reader.readBoolean();
        }
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppVariable(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppVariable(CppVariable var1);
    }
}

