/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceMember;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.IHasFqnSerialNumber;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.NameHelper;
import java.io.IOException;

public abstract class CppClassStructUnion
extends ProgrammingElementWithChildren
implements ICppNamespaceMember,
ICppNamespaceComponent,
IHasFqnSerialNumber {
    private short m_numberOfTemplateArguments;
    private short m_serialNumberForQualifiedName = 0;
    private boolean m_residesInAnonymousNamespace = false;

    protected CppClassStructUnion(NamedElement parent) {
        super(parent);
    }

    protected CppClassStructUnion(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, short numberOfTemplateArguments, boolean residesInAnonymousNamespace) {
        super(msp, parent, name, lineNumber);
        this.m_numberOfTemplateArguments = numberOfTemplateArguments;
        this.m_residesInAnonymousNamespace = residesInAnonymousNamespace;
    }

    @Override
    public boolean residesInAnonymousNamespace() {
        if (this.getParent() instanceof ICppNamespaceMember) {
            return ICppNamespaceMember.super.residesInAnonymousNamespace();
        }
        return this.m_residesInAnonymousNamespace;
    }

    public final ProgrammingElement getOriginal() {
        return (ProgrammingElement)this.getOriginal(this.getModelServiceProvider());
    }

    public final ProgrammingElement getRepresentative() {
        return (ProgrammingElement)this.getRepresentative(this.getModelServiceProvider());
    }

    @Override
    public final ProgrammingElement getProgrammingElement() {
        return this;
    }

    public final boolean isMember() {
        return false;
    }

    public final boolean isTemplate() {
        return this.m_numberOfTemplateArguments > 0;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeShort(this.m_numberOfTemplateArguments);
        writer.writeShort(this.m_serialNumberForQualifiedName);
        writer.writeBoolean(this.m_residesInAnonymousNamespace);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_numberOfTemplateArguments = reader.readShort();
        if (reader.getVersion() >= 15) {
            this.m_serialNumberForQualifiedName = reader.readShort();
        }
        if (reader.getVersion() >= 22) {
            this.m_residesInAnonymousNamespace = reader.readBoolean();
        }
    }

    public CppClassStructUnion getDefinition() {
        return this;
    }

    protected abstract String getFqNamePrefix();

    @Override
    public String getFullyQualifiedNamePart() {
        String fqn = this.getFqNamePrefix() + " " + this.getShortName().replace("::", ".");
        if (this.m_serialNumberForQualifiedName > 0) {
            fqn = fqn + INNER_NAME_PARTS_SEPARATOR + Short.toString(this.m_serialNumberForQualifiedName);
        }
        return fqn;
    }

    @Override
    public void setSerialNumberForQualifiedName(short serialNumberFoQualifiedName) {
        this.m_serialNumberForQualifiedName = serialNumberFoQualifiedName;
    }

    @Override
    public final boolean isDefinition() {
        return this == this.getDefinition();
    }

    public String getName() {
        return NameHelper.getFullName((NamedElement)this);
    }

    public final String getPresentationName(boolean shortName) {
        if (shortName) {
            return this.getShortName();
        }
        return this.getName();
    }

    public final String getRawPresentationName(boolean shortName) {
        String name = shortName ? this.getShortName() : this.getName();
        int pos = name.indexOf(60);
        return pos == -1 ? name : name.substring(0, pos);
    }

    public final int getNumberOfGenericTypeParameters() {
        return this.m_numberOfTemplateArguments;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppClassStructUnion(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppClassStructUnion(CppClassStructUnion var1);
    }
}

