/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ICompilationUnitContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.IElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDGVisitor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.BasicType;
import java.util.function.Consumer;

public class CppSignatureEncoder
extends EDGVisitor {
    private final StringBuffer m_SignatureBuffer = new StringBuffer();
    private int m_templateArgumentNesting = 0;
    private final ICompilationUnitContext m_context;
    private final CppProgrammingElement m_from;
    private CppDependencyType m_depType;
    private final EDG.SourcePosition m_pos;
    private int m_numberOfParameters = -1;
    private final IElementProcessor m_proc;
    private boolean m_isRefernceType = false;

    private void addReferenceTo(EDG.Type obj, char prefix) {
        CppProgrammingElement to;
        CppProgrammingElement cppProgrammingElement = to = this.m_context == null ? null : this.m_context.mapRawType(this.m_proc, obj, this.m_pos, this.m_isRefernceType);
        if (to == null) {
            this.m_SignatureBuffer.append('N');
            String name = obj.sourceCorresp().name();
            if (name == null || name.length() == 0) {
                name = "[anonymous]";
            }
            this.m_SignatureBuffer.append(name);
            this.m_SignatureBuffer.append(';');
        } else {
            if (this.m_from != null && !this.m_from.isExternal()) {
                this.m_from.addDependency(to, this.m_depType, this.m_pos.getPosition().getLineNumber());
            }
            this.m_SignatureBuffer.append(prefix);
            this.m_SignatureBuffer.append(to.getPresentationName());
            this.m_SignatureBuffer.append(';');
        }
    }

    private CppSignatureEncoder(IElementProcessor proc, ICompilationUnitContext context, CppProgrammingElement from, CppDependencyType depType, EDG.SourcePosition pos) {
        this.m_context = context;
        this.m_from = from;
        this.m_depType = depType;
        this.m_pos = pos;
        this.m_proc = proc;
    }

    @Override
    public void visitType(EDG.Type obj) {
        switch (obj.kind()) {
            case TK_VOID: {
                this.m_SignatureBuffer.append(BasicType.Kind.VOID.getEncodedBy());
                break;
            }
            case TK_ERROR: {
                this.m_SignatureBuffer.append(BasicType.Kind.ERROR.getEncodedBy());
                break;
            }
            case TK_NULLPTR: {
                this.m_SignatureBuffer.append(BasicType.Kind.NULL.getEncodedBy());
                break;
            }
            case TK_UNKNOWN: {
                this.m_SignatureBuffer.append(BasicType.Kind.UNKNOWN.getEncodedBy());
                break;
            }
            default: {
                assert (false) : "Unhandled type kind: " + obj.kind().toString();
                break;
            }
        }
    }

    @Override
    public void visitTypeArray(EDG.TypeArray obj) {
        this.m_SignatureBuffer.append('[');
        obj.elementType().accept(this);
    }

    @Override
    public void visitTypeClassStructUnion(EDG.TypeClassStructUnion obj) {
        EDG.SourceCorrespondence sc = obj.sourceCorresp();
        EDG.SourcePosition sp = sc.declPosition();
        String name = sc.name();
        if (sp.seq() == 0L || obj.isNonrealClass() && !obj.isPrototypeInstantiation()) {
            this.m_SignatureBuffer.append('N');
            this.m_SignatureBuffer.append(name);
            this.m_SignatureBuffer.append(';');
        } else if (obj.extraInfo().isLambdaClosureClass()) {
            EDG.Routine r = obj.extraInfo().assocScope().routines();
            while (r != null) {
                if (r.isLambdaBody()) {
                    r.type().accept(this);
                    break;
                }
                r = r.next();
            }
        } else {
            EDG.TemplateArg first = obj.extraInfo().templateArgList();
            if (first != null) {
                CppDependencyType depType = this.m_depType;
                this.m_depType = CppDependencyType.TEMPLATE_PARAMETER_TYPE;
                this.m_SignatureBuffer.append('<');
                ++this.m_templateArgumentNesting;
                EDG.TemplateArg arg = first;
                while (arg != null) {
                    arg.accept(this);
                    arg = arg.next();
                }
                --this.m_templateArgumentNesting;
                this.m_SignatureBuffer.append('>');
                this.m_depType = depType;
            }
            this.addReferenceTo(obj, 'N');
        }
    }

    @Override
    public void visitTemplateArgTempl(EDG.TemplateArgTempl obj) {
        this.m_SignatureBuffer.append("?");
    }

    @Override
    public void visitTemplateArgIntegerValue(EDG.TemplateArgIntegerValue obj) {
        this.m_SignatureBuffer.append('N');
        this.m_SignatureBuffer.append(obj.integerValue());
        this.m_SignatureBuffer.append(';');
    }

    @Override
    public void visitTemplateArgType(EDG.TemplateArgType obj) {
        obj.type().accept(this);
    }

    @Override
    public void visitTemplateArgConstant(EDG.TemplateArgConstant obj) {
        this.m_SignatureBuffer.append("?");
    }

    @Override
    public void visitTypeFloatKind(EDG.TypeFloatKind obj) {
        switch (obj.floatKind()) {
            case FK_DOUBLE: {
                this.m_SignatureBuffer.append(BasicType.Kind.DOUBLE.getEncodedBy());
                break;
            }
            case FK_FLOAT: {
                this.m_SignatureBuffer.append(BasicType.Kind.FLOAT.getEncodedBy());
                break;
            }
            case FK_LONG_DOUBLE: {
                this.m_SignatureBuffer.append(BasicType.Kind.LONG_DOUBLE.getEncodedBy());
                break;
            }
        }
    }

    @Override
    public void visitTypeInteger(EDG.TypeInteger obj) {
        if (obj.boolType()) {
            this.m_SignatureBuffer.append(BasicType.Kind.BOOL.getEncodedBy());
        } else if (obj.enumType()) {
            this.addReferenceTo(obj, 'N');
        } else if (obj.wcharTType()) {
            this.m_SignatureBuffer.append(BasicType.Kind.WCHAR_T.getEncodedBy());
        } else {
            switch (obj.intKind()) {
                case IK_CHAR: {
                    this.m_SignatureBuffer.append(BasicType.Kind.CHAR.getEncodedBy());
                    break;
                }
                case IK_SIGNED_CHAR: {
                    this.m_SignatureBuffer.append(BasicType.Kind.SIGNED_CHAR.getEncodedBy());
                    break;
                }
                case IK_SHORT: {
                    this.m_SignatureBuffer.append(BasicType.Kind.SHORT.getEncodedBy());
                    break;
                }
                case IK_INT: {
                    this.m_SignatureBuffer.append(BasicType.Kind.INT.getEncodedBy());
                    break;
                }
                case IK_LONG: {
                    this.m_SignatureBuffer.append(BasicType.Kind.LONG.getEncodedBy());
                    break;
                }
                case IK_LONG_LONG: {
                    this.m_SignatureBuffer.append(BasicType.Kind.LONG_LONG.getEncodedBy());
                    break;
                }
                case IK_UNSIGNED_CHAR: {
                    this.m_SignatureBuffer.append(BasicType.Kind.UNSIGNED_CHAR.getEncodedBy());
                    break;
                }
                case IK_UNSIGNED_SHORT: {
                    this.m_SignatureBuffer.append(BasicType.Kind.UNSIGNED_SHORT.getEncodedBy());
                    break;
                }
                case IK_UNSIGNED_INT: {
                    this.m_SignatureBuffer.append(BasicType.Kind.UNSIGNED_INT.getEncodedBy());
                    break;
                }
                case IK_UNSIGNED_LONG: {
                    this.m_SignatureBuffer.append(BasicType.Kind.UNSIGNED_LONG.getEncodedBy());
                    break;
                }
                case IK_UNSIGNED_LONG_LONG: {
                    this.m_SignatureBuffer.append(BasicType.Kind.UNSIGNED_LONG_LONG.getEncodedBy());
                    break;
                }
                case IK_INT128: {
                    this.m_SignatureBuffer.append(BasicType.Kind.INT128.getEncodedBy());
                    break;
                }
                case IK_UNSIGNED_INT128: {
                    this.m_SignatureBuffer.append(BasicType.Kind.UINT128.getEncodedBy());
                    break;
                }
            }
        }
    }

    @Override
    public void visitTypePointer(EDG.TypePointer obj) {
        if (obj.isReference()) {
            if (obj.isRvalueReference()) {
                this.m_SignatureBuffer.append('~');
            } else {
                this.m_SignatureBuffer.append('&');
            }
        } else {
            this.m_SignatureBuffer.append('*');
        }
        boolean isRefType = this.m_isRefernceType;
        this.m_isRefernceType = true;
        obj.type().accept(this);
        this.m_isRefernceType = isRefType;
    }

    @Override
    public void visitTypePtrToMember(EDG.TypePtrToMember obj) {
        EDG.TypeClassStructUnion cls = (EDG.TypeClassStructUnion)obj.classOfWhichAMember();
        if (!cls.isNonrealClass() || cls.isPrototypeInstantiation()) {
            CppDependencyType depType = this.m_depType;
            this.m_depType = CppDependencyType.POINTER_TO_MEMBER_OF;
            this.addReferenceTo(cls, '`');
            this.m_depType = depType;
        } else {
            this.m_SignatureBuffer.append('`');
            this.m_SignatureBuffer.append(cls.sourceCorresp().name());
            this.m_SignatureBuffer.append(';');
        }
        obj.type().accept(this);
    }

    @Override
    public void visitTypeRoutine(EDG.TypeRoutine obj) {
        if ((obj.extraInfo().qualifiers() & 3) != 0) {
            this.m_SignatureBuffer.append('$');
            if ((obj.extraInfo().qualifiers() & 1) != 0) {
                this.m_SignatureBuffer.append('c');
            }
            if ((obj.extraInfo().qualifiers() & 2) != 0) {
                this.m_SignatureBuffer.append('v');
            }
            this.m_SignatureBuffer.append('$');
        }
        this.m_SignatureBuffer.append('(');
        this.m_depType = CppDependencyType.PARAMETER_TYPE;
        this.m_numberOfParameters = 0;
        EDG.ParamType pt = obj.extraInfo().paramTypeList();
        while (pt != null) {
            pt.type().accept(this);
            ++this.m_numberOfParameters;
            pt = pt.next();
        }
        if (obj.extraInfo().hasEllipsis()) {
            this.m_SignatureBuffer.append('.');
        }
        this.m_SignatureBuffer.append(")");
        this.m_depType = CppDependencyType.RETURN_TYPE;
        obj.returnType().accept(this);
        EDG.ExceptionSpecification baseSpec = obj.extraInfo().exceptionSpecification();
        if (baseSpec instanceof EDG.ExceptionSpecificationExceptionSpecificationTypeList) {
            EDG.ExceptionSpecificationExceptionSpecificationTypeList spec = (EDG.ExceptionSpecificationExceptionSpecificationTypeList)baseSpec;
            this.m_depType = CppDependencyType.THROW_TYPE;
            this.m_SignatureBuffer.append('(');
            EDG.ExceptionSpecificationType t = spec.exceptionSpecificationTypeList();
            while (t != null) {
                t.type().accept(this);
                t = t.next();
            }
            this.m_SignatureBuffer.append(')');
        }
    }

    @Override
    public void visitTypeTemplateParam(EDG.TypeTemplateParam obj) {
        this.m_SignatureBuffer.append('N');
        EDG.SourceCorrespondence sc = obj.sourceCorresp();
        String name = sc.name();
        this.m_SignatureBuffer.append(name);
        this.m_SignatureBuffer.append(';');
    }

    @Override
    public void visitTypeTyperef(EDG.TypeTyperef obj) {
        if (this.m_templateArgumentNesting > 0) {
            obj.type().accept(this);
        } else {
            EDG.SourceCorrespondence sc = obj.sourceCorresp();
            String typeName = obj.sourceCorresp().name();
            if (typeName == null) {
                if ((obj.qualifiers() & 3) != 0) {
                    this.m_SignatureBuffer.append('$');
                    if ((obj.qualifiers() & 1) != 0) {
                        this.m_SignatureBuffer.append('c');
                    }
                    if ((obj.qualifiers() & 2) != 0) {
                        this.m_SignatureBuffer.append('v');
                    }
                    this.m_SignatureBuffer.append('$');
                }
                obj.type().accept(this);
            } else {
                EDG.SourcePosition sp = sc.declPosition();
                if (sp.seq() == 0L) {
                    this.m_SignatureBuffer.append('N');
                    this.m_SignatureBuffer.append(typeName);
                    this.m_SignatureBuffer.append(';');
                } else {
                    this.addReferenceTo(obj, 'N');
                }
            }
        }
    }

    public static String encode(IElementProcessor proc, EDG.Type type, ICompilationUnitContext context, CppProgrammingElement from, CppDependencyType depType, EDG.SourcePosition pos) {
        return CppSignatureEncoder.encode(proc, type, context, from, depType, pos, null);
    }

    public static String encode(IElementProcessor proc, EDG.Type type, ICompilationUnitContext context, CppProgrammingElement from, CppDependencyType depType, EDG.SourcePosition pos, Consumer<Integer> numberOfParametersConsumer) {
        CppSignatureEncoder encoder = new CppSignatureEncoder(proc, context, from, depType, pos);
        type.accept(encoder);
        if (numberOfParametersConsumer != null) {
            numberOfParametersConsumer.accept(encoder.m_numberOfParameters);
        }
        return encoder.toString().intern();
    }

    public String toString() {
        return this.m_SignatureBuffer.toString();
    }
}

