/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spring.microservices.persistence;

import com.hello2morrow.sonargraph.plugin.spring.microservices.model.ConfigServerConfigurations;
import com.hello2morrow.sonargraph.plugin.spring.microservices.persistence.SpringBootConfigurationReader;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationServerProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServerProcessor.class);

    public ConfigServerConfigurations processConfigurationFiles(TFile resourcesDir, Map<String, Object> configuration) {
        TFile configurationFilesDirectory;
        assert (resourcesDir != null) : "Parameter 'resourcesDir' of method 'processConfigurationFiles' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'processConfigurationFiles' must not be null";
        Object locations = configuration.get("spring.cloud.config.server.native.search-locations");
        if (locations == null) {
            LOGGER.error("Property '{}' is not defined for config server module.", (Object)"spring.cloud.config.server.native.search-locations");
            return null;
        }
        String searchLocation = locations.toString();
        if (searchLocation.startsWith("classpath:")) {
            configurationFilesPath = searchLocation.substring("classpath:".length()).trim();
            configurationFilesDirectory = new TFile((File)resourcesDir, configurationFilesPath);
        } else if (searchLocation.startsWith("file://")) {
            configurationFilesPath = searchLocation.substring("file://".length());
            if (configurationFilesPath.startsWith("/")) {
                configurationFilesPath = searchLocation.substring(1);
            }
            configurationFilesDirectory = new TFile(configurationFilesPath);
        } else {
            LOGGER.error("Failed to locate folder containing application specific configuration files");
            return null;
        }
        if (!configurationFilesDirectory.exists() || !configurationFilesDirectory.isDirectory()) {
            LOGGER.error("Configuration files directory {} does not exist", (Object)configurationFilesDirectory.getNormalizedAbsolutePath());
            return null;
        }
        ConfigServerConfigurations result = new ConfigServerConfigurations();
        TFile[] tFileArray = configurationFilesDirectory.listFiles();
        int n = tFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            TFile next = tFileArray[n2];
            if (next.isFile() && (next.getName().endsWith(".yml") || next.getName().endsWith(".properties"))) {
                String fileNameWithoutExtension = this.getFileNameWithoutExtension(next.getName());
                HashMap<String, Object> config = new HashMap<String, Object>();
                try {
                    SpringBootConfigurationReader.loadConfigurationFromDirectory(configurationFilesDirectory, fileNameWithoutExtension, config);
                    if (fileNameWithoutExtension.equals("application")) {
                        result.setCommonConfiguration(config);
                        LOGGER.debug("Added common configuration");
                    } else {
                        result.addModuleConfiguration(fileNameWithoutExtension, config);
                        LOGGER.debug("Added configuration for '{}'", (Object)fileNameWithoutExtension);
                    }
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to process configuration file " + next.getNormalizedAbsolutePath(), (Throwable)ex);
                }
            }
            ++n2;
        }
        return result;
    }

    private String getFileNameWithoutExtension(String name) {
        int lastIndexOfDot = name.lastIndexOf(46);
        if (lastIndexOfDot < 0) {
            return name;
        }
        return name.substring(0, lastIndexOfDot);
    }
}

