/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerIdImplementation;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonLanguage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public enum PythonAnalyzerId implements IConfigurableAnalyzerId
{
    PYTHON_PACKAGE_CYCLES_SYSTEM(SonargraphFeature.PLATFORM, "Python Package Cycles (System)", "Analyzes package cycles on system level", CycleAnalyzerConfiguration.CREATOR_NAMESPACE_CYCLES, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.CYCLES, Arrays.asList(AnalyzerGroup.CYCLE_METRICS)),
    PYTHON_PACKAGE_CYCLES_SYSTEM_METRICS(SonargraphFeature.PLATFORM, "Python Package Cycle Metrics (System)", "Computes package cycle metrcis on system level", null, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.CYCLE_METRICS, Collections.emptyList()),
    PYTHON_PACKAGE_CYCLES_MODULE(SonargraphFeature.PLATFORM, "Python Package Cycles (Module)", "Analyzes package cycles on module level", CycleAnalyzerConfiguration.CREATOR_NAMESPACE_CYCLES, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.CYCLES, Arrays.asList(AnalyzerGroup.CYCLE_METRICS)),
    PYTHON_PACKAGE_CYCLES_MODULE_METRICS(SonargraphFeature.PLATFORM, "Python Package Cycle Metrics (Module)", "Computes package cycle metrcis on module level", null, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.CYCLE_METRICS, Collections.emptyList());

    private final AnalyzerIdImplementation m_implementation;

    private PythonAnalyzerId(SonargraphFeature feature, String presentationName, String description, IConfigurationCreator creator, AnalyzerExecutionLevel level, AnalyzerGroup group, List<AnalyzerGroup> affectedGroups) {
        this.m_implementation = new AnalyzerIdImplementation(feature, presentationName, description, creator, level, group, affectedGroups);
    }

    public Language getLanguage() {
        return PythonLanguage.INSTANCE;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_implementation.getPresentationName();
    }

    public String getDescription() {
        return this.m_implementation.getDescription();
    }

    public boolean hasConfiguration() {
        return this.m_implementation.hasConfiguration();
    }

    public IConfigurationCreator getConfigurationCreator() {
        return this.m_implementation.getConfigurationCreator();
    }

    public SonargraphFeature getFeature() {
        return this.m_implementation.getFeature();
    }

    public AnalyzerExecutionLevel getExecutionLevel() {
        return this.m_implementation.getExecutionLevel();
    }

    public AnalyzerGroup getGroup() {
        return this.m_implementation.getGroup();
    }

    public Set<AnalyzerGroup> getAffectedGroups() {
        return this.m_implementation.getAffectedGroups();
    }
}

