/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;

public abstract class PythonLexerBase
extends Lexer {
    private Deque<Integer> indentLengthStack;
    private LinkedList<Token> pendingTokens;
    private int previousPendingTokenType;
    private int lastPendingTokenTypeFromDefaultChannel;
    private int opened;
    private Deque<Integer> paren_or_bracket_openedStack;
    private boolean wasSpaceIndentation;
    private boolean wasTabIndentation;
    private boolean wasIndentationMixedWithSpacesAndTabs;
    private final int INVALID_LENGTH = -1;
    private CommonToken curToken;
    private Token ffgToken;
    private final String ERR_TXT = " ERROR: ";

    protected PythonLexerBase(CharStream input) {
        super(input);
        this.init();
    }

    private void init() {
        this.indentLengthStack = new ArrayDeque<Integer>();
        this.pendingTokens = new LinkedList();
        this.previousPendingTokenType = 0;
        this.lastPendingTokenTypeFromDefaultChannel = 0;
        this.opened = 0;
        this.paren_or_bracket_openedStack = new ArrayDeque<Integer>();
        this.wasSpaceIndentation = false;
        this.wasTabIndentation = false;
        this.wasIndentationMixedWithSpacesAndTabs = false;
        this.curToken = null;
        this.ffgToken = null;
    }

    public Token nextToken() {
        this.checkNextToken();
        return this.pendingTokens.pollFirst();
    }

    private void checkNextToken() {
        if (this.previousPendingTokenType != -1) {
            this.setCurrentAndFollowingTokens();
            if (this.indentLengthStack.isEmpty()) {
                this.handleStartOfInput();
            }
            switch (this.curToken.getType()) {
                case 42: 
                case 43: 
                case 44: {
                    ++this.opened;
                    this.addPendingToken((Token)this.curToken);
                    break;
                }
                case 45: 
                case 46: 
                case 47: {
                    --this.opened;
                    this.addPendingToken((Token)this.curToken);
                    break;
                }
                case 93: {
                    this.handleNEWLINEtoken();
                    break;
                }
                case 92: {
                    this.handleSTRINGtoken();
                    break;
                }
                case 5: {
                    this.handleFSTRING_MIDDLE_token();
                    break;
                }
                case 97: {
                    this.reportLexerError("token recognition error at: '" + this.curToken.getText() + "'");
                    this.addPendingToken((Token)this.curToken);
                    break;
                }
                case -1: {
                    this.handleEOFtoken();
                    break;
                }
                default: {
                    this.addPendingToken((Token)this.curToken);
                }
            }
            this.handleFORMAT_SPECIFICATION_MODE();
        }
    }

    private void setCurrentAndFollowingTokens() {
        this.curToken = this.ffgToken == null ? new CommonToken(super.nextToken()) : new CommonToken(this.ffgToken);
        this.handleFStringLexerModes();
        this.ffgToken = this.curToken.getType() == -1 ? this.curToken : super.nextToken();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleStartOfInput() {
        this.indentLengthStack.push(0);
        while (this.curToken.getType() != -1) {
            if (this.curToken.getChannel() == 0) {
                if (this.curToken.getType() != 93) {
                    this.insertLeadingIndentToken();
                    return;
                }
                this.hideAndAddPendingToken(this.curToken);
            } else {
                this.addPendingToken((Token)this.curToken);
            }
            this.setCurrentAndFollowingTokens();
        }
    }

    private void insertLeadingIndentToken() {
        Token prevToken;
        if (this.previousPendingTokenType == 95 && this.getIndentationLength((prevToken = this.pendingTokens.peekLast()).getText()) != 0) {
            String errMsg = "first statement indented";
            this.reportLexerError("first statement indented");
            this.createAndAddPendingToken(1, 0, " ERROR: " + "first statement indented", (Token)this.curToken);
        }
    }

    private void handleNEWLINEtoken() {
        if (this.opened > 0) {
            this.hideAndAddPendingToken(this.curToken);
        } else {
            boolean isLookingAhead;
            CommonToken nlToken = new CommonToken((Token)this.curToken);
            boolean bl = isLookingAhead = this.ffgToken.getType() == 95;
            if (isLookingAhead) {
                this.setCurrentAndFollowingTokens();
            }
            switch (this.ffgToken.getType()) {
                case 93: 
                case 94: {
                    this.hideAndAddPendingToken(nlToken);
                    if (!isLookingAhead) break;
                    this.addPendingToken((Token)this.curToken);
                    break;
                }
                default: {
                    this.addPendingToken((Token)nlToken);
                    if (isLookingAhead) {
                        int indentationLength;
                        int n = indentationLength = this.ffgToken.getType() == -1 ? 0 : this.getIndentationLength(this.curToken.getText());
                        if (indentationLength != -1) {
                            this.addPendingToken((Token)this.curToken);
                            this.insertIndentOrDedentToken(indentationLength);
                            break;
                        }
                        this.reportError("inconsistent use of tabs and spaces in indentation");
                        break;
                    }
                    this.insertIndentOrDedentToken(0);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void insertIndentOrDedentToken(int indentLength) {
        block2: {
            prevIndentLength = this.indentLengthStack.peek();
            if (indentLength <= prevIndentLength) ** GOTO lbl13
            this.createAndAddPendingToken(1, 0, null, this.ffgToken);
            this.indentLengthStack.push(indentLength);
            break block2;
lbl-1000:
            // 1 sources

            {
                this.indentLengthStack.pop();
                prevIndentLength = this.indentLengthStack.peek();
                if (indentLength <= prevIndentLength) {
                    this.createAndAddPendingToken(2, 0, null, this.ffgToken);
                    continue;
                }
                this.reportError("inconsistent dedent");
lbl13:
                // 3 sources

                ** while (indentLength < prevIndentLength)
            }
        }
    }

    private void handleSTRINGtoken() {
        String line_joinFreeStringLiteral = this.curToken.getText().replaceAll("\\\\\\r?\\n", "");
        if (this.curToken.getText().length() == line_joinFreeStringLiteral.length()) {
            this.addPendingToken((Token)this.curToken);
        } else {
            CommonToken originalSTRINGtoken = new CommonToken((Token)this.curToken);
            this.curToken.setText(line_joinFreeStringLiteral);
            this.addPendingToken((Token)this.curToken);
            this.hideAndAddPendingToken(originalSTRINGtoken);
        }
    }

    private void handleFSTRING_MIDDLE_token() {
        String[] arrOfStr;
        String fsMid = this.curToken.getText();
        fsMid = fsMid.replaceAll("\\{\\{", "{_").replaceAll("}}", "}_");
        String[] stringArray = arrOfStr = fsMid.split("(?<=[{}])_");
        int n = arrOfStr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!s.isEmpty()) {
                this.createAndAddPendingToken(5, 0, s, this.ffgToken);
                String lastCharacter = s.substring(s.length() - 1);
                if ("{}".contains(lastCharacter)) {
                    this.createAndAddPendingToken(5, 1, lastCharacter, this.ffgToken);
                }
            }
            ++n2;
        }
    }

    private void handleFStringLexerModes() {
        if (!this._modeStack.isEmpty()) {
            block0 : switch (this.curToken.getType()) {
                case 44: {
                    this.pushMode(0);
                    this.paren_or_bracket_openedStack.push(0);
                    break;
                }
                case 42: 
                case 43: {
                    this.paren_or_bracket_openedStack.push(this.paren_or_bracket_openedStack.pop() + 1);
                    break;
                }
                case 45: 
                case 46: {
                    this.paren_or_bracket_openedStack.push(this.paren_or_bracket_openedStack.pop() - 1);
                    break;
                }
                case 49: {
                    if (this.paren_or_bracket_openedStack.peek() != 0) break;
                    switch (this._modeStack.peek()) {
                        case 1: 
                        case 3: 
                        case 5: {
                            this.mode(5);
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 6: {
                            this.mode(6);
                        }
                    }
                    break;
                }
                case 47: {
                    switch (this._mode) {
                        case 0: 
                        case 5: 
                        case 6: {
                            this.popMode();
                            this.paren_or_bracket_openedStack.pop();
                            break block0;
                        }
                    }
                    this.reportLexerError("f-string: single '}' is not allowed");
                }
            }
        }
    }

    private void handleFORMAT_SPECIFICATION_MODE() {
        if (!this._modeStack.isEmpty() && this.ffgToken.getType() == 47) {
            switch (this.curToken.getType()) {
                case 47: 
                case 49: {
                    this.createAndAddPendingToken(5, 0, "", this.ffgToken);
                }
            }
        }
    }

    private void insertTrailingTokens() {
        switch (this.lastPendingTokenTypeFromDefaultChannel) {
            case 2: 
            case 93: {
                break;
            }
            default: {
                this.createAndAddPendingToken(93, 0, null, this.ffgToken);
            }
        }
        this.insertIndentOrDedentToken(0);
    }

    private void handleEOFtoken() {
        if (this.lastPendingTokenTypeFromDefaultChannel > 0) {
            this.insertTrailingTokens();
        }
        this.addPendingToken((Token)this.curToken);
    }

    private void hideAndAddPendingToken(CommonToken cToken) {
        cToken.setChannel(1);
        this.addPendingToken((Token)cToken);
    }

    private void createAndAddPendingToken(int type, int channel, String text, Token baseToken) {
        CommonToken cToken = new CommonToken(baseToken);
        cToken.setType(type);
        cToken.setChannel(channel);
        cToken.setStopIndex(baseToken.getStartIndex() - 1);
        cToken.setText((String)(text == null ? "<" + this.getVocabulary().getSymbolicName(type) + ">" : text));
        this.addPendingToken((Token)cToken);
    }

    private void addPendingToken(Token token) {
        this.previousPendingTokenType = token.getType();
        if (token.getChannel() == 0) {
            this.lastPendingTokenTypeFromDefaultChannel = this.previousPendingTokenType;
        }
        this.pendingTokens.addLast(token);
    }

    private int getIndentationLength(String textWS) {
        int TAB_LENGTH = 8;
        int length = 0;
        char[] cArray = textWS.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            switch (ch) {
                case ' ': {
                    this.wasSpaceIndentation = true;
                    ++length;
                    break;
                }
                case '\t': {
                    this.wasTabIndentation = true;
                    length += 8 - length % 8;
                    break;
                }
                case '\f': {
                    length = 0;
                }
            }
            ++n2;
        }
        if (this.wasTabIndentation && this.wasSpaceIndentation && !this.wasIndentationMixedWithSpacesAndTabs) {
            this.wasIndentationMixedWithSpacesAndTabs = true;
            return -1;
        }
        return length;
    }

    private void reportLexerError(String errMsg) {
        this.getErrorListenerDispatch().syntaxError((Recognizer)this, (Object)this.curToken, this.curToken.getLine(), this.curToken.getCharPositionInLine(), " LEXER" + " ERROR: " + errMsg, null);
    }

    private void reportError(String errMsg) {
        this.reportLexerError(errMsg);
        this.createAndAddPendingToken(97, 0, " ERROR: " + errMsg, this.ffgToken);
    }

    public void reset() {
        this.init();
        super.reset();
    }
}

