/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.PythonInterpreterCreator;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.IPythonVirtualEnvironmentValidator;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreter;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;

final class PythonVirtualEnvironmentValidator
implements IPythonVirtualEnvironmentValidator {
    private TFile m_interpreterFile;

    public IPathValidator.PathType getType() {
        return IPathValidator.PathType.DIRECTORY;
    }

    @Override
    public TFile getInterpreterFile() {
        return this.m_interpreterFile;
    }

    public ValidationResult isValid(TFile currentInput, TFile newInput) {
        ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
        this.m_interpreterFile = null;
        if (newInput == null || newInput.getPath().isEmpty()) {
            return result;
        }
        if (!newInput.isDirectory()) {
            result.addError("Specified path '" + newInput.getNormalizedAbsolutePath() + "' is not a directory.");
            return result;
        }
        TFile pyvenvCfg = new TFile((File)newInput, "pyvenv.cfg");
        if (!pyvenvCfg.canRead()) {
            result.addError("Specified directory '" + newInput.getNormalizedAbsolutePath() + "' does not contain config file 'pyvenv.cfg'.");
            return result;
        }
        TFile interpreterFile = null;
        String ext = Platform.isWindows() ? ".exe" : "";
        TFile binDir = new TFile((File)newInput, "bin");
        if (binDir.isDirectory() && !(interpreterFile = new TFile((File)binDir, "python" + ext)).canExecute()) {
            interpreterFile = null;
        }
        if (interpreterFile == null && !(interpreterFile = new TFile((File)(binDir = new TFile((File)newInput, "Scripts")), "python" + ext)).canExecute()) {
            interpreterFile = null;
        }
        if (interpreterFile == null) {
            result.addError("Selected virtual environment does not contain a Python interpreter");
            return result;
        }
        PythonInterpreterCreator creator = new PythonInterpreterCreator();
        OperationResultWithOutcome<PythonInterpreter> creationResult = creator.create(null, interpreterFile.getNormalizedAbsolutePath());
        if (creationResult.isFailure()) {
            result.addError("Not a valid interpreter path");
        } else if (((PythonInterpreter)((Object)creationResult.getOutcome())).getMajorVersion() < 3) {
            result.addError("Interpreter must support Python 3 or higher");
        } else {
            this.m_interpreterFile = interpreterFile;
        }
        return result;
    }
}

