/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.DynamicSystemRequest;
import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.SonargraphBuildException;
import com.hello2morrow.sonargraph.build.api.StatusCode;
import com.hello2morrow.sonargraph.build.client.BuildInteraction;
import com.hello2morrow.sonargraph.build.client.ILogger;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildClient;

public class GenerateSystemInteraction
extends BuildInteraction {
    private final DynamicSystemRequest m_dynamicSystemRequest;

    public GenerateSystemInteraction(ISonargraphBuildClient client, DynamicSystemRequest dynamicSystemRequest) {
        super(client);
        assert (dynamicSystemRequest != null) : "Parameter 'dynamicSystemRequest' of method 'GenerateSystemInteraction' must not be null";
        this.m_dynamicSystemRequest = dynamicSystemRequest;
    }

    @Override
    public boolean needsLicense() {
        return false;
    }

    @Override
    public ServiceResponse validateInput(ILogger logger) {
        assert (logger != null) : "Parameter 'logger' of method 'validateInput' must not be null";
        StringBuilder errorMsg = new StringBuilder();
        this.validateDynamicSystemRequest(errorMsg, this.m_dynamicSystemRequest);
        if (errorMsg.length() > 0) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, errorMsg.toString());
        }
        return new ServiceResponse(StatusCode.OK, "All input parameters are valid.");
    }

    @Override
    public String getDescription() {
        return "Generate a Sonargraph System from a directory structure";
    }

    @Override
    public ServiceResponse execute(ISonargraphBuild sonargraphBuild, ILogger logger) throws SonargraphBuildException {
        return this.generateDynamicSystem(this.m_dynamicSystemRequest, sonargraphBuild, logger);
    }
}

