/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IResult;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationResult
implements IResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationResult.class);
    private final List<Message> m_messages = new ArrayList<Message>();
    private final String m_description;
    private Boolean m_isSuccess = null;

    public OperationResult(String description) {
        assert (description != null) : "'description' must not be null";
        assert (description.length() > 0) : "'description' must not be empty";
        this.m_description = description;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final List<Message> getMessages() {
        return Collections.unmodifiableList(this.m_messages);
    }

    public final boolean isEmpty() {
        return this.m_messages.isEmpty();
    }

    private boolean contains(Status status) {
        assert (status != null) : "Parameter 'status' of method 'containsMessageWithStatus' must not be null";
        for (Message nextMessage : this.m_messages) {
            if (nextMessage.getStatus() != status) continue;
            return true;
        }
        return false;
    }

    public final boolean containsInfo() {
        return this.contains(Status.INFO);
    }

    public final boolean containsWarning() {
        return this.contains(Status.WARNING);
    }

    public final boolean containsError() {
        return this.contains(Status.ERROR);
    }

    public final void setIsSuccess(boolean isSuccess) {
        this.m_isSuccess = isSuccess;
    }

    @Override
    public final boolean isSuccess() {
        if (this.m_isSuccess == null) {
            return !this.containsError();
        }
        return this.m_isSuccess;
    }

    @Override
    public final boolean isFailure() {
        return !this.isSuccess();
    }

    private List<IMessageCause> getMessageCauses(Status status) {
        assert (status != null) : "Parameter 'status' of method 'getCauses' must not be null";
        ArrayList<IMessageCause> causes = new ArrayList<IMessageCause>();
        for (Message nextMessage : this.m_messages) {
            if (nextMessage.getStatus() != status) continue;
            causes.add(nextMessage.getCause());
        }
        return causes;
    }

    public final List<IMessageCause> getInfoCauses() {
        return this.getMessageCauses(Status.INFO);
    }

    public final List<IMessageCause> getWarningCauses() {
        return this.getMessageCauses(Status.WARNING);
    }

    public final List<IMessageCause> getErrorCauses() {
        return this.getMessageCauses(Status.ERROR);
    }

    private List<String> getMessages(Status status) {
        assert (status != null) : "Parameter 'status' of method 'getMessages' must not be null";
        ArrayList<String> messages = new ArrayList<String>();
        for (Message nextMessage : this.m_messages) {
            if (nextMessage.getStatus() != status) continue;
            messages.add(nextMessage.getMessage());
        }
        return messages;
    }

    public final List<String> getInfoMessages() {
        return this.getMessages(Status.INFO);
    }

    public final List<String> getWarningMessages() {
        return this.getMessages(Status.WARNING);
    }

    public final List<String> getErrorMessages() {
        return this.getMessages(Status.ERROR);
    }

    public final void addInfo(IMessageCause cause) {
        assert (cause != null) : "Parameter 'cause' of method 'addInfo' must not be null";
        this.m_messages.add(new Message(Status.INFO, cause, cause.getPresentationName()));
    }

    public final String addInfo(IMessageCause cause, String detail) {
        assert (cause != null) : "Parameter 'cause' of method 'addInfo' must not be null";
        assert (detail != null && detail.length() > 0) : "Parameter 'detail' of method 'addInfo' must not be empty";
        Message message = new Message(Status.INFO, cause, cause.getPresentationName() + ". " + detail);
        this.m_messages.add(message);
        return message.getMessage();
    }

    public final String addWarning(IMessageCause cause, String detail, Object ... args) {
        assert (cause != null) : "Parameter 'cause' of method 'addWarning' must not be null";
        assert (detail != null && detail.length() > 0) : "Parameter 'detail' of method 'addWarning' must not be empty";
        Message message = new Message(Status.WARNING, cause, this.createDetailMessage(cause, detail, args));
        this.m_messages.add(message);
        LOGGER.warn(message.toString());
        return message.getMessage();
    }

    public final void addWarning(IMessageCause cause) {
        assert (cause != null) : "Parameter 'cause' of method 'addWarning' must not be null";
        Message message = new Message(Status.WARNING, cause, cause.getPresentationName() + ".");
        this.m_messages.add(message);
        LOGGER.warn(message.toString());
    }

    private String getThrowableInfo(Throwable throwable) {
        assert (throwable != null) : "Parameter 'throwable' of method 'getThrowableInfo' must not be null";
        StringBuilder builder = new StringBuilder();
        builder.append("'").append(throwable.getClass().getName()).append("'");
        String msg = throwable.getLocalizedMessage();
        if (msg != null && !msg.isEmpty()) {
            builder.append(" ").append(msg);
        }
        builder.append("\n").append("Complete stack trace has been recorded in the log file.");
        return builder.toString();
    }

    public final void addWarning(IMessageCause cause, Throwable throwable) {
        assert (cause != null) : "Parameter 'cause' of method 'addWarning' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'addWarning' must not be null";
        Message message = new Message(Status.WARNING, cause, cause.getPresentationName() + ".\n" + this.getThrowableInfo(throwable));
        this.m_messages.add(message);
        LOGGER.warn(message.toString() + StringUtility.LINE_SEPARATOR + "Stacktrace: " + ExceptionUtility.collectAll(new Throwable(throwable)));
    }

    public final void addError(IMessageCause cause) {
        assert (cause != null) : "Parameter 'cause' of method 'addError' must not be null";
        Message message = new Message(Status.ERROR, cause, cause.getPresentationName() + ".");
        this.m_messages.add(message);
        LOGGER.error(message.toString() + StringUtility.LINE_SEPARATOR + "Stacktrace: " + ExceptionUtility.collectAll(new Throwable()));
        this.m_isSuccess = null;
    }

    public final void addError(IMessageCause cause, String detail, Object ... args) {
        assert (cause != null) : "Parameter 'cause' of method 'addError' must not be null";
        assert (detail != null && detail.length() > 0) : "Parameter 'detail' of method 'addError' must not be empty";
        Message message = new Message(Status.ERROR, cause, this.createDetailMessage(cause, detail, args));
        this.m_messages.add(message);
        LOGGER.error(message.toString() + StringUtility.LINE_SEPARATOR + "Stacktrace: " + ExceptionUtility.collectAll(new Throwable()));
        this.m_isSuccess = null;
    }

    private String createDetailMessage(IMessageCause cause, String detail, Object ... args) {
        if (args == null || args.length == 0) {
            return cause.getPresentationName() + ". " + detail;
        }
        return cause.getPresentationName() + ". " + String.format(detail, args);
    }

    public final void addError(IMessageCause cause, Throwable throwable) {
        assert (cause != null) : "Parameter 'cause' of method 'addError' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'addError' must not be null";
        Message message = new Message(Status.ERROR, cause, cause.getPresentationName() + ".\n" + this.getThrowableInfo(throwable));
        this.m_messages.add(message);
        LOGGER.error(message.toString() + StringUtility.LINE_SEPARATOR + "Stacktrace: " + ExceptionUtility.collectAll(new Throwable(throwable)));
        this.m_isSuccess = null;
    }

    public final void addWarning(IMessageCause cause, Throwable throwable, String detail, Object ... args) {
        assert (cause != null) : "Parameter 'cause' of method 'addWarning' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'addWarning' must not be null";
        assert (detail != null && detail.length() > 0) : "Parameter 'detail' of method 'addWarning' must not be empty";
        Message message = new Message(Status.WARNING, cause, this.createDetailMessage(cause, detail, args) + ".\n" + this.getThrowableInfo(throwable));
        this.m_messages.add(message);
        LOGGER.warn(message.toString() + StringUtility.LINE_SEPARATOR + "Stacktrace: " + ExceptionUtility.collectAll(new Throwable(throwable)));
    }

    public final void addError(IMessageCause cause, Throwable throwable, String detail, Object ... args) {
        assert (cause != null) : "Parameter 'cause' of method 'addError' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'addError' must not be null";
        assert (detail != null && detail.length() > 0) : "Parameter 'detail' of method 'addError' must not be empty";
        Message message = new Message(Status.ERROR, cause, this.createDetailMessage(cause, detail, args) + ".\n" + this.getThrowableInfo(throwable));
        this.m_messages.add(message);
        LOGGER.error(message.toString() + StringUtility.LINE_SEPARATOR + "Stacktrace: " + ExceptionUtility.collectAll(new Throwable(throwable)));
        this.m_isSuccess = null;
    }

    public final void addMessagesFrom(OperationResult result) {
        this.addMessagesFromAffectingCurrentOutcome(result);
    }

    public final void addMessagesFromAndSetOutcome(OperationResult result) {
        this.addMessagesFromAffectingCurrentOutcome(result);
        if (result.m_isSuccess != null) {
            this.m_isSuccess = result.m_isSuccess;
        }
    }

    public final void addMessagesFromMaintainingCurrentOutcome(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'addMessagesFromMaintainingCurrentOutcome' must not be null";
        Boolean isSuccess = this.isSuccess();
        this.m_messages.addAll(result.getMessages());
        this.m_isSuccess = isSuccess;
    }

    public final void addMessagesFromAffectingCurrentOutcome(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'addMessagesFromAffectingCurrentOutcome' must not be null";
        this.m_messages.addAll(result.getMessages());
        if (result.isFailure()) {
            this.m_isSuccess = null;
        }
    }

    public List<String> getMessagesAsStringList() {
        ArrayList<String> result = new ArrayList<String>();
        for (Message next : this.m_messages) {
            result.add(next.toString());
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.isFailure() ? "Failure: " : "Success: ");
        builder.append(this.m_description);
        for (Message next : this.m_messages) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(next.toString());
        }
        return builder.toString();
    }

    public void reset() {
        this.m_messages.clear();
        this.m_isSuccess = null;
    }

    public OperationResult copy() {
        OperationResult copy = new OperationResult(this.m_description);
        copy.addMessagesFrom(this);
        copy.m_isSuccess = this.m_isSuccess;
        return copy;
    }

    public static interface IMessageCause
    extends IStandardEnumeration {
    }

    public static final class Message {
        private final Status m_status;
        private final IMessageCause m_cause;
        private final String m_message;

        public Message(Status status, IMessageCause cause, String message) {
            assert (status != null) : "Parameter 'status' of method 'Message' must not be null";
            assert (cause != null) : "Parameter 'cause' of method 'Message' must not be null";
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'Message' must not be empty";
            this.m_status = status;
            this.m_cause = cause;
            this.m_message = message;
        }

        public Status getStatus() {
            return this.m_status;
        }

        public IMessageCause getCause() {
            return this.m_cause;
        }

        public String getMessage() {
            return this.m_message;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.m_status.getPresentationName());
            builder.append(" - ");
            builder.append(this.m_message);
            return builder.toString();
        }
    }

    public static enum Status implements IStandardEnumeration
    {
        INFO,
        WARNING,
        ERROR;


        @Override
        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName(this.name());
        }

        @Override
        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName(this.name());
        }
    }
}

