/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.event;

import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.IEventForwarder;
import com.hello2morrow.sonargraph.foundation.event.IEventHandler;
import java.util.Collection;

final class EventAdapter<T extends Event> {
    private final Class<T> m_eventClass;

    EventAdapter(Class<T> eventClass) {
        assert (eventClass != null) : "Parameter 'eventClass' of method 'EventAdapter' must not be null";
        this.m_eventClass = eventClass;
    }

    final void forwardToSpecificHandler(final Event event, final Object emitter, final Collection<IEventHandler<?>> handler, final IRegistrantStateProvider provider, IEventForwarder forwarder) {
        assert (event != null) : "Parameter 'event' of method 'forwardToSpecificHandler' must not be null";
        assert (emitter != null) : "Parameter 'emitter' of method 'forwardToSpecificHandler' must not be null";
        assert (handler != null && !handler.isEmpty()) : "Parameter 'handler' of method 'forwardToSpecificHandler' must not be empty";
        assert (provider != null) : "Parameter 'provider' of method 'forwardToSpecificHandler' must not be null";
        assert (forwarder != null) : "Parameter 'forwarder' of method 'forwardToSpecificHandler' must not be null";
        forwarder.runEventDispatch(event.getClass(), new Runnable(){

            @Override
            public void run() {
                for (IEventHandler nextHandler : handler) {
                    Object nextRegistrant = nextHandler.getRegistrant();
                    if (nextRegistrant == emitter || provider.isSleeping(nextRegistrant)) continue;
                    nextHandler.handleEvent(event);
                }
            }

            public String toString() {
                return event.toString();
            }
        });
    }

    public String toString() {
        return "Event adapter [" + this.m_eventClass.getName() + "]";
    }

    static interface IRegistrantStateProvider {
        public boolean isSleeping(Object var1);
    }
}

