/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.javapg.runtime.parser;

import com.hello2morrow.javapg.runtime.lexer.base.ILexer;
import com.hello2morrow.javapg.runtime.messaging.MessageBuilder;
import com.hello2morrow.javapg.runtime.messaging.MessagePrinter;
import com.hello2morrow.javapg.runtime.messaging.MessageReporter;
import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.tree.InnerNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public abstract class AbstractParser {
    protected MessageReporter m_Rep;
    protected MessageBuilder m_Msg;
    protected ILexer m_Lexer;

    public AbstractParser(Class<? extends ILexer> lexerClass, MessageReporter rep) {
        if (rep == null) {
            rep = this.getDefaultReporter();
        }
        this.m_Rep = rep;
        this.m_Msg = new MessageBuilder("com.hello2morrow.javapg.runtime.Messages", rep);
        try {
            this.m_Lexer = lexerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create lexer instance", e);
        }
    }

    public ILexer getLexer() {
        return this.m_Lexer;
    }

    protected MessageReporter getDefaultReporter() {
        return new MessagePrinter(System.err);
    }

    public MessageBuilder getMessageBuilder() {
        return this.m_Msg;
    }

    public MessageReporter getMessageReporter() {
        return this.m_Rep;
    }

    protected void init() {
    }

    public InnerNode parse(String fileName, String charSet) throws IOException {
        this.init();
        try {
            this.m_Lexer.assignInput(fileName, charSet);
        }
        catch (FileNotFoundException e) {
            this.m_Msg.writeSafe(2, null, "FileNotFound", fileName);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            this.m_Msg.writeSafe(2, null, "EncodingNotFound", charSet);
            return null;
        }
        return this.parse();
    }

    public InnerNode parse(InputStream inp, String fileName) throws IOException {
        this.init();
        this.m_Lexer.assignInput(inp, fileName);
        return this.parse();
    }

    public InnerNode parse(String fileName) throws IOException {
        this.init();
        try {
            this.m_Lexer.assignInput(fileName);
        }
        catch (FileNotFoundException e) {
            this.m_Msg.writeSafe(2, null, "FileNotFound", fileName);
            throw e;
        }
        return this.parse();
    }

    public InnerNode parse(Reader input, String name) throws IOException {
        this.init();
        this.m_Lexer.assignInput(input, name);
        return this.parse();
    }

    public InnerNode parse() throws IOException {
        InnerNode result;
        try {
            this.m_Lexer.init();
            result = this.doParse();
        }
        catch (IOException e) {
            this.m_Msg.writeSafe(2, this.m_Lexer.getPosition(), "ReadError", e.getMessage());
            throw e;
        }
        return result;
    }

    public Position getPosition() {
        return this.m_Lexer.getPosition();
    }

    protected abstract InnerNode doParse() throws IOException;
}

