/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile;

import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyToFieldProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.SyntheticsHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.IClassFileParserContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

final class AnnotationVisitorImpl
extends AnnotationVisitor {
    private final IClassFileParserContext m_classFileParserContext;
    private JavaDependencyContext m_dependencyContext;
    private int m_lineNumber;

    AnnotationVisitorImpl(IClassFileParserContext classFileParserContext, JavaDependencyContext dependencyContext) {
        super(589824);
        assert (classFileParserContext != null) : "Parameter 'context' of method 'AnnotationVisitorImpl' must not be null";
        this.m_classFileParserContext = classFileParserContext;
        this.m_dependencyContext = dependencyContext;
    }

    void setDependencyContext(JavaDependencyContext dependencyContext, int lineNumber) {
        this.m_dependencyContext = dependencyContext;
        this.m_lineNumber = lineNumber;
    }

    public void visitEnum(String name, String desc, String value) {
        assert (desc != null) : "Parameter 'desc' of method 'visitEnum' must not be null";
        assert (value != null) : "Parameter 'value' of method 'visitEnum' must not be null";
        if (SyntheticsHelper.isFieldSynthetic(value)) {
            return;
        }
        JavaDependencyType dependencyType = JavaDependencyType.ANNOTATION_ENUMERATION_VALUE;
        String convertedOwnerFqName = this.m_classFileParserContext.convertToFqName(Type.getType((String)desc).getClassName());
        JavaIgnoreAccess ignoreAccess = this.m_classFileParserContext.getGlobalModel().getIgnoreAccess();
        if (ignoreAccess.ignoreTypeAccess(this.m_dependencyContext, dependencyType, convertedOwnerFqName) || ignoreAccess.ignoreFieldAccess(this.m_dependencyContext, dependencyType, convertedOwnerFqName, value)) {
            return;
        }
        DependencyToFieldProcessor dependencyProcessor = new DependencyToFieldProcessor(this.m_classFileParserContext.getCurrentJavaElement(), this.m_lineNumber, this.m_dependencyContext, dependencyType, this.m_classFileParserContext.getCurrentModule(), convertedOwnerFqName, value);
        this.m_classFileParserContext.getGlobalModel().addDependencyProcessor(dependencyProcessor);
    }

    public void visit(String name, Object value) {
        if (value instanceof Type) {
            this.m_classFileParserContext.addDependencyToType((Type)value, -1, this.m_dependencyContext, JavaDependencyType.ANNOTATION_VALUE);
        }
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.m_classFileParserContext.addDependencyToType(Type.getType((String)desc), -1, this.m_dependencyContext, JavaDependencyType.NESTED_ANNOTATION_VALUE);
        return this;
    }

    public AnnotationVisitor visitArray(String name) {
        return this;
    }

    public void visitEnd() {
    }
}

