/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.ArchitectureExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.LogicalNamespaceDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAndLevelAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetComputer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetInfo;
import com.hello2morrow.sonargraph.core.foundation.common.graph.ICycleAndLevelAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IFeedbackArcSetAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationUtility;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaPackageFragment;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.ISpringModulithProvider;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public final class SpringModulithExtension
extends Extension
implements ISpringModulithProvider {
    private final SoftwareSystem m_softwareSystem;
    private final IFinishModelProcessor m_finishModelProcessor;
    private static final String INDENT = "    ";

    public SpringModulithExtension(SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'SpringModulithExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'SpringModulithExtension' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_finishModelProcessor = finishModelProcessor;
    }

    private JavaPackageFragment findPackageFragment(String name) {
        PackageFragmentFinder finder = new PackageFragmentFinder(name);
        ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).accept((NamedElement.INamedElementVisitor)finder);
        return finder.m_result;
    }

    private JavaType findJavaType(String name) {
        JavaTypeFinder finder = new JavaTypeFinder(name);
        ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).accept((NamedElement.INamedElementVisitor)finder);
        return finder.m_result;
    }

    private void setModuleAttributes(OperationResult result, Map<String, ModulithModule> moduleMap, ModulithModule module, JSONObject data) {
        JSONArray allowedDependencies;
        String basePackageName = (String)data.get((Object)"basePackage");
        JavaPackageFragment packageFragment = this.findPackageFragment(basePackageName);
        if (packageFragment == null) {
            result.addError((OperationResult.IMessageCause)ModulithMessageCause.UNKNOWN_BASE_PACKAGE, String.format("Base package '%s' of module '%s' cannot be found", basePackageName, module.getName()), new Object[0]);
            return;
        }
        module.setDisplayName((String)data.get((Object)"displayName"));
        module.setRoot(packageFragment);
        Boolean isShared = (Boolean)data.get((Object)"shared");
        if (isShared == null) {
            result.addWarning((OperationResult.IMessageCause)ModulithMessageCause.OLD_MODULITH_VERSION, "Please update to Spring-Modulith 1.4.2 or higher", new Object[0]);
            isShared = false;
        }
        module.setShared(isShared);
        String moduleType = (String)data.get((Object)"type");
        module.setOpen("open".equalsIgnoreCase(moduleType));
        JSONArray nestedModules = (JSONArray)data.get((Object)"nested");
        if (nestedModules != null) {
            for (Object nested : nestedModules) {
                String name = (String)nested;
                ModulithModule nestedModule = moduleMap.get(name);
                if (nestedModule == null) {
                    result.addError((OperationResult.IMessageCause)ModulithMessageCause.UNKNOWN_MODULE, String.format("Nested module '%s' of module '%s' cannot be found", name, module.getName()), new Object[0]);
                    return;
                }
                module.addChild(nestedModule);
            }
        }
        if ((allowedDependencies = (JSONArray)data.get((Object)"allowedDependencies")) != null) {
            for (Object obj : allowedDependencies) {
                String depName = (String)obj;
                module.addAllowedDependency(depName);
            }
        }
        JSONObject namedInterfaces = (JSONObject)data.get((Object)"namedInterfaces");
        for (Object entryObj : namedInterfaces.entrySet()) {
            Map.Entry entry = (Map.Entry)entryObj;
            String name = (String)entry.getKey();
            JSONArray typeList = (JSONArray)entry.getValue();
            boolean addTypes = true;
            if (name.equals("<<UNNAMED>>")) {
                name = "default";
                addTypes = false;
            }
            NamedInterface namedInterface = new NamedInterface(module, name);
            if (addTypes) {
                for (Object obj : typeList) {
                    String typeName = (String)obj;
                    if (typeName.contains("$")) continue;
                    JavaType type = this.findJavaType(typeName);
                    if (type == null) {
                        result.addError((OperationResult.IMessageCause)ModulithMessageCause.UNKNOWN_TYPE, "Unknown type " + typeName + " in " + module.getName() + "::" + namedInterface.getName(), new Object[0]);
                        return;
                    }
                    namedInterface.addType(type);
                }
            }
            module.addNamedInterface(namedInterface);
        }
    }

    private void processCycleGroup(IWorkerContext workerContext, List<ModulithModule> cycleGroup, CycleAndLevelAdapter adapter) {
        List<LogicalNamespace> rootPackages = cycleGroup.stream().map(m -> m.getRoot().getModuleNamespace()).toList();
        LogicalNamespaceDependencyEndpointCollector collector = new LogicalNamespaceDependencyEndpointCollector(true, new LogicalNamespace[0]);
        collector.addLogicalNamespaces(rootPackages);
        ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, rootPackages, (DependencyEndpointCollector)collector, RepresentationUtility.PE, RepresentationUtility.PD);
        THashMap allowedDependencies = new THashMap();
        for (ModulithModule mod : cycleGroup) {
            allowedDependencies.put(mod.getRoot().getModuleNamespace(), mod.getExplicitelyAndImplicitelyConnectedModules().stream().map(m -> m.getRoot().getModuleNamespace()).toList());
        }
        FASAdapter fasAdapter = new FASAdapter(nodeAdapterSet, (Map<LogicalNamespace, List<LogicalNamespace>>)allowedDependencies, adapter);
        FeedbackArcSetComputer.compute((IWorkerContext)DefaultWorkerContext.INSTANCE, (IFeedbackArcSetAdapter)fasAdapter);
        adapter.changeMode(true);
        CycleAndLevelAnalyzer.process((ICycleAndLevelAnalyzerAdapter)adapter, (Collection)nodeAdapterSet.getNodes(), (boolean)true, (IWorkerContext)workerContext);
    }

    private void analyzeSubmoduleRelationships(ModulithModule module) {
        LogicalNamespace rootNs = module.getRoot().getModuleNamespace();
        List<LogicalNamespace> children = module.getChildren().stream().map(m -> m.getRoot().getModuleNamespace()).toList();
        ArrayList<LogicalNamespace> parentAndChildren = new ArrayList<LogicalNamespace>();
        LogicalNamespace[] childrenArray = new LogicalNamespace[children.size()];
        children.toArray(childrenArray);
        parentAndChildren.add(rootNs);
        parentAndChildren.addAll(children);
        LogicalNamespaceDependencyEndpointCollector collector = new LogicalNamespaceDependencyEndpointCollector(true, childrenArray);
        collector.addLogicalNamespaces(parentAndChildren);
        ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet((IWorkerContext)DefaultWorkerContext.INSTANCE, parentAndChildren, (DependencyEndpointCollector)collector, RepresentationUtility.PE, RepresentationUtility.PD);
        ParserDependencyNodeAdapter rootNode = nodeAdapterSet.getNodes().stream().filter(na -> na.getUnderlyingObject() == rootNs).findFirst().orElse(null);
        assert (rootNode != null);
        List<ParserDependencyNodeAdapter> otherNodes = nodeAdapterSet.getNodes().stream().filter(na -> na.getUnderlyingObject() != rootNs).toList();
        assert (otherNodes.size() == children.size());
        int inWeight = 0;
        int outWeight = 0;
        for (ParserDependencyEdgeAdapter incoming : rootNode.getIncomingEdges()) {
            if (!otherNodes.contains(incoming.getFrom())) continue;
            inWeight += incoming.getWeight();
        }
        for (ParserDependencyEdgeAdapter outgoing : rootNode.getOutgoingEdges()) {
            if (!otherNodes.contains(outgoing.getTo())) continue;
            outWeight += outgoing.getWeight();
        }
        if (inWeight > outWeight) {
            module.setCreateSharedModule(true);
        }
    }

    private void analyzeSubmoduleRelationshipsRecursively(List<ModulithModule> modules) {
        for (ModulithModule mod : modules) {
            if (!mod.hasChildren()) continue;
            this.analyzeSubmoduleRelationships(mod);
            this.analyzeSubmoduleRelationshipsRecursively(mod.getChildren());
        }
    }

    private void levelizeModules(IWorkerContext workerContext, List<ModulithModule> modules) {
        LinkedHashMap<LogicalNamespace, ModulithModule> moduleMap = new LinkedHashMap<LogicalNamespace, ModulithModule>();
        modules.forEach(m -> {
            ModulithModule modulithModule = moduleMap.put(m.getRoot().getModuleNamespace(), (ModulithModule)m);
        });
        List<LogicalNamespace> rootPackages = modules.stream().map(m -> m.getRoot().getModuleNamespace()).toList();
        LogicalNamespaceDependencyEndpointCollector collector = new LogicalNamespaceDependencyEndpointCollector(true, new LogicalNamespace[0]);
        collector.addLogicalNamespaces(rootPackages);
        ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet(workerContext, rootPackages, (DependencyEndpointCollector)collector, RepresentationUtility.PE, RepresentationUtility.PD);
        CycleAndLevelAdapter adapter = new CycleAndLevelAdapter(moduleMap);
        CycleAndLevelAnalyzer.process((ICycleAndLevelAnalyzerAdapter)adapter, (Collection)nodeAdapterSet.getNodes(), (boolean)true, (IWorkerContext)workerContext);
        if (adapter.hasCycles()) {
            for (List<ModulithModule> cycleGroup : adapter.getCycleGroups()) {
                this.processCycleGroup(workerContext, cycleGroup, adapter);
            }
            adapter.reset();
            CycleAndLevelAnalyzer.process((ICycleAndLevelAnalyzerAdapter)adapter, (Collection)nodeAdapterSet.getNodes(), (boolean)true, (IWorkerContext)workerContext);
            assert (!adapter.hasCycles());
        }
        modules.sort((m1, m2) -> adapter.getModuleLevel((ModulithModule)m2) - adapter.getModuleLevel((ModulithModule)m1));
    }

    private void levelizeModulesRecursively(IWorkerContext workerContext, List<ModulithModule> modules) {
        for (ModulithModule module : modules) {
            if (module.getChildren().size() <= 0) continue;
            this.levelizeModulesRecursively(workerContext, module.getChildren());
        }
        if (modules.size() > 1) {
            this.levelizeModules(workerContext, modules);
        }
    }

    private void processJsonInput(IWorkerContext workerContext, DirectoryPath parentDir, TFile jsonInputFile, OperationResultWithOutcome<ArchitectureFile> result, String arcFileName, JSONObject modulesInJSON, TFile targetFile, boolean addToArchitectureCheck) {
        LinkedHashMap<String, ModulithModule> moduleMap = new LinkedHashMap<String, ModulithModule>();
        for (Object key : modulesInJSON.keySet()) {
            String name = (String)key;
            ModulithModule module = new ModulithModule(name);
            moduleMap.put(name, module);
        }
        for (ModulithModule module : moduleMap.values()) {
            this.setModuleAttributes((OperationResult)result, (Map<String, ModulithModule>)moduleMap, module, (JSONObject)modulesInJSON.get((Object)module.getName()));
            if (!result.containsError()) continue;
            return;
        }
        ArrayList<ModulithModule> topLevelModules = new ArrayList<ModulithModule>(moduleMap.values().stream().filter(m -> m.isTopLevel()).toList());
        List<ModulithModule> sharedModules = moduleMap.values().stream().filter(m -> m.isShared()).toList();
        for (ModulithModule module : topLevelModules) {
            if (!module.hasAllowedDependencies()) continue;
            this.linkAllowedDependencoes((OperationResult)result, (Map<String, ModulithModule>)moduleMap, module, sharedModules);
        }
        if (result.isFailure()) {
            return;
        }
        this.levelizeModulesRecursively((IWorkerContext)DefaultWorkerContext.INSTANCE, topLevelModules);
        this.analyzeSubmoduleRelationshipsRecursively(topLevelModules);
        IAnalyzerExecutionController analyzerExtension = (IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class);
        Set allToRestart = analyzerExtension.cancelAndResetAnalyzerGroups((Set)ArchitectureExtension.GROUPS, ResetMode.ALL);
        if (!targetFile.exists() && !targetFile.getParentFile().isDirectory()) {
            targetFile.getParentFile().mkdir();
        }
        try {
            Throwable throwable = null;
            Object var15_17 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter((File)targetFile));){
                this.writeHeaderComment(writer, jsonInputFile);
                for (ModulithModule mod : topLevelModules) {
                    this.writeModule(writer, mod, 0);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, e.getMessage(), new Object[0]);
            analyzerExtension.runAnalyzerGroups((Collection)allToRestart);
            return;
        }
        ArchitectureExtension architectureExtension = (ArchitectureExtension)this.m_softwareSystem.getExtension(ArchitectureExtension.class);
        ArchitectureFile architectureFile = architectureExtension.architectureFileGenerated(workerContext, parentDir, targetFile, addToArchitectureCheck, result);
        if (architectureFile != null) {
            result.setOutcome((Object)architectureFile);
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, EnumSet.of(Modification.ARCHITECTURE_MODIFIED), result);
        analyzerExtension.runAnalyzerGroups((Collection)allToRestart);
    }

    private void linkAllowedDependencoes(OperationResult result, Map<String, ModulithModule> moduleMap, ModulithModule module, List<ModulithModule> sharedModules) {
        for (String dep : module.getAllowedDependencies()) {
            String[] parts;
            ModulithModule mod;
            int index = dep.indexOf("::");
            String namedInterfaceName = "default";
            if (index > 0) {
                namedInterfaceName = dep.substring(index + 2);
                dep = dep.substring(0, index);
            }
            if ((mod = moduleMap.get((parts = dep.split("\\."))[0])) == null) {
                result.addError((OperationResult.IMessageCause)ModulithMessageCause.UNKNOWN_MODULE, "Cannot resolve allowed dependency from " + module.getName() + " to " + parts[0], new Object[0]);
                return;
            }
            int i = 1;
            while (i < parts.length) {
                if ((mod = mod.getChildByName(parts[i])) == null) {
                    result.addError((OperationResult.IMessageCause)ModulithMessageCause.UNKNOWN_MODULE, "Cannot resolve allowed dependency from " + module.getName() + " to " + parts[0], new Object[0]);
                    return;
                }
                ++i;
            }
            NamedInterface ni = mod.getNamedInterfaceByName(namedInterfaceName);
            if (ni == null) {
                result.addError((OperationResult.IMessageCause)ModulithMessageCause.UNKNOWN_NAMED_INTERFACE, "Cannot resolve named interface " + namedInterfaceName, new Object[0]);
                return;
            }
            module.addAllowedConnection(ni);
        }
        if (!module.isShared() && !sharedModules.isEmpty()) {
            for (ModulithModule sm : sharedModules) {
                module.addImplicitConnection(sm.getNamedInterfaceByName("default"));
            }
        }
    }

    private void writeHeaderComment(Writer writer, TFile jsonInputFile) throws IOException {
        writer.write("// Generated from " + jsonInputFile.getNormalizedAbsolutePath() + "\n");
        writer.write("//\n");
        writer.write("// " + OffsetDateTime.now().toString() + "\n");
        writer.write("//\n");
        writer.write("// Regenerate if:\n");
        writer.write("// - number of modules or module structure changes\n");
        writer.write("// - changes in named interfaces\n");
        writer.write("// - change of module dependency structure\n");
    }

    private String indent(int level) {
        StringBuilder sb = new StringBuilder();
        while (level > 0) {
            sb.append(INDENT);
            --level;
        }
        return sb.toString();
    }

    private void writeModule(Writer writer, ModulithModule module, int indent) throws IOException {
        String prefix = this.indent(indent);
        writer.write("\n");
        writer.write(prefix);
        if (indent > 0) {
            writer.write("hidden ");
        }
        if (module.isShared()) {
            writer.write("public ");
        } else if (!module.hasAllowedDependencies()) {
            writer.write("relaxed ");
        }
        writer.write("artifact ");
        writer.write(module.getDisplayName());
        writer.write("\n");
        writer.write(prefix);
        writer.write("{\n");
        writer.write(prefix);
        writer.write(INDENT);
        String filterName = module.getRoot().getArchitectureFilterName();
        String packageFilter = filterName.substring(0, filterName.length() - 1);
        writer.write("include \"");
        writer.write(filterName);
        writer.write("\"\n");
        for (ModulithModule child : module.getChildren()) {
            this.writeModule(writer, child, indent + 1);
        }
        List<JavaType> excluded = module.getTypesExcludedFromDefaultInterface();
        if (module.isCreateSharedModule()) {
            writer.write("\n");
            writer.write(prefix);
            writer.write(INDENT);
            writer.write("public artifact Shared\n");
            writer.write(prefix);
            writer.write(INDENT);
            writer.write("{\n");
            writer.write(prefix);
            writer.write(INDENT);
            writer.write(INDENT);
            writer.write("include \"**\"\n");
            writer.write("\n");
            writer.write(prefix);
            writer.write(INDENT);
            writer.write(INDENT);
            writer.write("interface default\n");
            writer.write(prefix);
            writer.write(INDENT);
            writer.write(INDENT);
            writer.write("{\n");
            writer.write(prefix);
            writer.write(INDENT);
            writer.write(INDENT);
            writer.write(INDENT);
            if (module.isOpen()) {
                writer.write("include \"**\"\n");
            } else {
                writer.write("include \"");
                writer.write(packageFilter);
                writer.write("\"\n");
            }
            if (excluded.size() > 0) {
                writer.write("\n");
                for (JavaType type : excluded) {
                    writer.write(prefix);
                    writer.write(INDENT);
                    writer.write(INDENT);
                    writer.write(INDENT);
                    writer.write("exclude \"");
                    writer.write(((IAssignableToArtifact)type.getParent(IAssignableToArtifact.class, new Class[0])).getArchitectureFilterName());
                    writer.write("\"\n");
                }
            }
            writer.write(prefix);
            writer.write(INDENT);
            writer.write(INDENT);
            writer.write("}\n");
            if (module.getNamedInterfaces().size() > 1) {
                for (NamedInterface ni : module.getNamedInterfaces()) {
                    if (ni.getName().equals("default")) continue;
                    writer.write("\n");
                    writer.write(prefix);
                    writer.write(INDENT);
                    writer.write(INDENT);
                    writer.write("interface ");
                    writer.write(ni.getName());
                    writer.write("\n");
                    writer.write(prefix);
                    writer.write(INDENT);
                    writer.write(INDENT);
                    writer.write("{\n");
                    for (JavaType type : ni.getTypes()) {
                        writer.write(prefix);
                        writer.write(INDENT);
                        writer.write(INDENT);
                        writer.write(INDENT);
                        writer.write("include \"");
                        writer.write(((IAssignableToArtifact)type.getParent(IAssignableToArtifact.class, new Class[0])).getArchitectureFilterName());
                        writer.write("\"\n");
                    }
                    writer.write(prefix);
                    writer.write(INDENT);
                    writer.write(INDENT);
                    writer.write("}\n");
                }
            }
            writer.write(prefix);
            writer.write(INDENT);
            writer.write("}\n");
        }
        for (NamedInterface namedInterface : module.getNamedInterfaces()) {
            writer.write("\n");
            writer.write(prefix);
            writer.write(INDENT);
            writer.write("interface ");
            writer.write(namedInterface.getName());
            writer.write("\n");
            writer.write(prefix);
            writer.write(INDENT);
            writer.write("{\n");
            if (namedInterface.getName().equals("default")) {
                writer.write(prefix);
                writer.write(INDENT);
                writer.write(INDENT);
                if (module.isCreateSharedModule()) {
                    writer.write("export Shared\n");
                } else {
                    writer.write("include \"");
                    if (module.isOpen()) {
                        writer.write("**\"\n");
                    } else {
                        writer.write(packageFilter);
                        writer.write("\"\n");
                    }
                    if (excluded.size() > 0) {
                        writer.write("\n");
                        for (JavaType type : excluded) {
                            writer.write(prefix);
                            writer.write(INDENT);
                            writer.write(INDENT);
                            writer.write("exclude \"");
                            writer.write(((IAssignableToArtifact)type.getParent(IAssignableToArtifact.class, new Class[0])).getArchitectureFilterName());
                            writer.write("\"\n");
                        }
                    }
                }
            } else if (module.isCreateSharedModule()) {
                writer.write(prefix);
                writer.write(INDENT);
                writer.write(INDENT);
                writer.write("export Shared.");
                writer.write(namedInterface.getName());
                writer.write("\n");
            } else {
                for (JavaType type : namedInterface.getTypes()) {
                    writer.write(prefix);
                    writer.write(INDENT);
                    writer.write(INDENT);
                    writer.write("include \"");
                    writer.write(((IAssignableToArtifact)type.getParent(IAssignableToArtifact.class, new Class[0])).getArchitectureFilterName());
                    writer.write("\"\n");
                }
            }
            writer.write(prefix);
            writer.write(INDENT);
            writer.write("}\n");
        }
        if (module.hasAllowedDependencies()) {
            writer.write("\n");
            writer.write(prefix);
            writer.write(INDENT);
            writer.write("connect to ");
            String sep = "";
            for (NamedInterface ni : module.getAllowedConnections()) {
                writer.write(sep);
                writer.write(ni.getFqn());
                sep = ", ";
            }
            writer.write("\n");
        }
        writer.write(prefix);
        writer.write("}\n");
    }

    public OperationResultWithOutcome<ArchitectureFile> generateSpringModulithArchitecture(IWorkerContext workerContext, DirectoryPath parentDir, TFile jsonInputFile, String arcFileName, boolean addLayers, TFile targetFile, boolean addToArchitectureCheck) {
        assert (parentDir != null);
        assert (jsonInputFile != null);
        assert (arcFileName != null && !arcFileName.isBlank());
        OperationResultWithOutcome result = new OperationResultWithOutcome("Generating modulith architecture");
        if (!this.m_softwareSystem.isClearable()) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.SYSTEM_MUST_BE_CLEARABLE, "No software system loaded", new Object[0]);
            return result;
        }
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileReader reader = new FileReader((File)jsonInputFile);){
                JSONParser parser = new JSONParser();
                Object jsonData = parser.parse((Reader)reader);
                if (jsonData instanceof JSONObject) {
                    this.processJsonInput(workerContext, parentDir, jsonInputFile, (OperationResultWithOutcome<ArchitectureFile>)result, arcFileName, (JSONObject)jsonData, targetFile, addToArchitectureCheck);
                } else {
                    result.addError((OperationResult.IMessageCause)ModulithMessageCause.UNEXPECTED_FORMAT, "Expecting JSON object as root object in JSON input file", new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            result.addError((OperationResult.IMessageCause)ModulithMessageCause.EXCEPTION_WHILE_READING_JSON_FILE, "Exception occured: " + e.getMessage(), new Object[0]);
        }
        return result;
    }

    @Override
    public ITextValidator getArchitectureNameValidator() {
        return new Validator();
    }

    private static class CycleAndLevelAdapter
    implements ICycleAndLevelAnalyzerAdapter<ParserDependencyNodeAdapter> {
        private final Map<ModulithModule, Integer> m_levelMap = new THashMap();
        private final Map<ModulithModule, Integer> m_cycleLevelMap = new THashMap();
        private final Map<Integer, List<ModulithModule>> m_cycleGroups = new THashMap();
        private final Set<ModulithModule> m_cyclicNodes = new THashSet();
        private final Map<LogicalNamespace, ModulithModule> m_moduleMap;
        private final Map<ModulithModule, Integer> m_cycleIndexMap = new THashMap();
        private final Map<LogicalNamespace, List<LogicalNamespace>> m_removedEdges = new THashMap();
        private boolean m_isSortingCyclicNodes = false;

        private CycleAndLevelAdapter(Map<LogicalNamespace, ModulithModule> moduleMap) {
            assert (moduleMap != null);
            this.m_moduleMap = moduleMap;
        }

        public Collection<ParserDependencyNodeAdapter> getIncoming(ParserDependencyNodeAdapter node) {
            List<ParserDependencyNodeAdapter> result = node.getIncomingEdges().stream().map(e -> (ParserDependencyNodeAdapter)e.getFrom()).toList();
            if (!this.m_removedEdges.isEmpty()) {
                LogicalNamespace target = (LogicalNamespace)node.getUnderlyingObject();
                ArrayList<ParserDependencyNodeAdapter> newResult = new ArrayList<ParserDependencyNodeAdapter>();
                for (ParserDependencyNodeAdapter n : result) {
                    LogicalNamespace from = (LogicalNamespace)n.getUnderlyingObject();
                    List<LogicalNamespace> targets = this.m_removedEdges.get(from);
                    if (targets != null && targets.contains(target)) continue;
                    newResult.add(n);
                }
                result = newResult;
            }
            return result;
        }

        public Collection<ParserDependencyNodeAdapter> getOutgoing(ParserDependencyNodeAdapter node) {
            List<ParserDependencyNodeAdapter> result = node.getOutgoingEdges().stream().map(e -> (ParserDependencyNodeAdapter)e.getTo()).toList();
            if (!this.m_removedEdges.isEmpty()) {
                LogicalNamespace from = (LogicalNamespace)node.getUnderlyingObject();
                ArrayList<ParserDependencyNodeAdapter> newResult = new ArrayList<ParserDependencyNodeAdapter>();
                List<LogicalNamespace> targets = this.m_removedEdges.get(from);
                for (ParserDependencyNodeAdapter n : result) {
                    LogicalNamespace to = (LogicalNamespace)n.getUnderlyingObject();
                    if (targets != null && targets.contains(to)) continue;
                    newResult.add(n);
                }
                result = newResult;
            }
            return result;
        }

        public void setIsCyclic(ParserDependencyNodeAdapter node, int cycleIndex) {
            assert (!this.m_isSortingCyclicNodes) : "No cycles expected after breaking cyclic edges";
            Integer index = cycleIndex;
            List<ModulithModule> cycleGroup = this.m_cycleGroups.get(index);
            if (cycleGroup == null) {
                cycleGroup = new ArrayList<ModulithModule>();
                this.m_cycleGroups.put(index, cycleGroup);
            }
            ModulithModule mod = this.m_moduleMap.get(node.getUnderlyingObject());
            assert (mod != null);
            cycleGroup.add(mod);
            this.m_cyclicNodes.add(mod);
            this.m_cycleIndexMap.put(mod, index);
        }

        public void setLevel(ParserDependencyNodeAdapter node, int level) {
            LogicalNamespace pkg = (LogicalNamespace)node.getUnderlyingObject();
            if (this.m_isSortingCyclicNodes) {
                this.m_cycleLevelMap.put(this.m_moduleMap.get(pkg), level);
            } else {
                this.m_levelMap.put(this.m_moduleMap.get(pkg), level);
            }
        }

        int getModuleLevel(ModulithModule module) {
            Integer cycleIndex;
            Integer val = this.m_levelMap.get(module);
            assert (val != null);
            int result = val * 10000;
            if (module.isShared()) {
                --result;
            }
            if ((cycleIndex = this.m_cycleIndexMap.get(module)) != null) {
                result -= 100 * cycleIndex;
                result += this.m_cycleLevelMap.get(module).intValue();
            }
            return result;
        }

        void changeMode(boolean isSortingCyclicNodes) {
            this.m_isSortingCyclicNodes = isSortingCyclicNodes;
        }

        boolean hasCycles() {
            return !this.m_cyclicNodes.isEmpty();
        }

        void reset() {
            this.m_isSortingCyclicNodes = false;
            this.m_cycleGroups.clear();
            this.m_cyclicNodes.clear();
            this.m_cycleIndexMap.clear();
            this.m_cycleLevelMap.clear();
        }

        Collection<List<ModulithModule>> getCycleGroups() {
            return this.m_cycleGroups.values();
        }

        void addRemovedEdge(LogicalNamespace from, LogicalNamespace to) {
            List<LogicalNamespace> targets = this.m_removedEdges.get(from);
            if (targets == null) {
                targets = new ArrayList<LogicalNamespace>();
                this.m_removedEdges.put(from, targets);
            }
            targets.add(to);
        }
    }

    private static class FASAdapter
    implements IFeedbackArcSetAdapter {
        private final ParserDependencyNodeAdapterSet m_nodeAdapterSet;
        private final Map<LogicalNamespace, List<LogicalNamespace>> m_allowedDependencies;
        private final CycleAndLevelAdapter m_adapter;

        public FASAdapter(ParserDependencyNodeAdapterSet nodeAdapterSet, Map<LogicalNamespace, List<LogicalNamespace>> allowedDependencies, CycleAndLevelAdapter adapter) {
            this.m_nodeAdapterSet = nodeAdapterSet;
            this.m_allowedDependencies = allowedDependencies;
            this.m_adapter = adapter;
        }

        public Collection<? extends INode<?>> getNodes() {
            return this.m_nodeAdapterSet.getNodes();
        }

        public boolean calculateAdditionalInformation() {
            return false;
        }

        public IFeedbackArcSetAdapter.EdgeHint getHint(INode.IEdge edge) {
            LogicalNamespace to;
            LogicalNamespace from = (LogicalNamespace)edge.getFrom().getUnderlyingObject();
            List<LogicalNamespace> allowedConnections = this.m_allowedDependencies.get(from);
            if (allowedConnections != null && !allowedConnections.isEmpty() && allowedConnections.contains(to = (LogicalNamespace)edge.getTo().getUnderlyingObject())) {
                return IFeedbackArcSetAdapter.EdgeHint.KEEP_IF_POSSIBLE;
            }
            return IFeedbackArcSetAdapter.EdgeHint.NONE;
        }

        public void feedbackArcSet(FeedbackArcSetInfo info, Set<INode.IEdge> feedbackArcSet, Set<INode.IEdge> notKeptEdges) {
            for (INode.IEdge edge : feedbackArcSet) {
                this.m_adapter.addRemovedEdge((LogicalNamespace)edge.getFrom().getUnderlyingObject(), (LogicalNamespace)edge.getTo().getUnderlyingObject());
                edge.remove();
            }
        }
    }

    private class JavaTypeFinder
    extends NamedElementVisitor
    implements External.IVisitor,
    JavaType.IVisitor {
        private final String m_name;
        private JavaType m_result = null;

        JavaTypeFinder(String name) {
            this.m_name = name;
        }

        public boolean done() {
            return this.m_result != null;
        }

        @Override
        public void visitJavaType(JavaType element) {
            if (element.getName().equals(this.m_name)) {
                this.m_result = element;
            }
        }

        public void visitExternal(External element) {
        }
    }

    private static enum ModulithMessageCause implements OperationResult.IMessageCause
    {
        UNEXPECTED_FORMAT,
        UNKNOWN_BASE_PACKAGE,
        UNKNOWN_MODULE,
        UNKNOWN_TYPE,
        UNKNOWN_NAMED_INTERFACE,
        OLD_MODULITH_VERSION,
        EXCEPTION_WHILE_READING_JSON_FILE;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static class ModulithModule {
        private final String m_name;
        private String m_displayName;
        private boolean m_isOpen;
        private boolean m_isShared;
        private JavaPackageFragment m_root;
        private ModulithModule m_parent;
        private final List<ModulithModule> m_children = new ArrayList<ModulithModule>();
        private final List<NamedInterface> m_namedInterfaces = new ArrayList<NamedInterface>();
        private final List<String> m_allowedDependencies = new ArrayList<String>();
        private final List<NamedInterface> m_allowedConnections = new ArrayList<NamedInterface>();
        private final List<NamedInterface> m_implicitConnections = new ArrayList<NamedInterface>();
        private boolean m_createSharedModule = false;

        ModulithModule(String name) {
            this.m_name = name;
        }

        String getDisplayName() {
            return this.m_displayName;
        }

        String getFqn() {
            StringBuilder sb = new StringBuilder();
            if (this.m_parent != null) {
                sb.append(this.m_parent.getFqn()).append(".");
            }
            sb.append(this.m_displayName);
            return sb.toString();
        }

        void setDisplayName(String displayName) {
            this.m_displayName = displayName;
        }

        boolean hasChildren() {
            return !this.m_children.isEmpty();
        }

        public boolean isCreateSharedModule() {
            return this.m_createSharedModule;
        }

        public void setCreateSharedModule(boolean createSharedModule) {
            this.m_createSharedModule = createSharedModule;
        }

        boolean isOpen() {
            return this.m_isOpen;
        }

        void setOpen(boolean isOpen) {
            this.m_isOpen = isOpen;
        }

        public boolean isShared() {
            return this.m_isShared;
        }

        public void setShared(boolean isShared) {
            this.m_isShared = isShared;
        }

        String getName() {
            return this.m_name;
        }

        JavaPackageFragment getRoot() {
            return this.m_root;
        }

        void setRoot(JavaPackageFragment root) {
            this.m_root = root;
        }

        void addChild(ModulithModule child) {
            assert (child != null && child != this);
            child.setParent(this);
            this.m_children.add(child);
        }

        boolean isTopLevel() {
            return this.m_parent == null;
        }

        void setParent(ModulithModule parent) {
            this.m_parent = parent;
        }

        List<ModulithModule> getChildren() {
            return this.m_children;
        }

        void addNamedInterface(NamedInterface namedInterface) {
            this.m_namedInterfaces.add(namedInterface);
        }

        List<NamedInterface> getNamedInterfaces() {
            return this.m_namedInterfaces;
        }

        void addAllowedDependency(String name) {
            this.m_allowedDependencies.add(name);
        }

        List<String> getAllowedDependencies() {
            return this.m_allowedDependencies;
        }

        ModulithModule getChildByName(String name) {
            return this.m_children.stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
        }

        NamedInterface getNamedInterfaceByName(String name) {
            return this.m_namedInterfaces.stream().filter(ni -> ni.getName().equals(name)).findFirst().orElse(null);
        }

        boolean hasAllowedDependencies() {
            return !this.m_allowedDependencies.isEmpty();
        }

        List<JavaType> getTypesExcludedFromDefaultInterface() {
            ArrayList<JavaType> result = new ArrayList<JavaType>();
            for (NamedInterface ni : this.m_namedInterfaces) {
                if (ni.getName().equals("default")) continue;
                result.addAll(ni.getTypes());
            }
            return result;
        }

        void addAllowedConnection(NamedInterface ni) {
            this.m_allowedConnections.add(ni);
        }

        List<NamedInterface> getAllowedConnections() {
            return this.m_allowedConnections;
        }

        Set<ModulithModule> getExplicitelyAndImplicitelyConnectedModules() {
            THashSet result = new THashSet(this.m_allowedConnections.stream().map(ni -> ni.getModule()).toList());
            result.addAll(this.m_implicitConnections.stream().map(ni -> ni.getModule()).toList());
            return result;
        }

        void addImplicitConnection(NamedInterface ni) {
            this.m_implicitConnections.add(ni);
        }

        public String toString() {
            return this.m_displayName;
        }
    }

    private static class NamedInterface {
        private final ModulithModule m_module;
        private final String m_name;
        private final List<JavaType> m_types = new ArrayList<JavaType>();

        public NamedInterface(ModulithModule module, String name) {
            this.m_module = module;
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public void addType(JavaType type) {
            this.m_types.add(type);
        }

        public List<JavaType> getTypes() {
            return this.m_types;
        }

        public String getFqn() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.m_module.getFqn());
            if (!this.m_name.equals("default")) {
                sb.append('.').append(this.m_name);
            }
            return sb.toString();
        }

        public ModulithModule getModule() {
            return this.m_module;
        }
    }

    private class PackageFragmentFinder
    extends NamedElementVisitor
    implements External.IVisitor,
    JavaPackageFragment.IVisitor {
        private final String m_name;
        private JavaPackageFragment m_result = null;

        PackageFragmentFinder(String name) {
            this.m_name = name;
        }

        public boolean done() {
            return this.m_result != null;
        }

        @Override
        public void visitJavaPackageFragment(JavaPackageFragment element) {
            if (element.getName().equals(this.m_name)) {
                this.m_result = element;
            } else {
                this.visitChildrenOf((NamedElement)element);
            }
        }

        public void visitExternal(External element) {
        }
    }

    private static class Validator
    implements ITextValidator {
        private Validator() {
        }

        public ValidationResult isValid(String currentInput, String newInput) {
            ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
            if (!FileUtility.isValidName((String)newInput)) {
                result.addError("Architecture file name is not valid");
            }
            if (newInput.contains(".")) {
                result.addError("Architecture file name cannot have an extension");
            }
            if (newInput.isBlank()) {
                result.addError("Name cannot be empty");
            }
            return result;
        }
    }
}

