/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.report;

import com.hello2morrow.sonargraph.core.persistence.report.ReportCancelledException;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import javax.xml.bind.Marshaller;

final class MarshallListener
extends Marshaller.Listener {
    private final IWorkerContext m_workerContext;
    private final int m_maxWorkItemsToReport;
    private int m_workItemsFinished;

    MarshallListener(IWorkerContext workerContext, int maxWorkItemsToReport) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'MarschallListener' must not be null";
        assert (maxWorkItemsToReport > 0) : "'maxWorkItemsToReport' must not be 0 or less: " + maxWorkItemsToReport;
        this.m_workerContext = workerContext;
        this.m_maxWorkItemsToReport = maxWorkItemsToReport;
        this.m_workerContext.beginBlockOfWork(maxWorkItemsToReport);
    }

    public void beforeMarshal(Object source) {
        if (this.m_workerContext.hasBeenCanceled()) {
            throw new ReportCancelledException();
        }
        ++this.m_workItemsFinished;
    }

    public void afterMarshal(Object source) {
        if (this.m_workerContext.hasBeenCanceled()) {
            throw new ReportCancelledException();
        }
        if (this.m_workItemsFinished <= this.m_maxWorkItemsToReport) {
            this.m_workerContext.workItemCompleted();
        }
    }
}

