/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IParserLogEntry;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import java.io.IOException;

public class ParserLogEntry
extends NamedElement
implements IParserLogEntry {
    private String m_severity;
    private String m_message;
    private int m_lineNumber;

    public ParserLogEntry(NamedElement parent) {
        super(parent);
    }

    public ParserLogEntry(NamedElement parent, String severity, String message, int lineNumber) {
        super(parent);
        assert (parent != null) : "Parameter 'source' of method 'ParserLogEntry' must not be null";
        assert (severity != null) : "Parameter 'severity' of method 'ParserLogEntry' must not be null";
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'ParserLogEntry' must not be empty";
        this.m_severity = severity;
        this.m_message = message;
        this.m_lineNumber = lineNumber;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_severity);
        writer.writeString(this.m_message);
        writer.writeInt(this.m_lineNumber);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_severity = reader.readString();
        this.m_message = reader.readString();
        this.m_lineNumber = reader.readInt();
    }

    @Override
    public String getShortName() {
        return "ParserLogIssue" + this.hashCode();
    }

    @Override
    public SourceFile getSource() {
        return this.getParent(SourceFile.class, new Class[0]);
    }

    @Override
    public String getMessage() {
        return this.m_message;
    }

    @Override
    public String getSeverity() {
        return this.m_severity;
    }

    @Override
    public int getLineNumber() {
        return this.m_lineNumber;
    }
}

