/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.common;

import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

public final class FormatterOptions {
    public static final BracesPlacement DEFAULT_BRACES_STRAT = BracesPlacement.NEXT_LINE;
    public static final BracesPlacement DEFAULT_BRACES_END = BracesPlacement.NEXT_LINE;
    public static final boolean DEFAULT_INDENT_EMPTY_LINES = false;
    public static final boolean DEFAULT_USE_TABS = false;
    public static final int DEFAULT_TAB_SIZE = 4;
    private BracesPlacement m_bracesStart;
    private BracesPlacement m_bracesEnd;
    private boolean m_indentEmptyLines;
    private boolean m_useTabs;
    private int m_tabSize;

    public FormatterOptions() {
        this.m_bracesStart = DEFAULT_BRACES_STRAT;
        this.m_bracesEnd = DEFAULT_BRACES_END;
        this.m_indentEmptyLines = false;
        this.m_useTabs = false;
        this.m_tabSize = 4;
    }

    public FormatterOptions(boolean useTabs, int tabSize) {
        assert (tabSize > 0) : "Invalid tab size: " + tabSize;
        this.m_bracesStart = DEFAULT_BRACES_STRAT;
        this.m_bracesEnd = DEFAULT_BRACES_END;
        this.m_indentEmptyLines = false;
        this.m_useTabs = useTabs;
        this.m_tabSize = tabSize;
    }

    public FormatterOptions(BracesPlacement bracesEnd, BracesPlacement bracesStart, boolean indentEmptyLines, boolean useTabs, int tabSize) {
        assert (bracesStart != null) : "Parameter 'bracesStart' of method 'FormatterOptions' must not be null";
        assert (bracesEnd != null) : "Parameter 'bracesEnd' of method 'FormatterOptions' must not be null";
        assert (tabSize > 0) : "Invalid tab size: " + tabSize;
        this.m_bracesStart = bracesStart;
        this.m_bracesEnd = bracesEnd;
        this.m_indentEmptyLines = indentEmptyLines;
        this.m_useTabs = useTabs;
        this.m_tabSize = tabSize;
    }

    public String getLineBreak() {
        return StringUtility.DEFAULT_LINE_SEPARATOR;
    }

    public void setBracesStart(BracesPlacement bracesStart) {
        assert (bracesStart != null) : "Parameter 'bracesStart' of method 'setBracesStart' must not be null";
        this.m_bracesStart = bracesStart;
    }

    public BracesPlacement getBracesStart() {
        return this.m_bracesStart;
    }

    public void setBracesEnd(BracesPlacement bracesEnd) {
        assert (bracesEnd != null) : "Parameter 'bracesEnd' of method 'setBracesEnd' must not be null";
        this.m_bracesEnd = bracesEnd;
    }

    public BracesPlacement getBracesEnd() {
        return this.m_bracesEnd;
    }

    public void setIndentEmptyLines(boolean indentEmptyLines) {
        this.m_indentEmptyLines = indentEmptyLines;
    }

    public boolean isIndentEmptyLines() {
        return this.m_indentEmptyLines;
    }

    public void setUseTabs(boolean useTabs) {
        this.m_useTabs = useTabs;
    }

    public boolean useTabs() {
        return this.m_useTabs;
    }

    public void setTabSize(int tabSize) {
        assert (tabSize > 0) : "Invalid tab size: " + tabSize;
        this.m_tabSize = tabSize;
    }

    public int getTabSize() {
        return this.m_tabSize;
    }

    public static enum BracesPlacement {
        NEXT_LINE,
        SAME_LINE;

    }
}

