/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecturediagram;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IUmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IUmlComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentConnector;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentInterface;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class ArchitectureDiagramRepresentation
extends NamedElementContainer
implements IUmlComponentContainer {
    private final Map<UmlComponentConnector, Set<UmlComponentInterface>> m_connectorToInterfaces = new THashMap();
    private final Map<UmlComponentInterface, Set<UmlComponentConnector>> m_interfaceToConnector = new THashMap();
    private final Comparator<UmlComponentAnchor<?>> m_comparator;
    private final ArchitectureFile m_architectureFile;
    private boolean m_isValid = true;

    public ArchitectureDiagramRepresentation(NamedElement parent, Comparator<UmlComponentAnchor<?>> comparator, ArchitectureFile file) {
        super(parent);
        assert (comparator != null) : "Parameter 'comparator' of method 'ArchitectureDiagramRepresentation' must not be null";
        assert (file != null) : "Parameter 'file' of method 'ArchitectureDiagramRepresentation' must not be null";
        this.m_comparator = comparator;
        this.m_architectureFile = file;
    }

    public ArchitectureFile getArchitectureFile() {
        return this.m_architectureFile;
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    @Override
    public String getShortName() {
        return "Architecture diagram of '" + this.m_architectureFile.getIdentifyingPath() + "'";
    }

    public void setInvalid() {
        this.m_isValid = false;
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public void addChild(NamedElement child) {
        assert (child != null && child instanceof IUmlComponent) : "Unexpected class in method 'addChild': " + String.valueOf(child);
        super.addChild(child);
    }

    @Override
    public void sortComponents(Comparator<IUmlComponent> comparator) {
        assert (comparator != null) : "Parameter 'comparator' of method 'sortComponents' must not be null";
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null && !children.isEmpty()) {
            Collections.sort(children, comparator);
            this.finishModification();
        }
    }

    public void addAllowedInterface(UmlComponentConnector connector, UmlComponentInterface allowedInterface) {
        assert (connector != null) : "Parameter 'connector' of method 'addAllowedInterface' must not be null";
        assert (allowedInterface != null) : "Parameter 'allowedInterface' of method 'addAllowedInterface' must not be null";
        Set<UmlComponentInterface> allowedInterfaces = this.m_connectorToInterfaces.get(connector);
        if (allowedInterfaces == null) {
            allowedInterfaces = new TreeSet(this.m_comparator);
            this.m_connectorToInterfaces.put(connector, allowedInterfaces);
        }
        allowedInterfaces.add(allowedInterface);
        Set<UmlComponentConnector> connectors = this.m_interfaceToConnector.get(allowedInterface);
        if (connectors == null) {
            connectors = new TreeSet(this.m_comparator);
            this.m_interfaceToConnector.put(allowedInterface, connectors);
        }
        connectors.add(connector);
    }

    public Set<UmlComponentInterface> getAllowedInterfaces(UmlComponentConnector connector) {
        assert (connector != null) : "Parameter 'connector' of method 'getAllowedInterfaces' must not be null";
        Set<UmlComponentInterface> interfaces = this.m_connectorToInterfaces.get(connector);
        return interfaces != null ? Collections.unmodifiableSet(interfaces) : Collections.emptySet();
    }

    public Set<UmlComponentConnector> getAllowedConnectors(UmlComponentInterface inter) {
        assert (inter != null) : "Parameter 'inter' of method 'getAllowedConnectors' must not be null";
        Set<UmlComponentConnector> connectors = this.m_interfaceToConnector.get(inter);
        return connectors != null ? Collections.unmodifiableSet(connectors) : Collections.emptySet();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArchitectureDiagramRepresentation(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArchitectureDiagramRepresentation(ArchitectureDiagramRepresentation var1);
    }
}

