/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.InterfaceConnection;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Connector
extends ArchitectureElement {
    private final Set<InterfaceConnection> m_connectedInterfaces = new LinkedHashSet<InterfaceConnection>();
    private final List<Connector> m_includedConnectors = new ArrayList<Connector>();
    private final List<Connector> m_includedByConnectors = new ArrayList<Connector>();
    private final boolean m_isAutoDefined;
    private final boolean m_isOptional;
    private List<Connector> m_includedByConnectorsRecursively;
    private Set<InterfaceConnection> m_interfaceConnections;
    private Set<IAssignableToArtifact> m_allAssignedElements;

    public Connector(NamedElement parent, String name, FilePath definingFile, int line, boolean autoDefined, boolean isOptional) {
        super(parent, name, definingFile, line);
        this.m_isAutoDefined = autoDefined;
        this.m_isOptional = isOptional;
    }

    public Connector(NamedElement parent, Connector other) {
        super(parent, other);
        this.m_isAutoDefined = other.m_isAutoDefined;
        this.m_isOptional = other.m_isOptional;
    }

    public void finishCloning(Connector original, Map<NamedElement, NamedElement> cloneMap) {
        for (InterfaceConnection conn2 : original.m_connectedInterfaces) {
            Interface cloned = (Interface)cloneMap.get(conn2.getTargetInterface());
            if (cloned == null) continue;
            this.m_connectedInterfaces.add(new InterfaceConnection(conn2.isCycleReleveant(), conn2.isDeprecated(), cloned));
        }
        original.m_includedConnectors.stream().map(conn -> (Connector)cloneMap.get(conn)).filter(conn -> conn != null).forEach(conn -> {
            boolean bl = this.m_includedConnectors.add((Connector)conn);
        });
        original.m_includedByConnectors.stream().map(conn -> (Connector)cloneMap.get(conn)).filter(conn -> conn != null).forEach(conn -> {
            boolean bl = this.m_includedByConnectors.add((Connector)conn);
        });
    }

    @Override
    public boolean isDefinedInEnclosingElement() {
        return !this.m_isAutoDefined;
    }

    @Override
    public boolean isAutoDefined() {
        return this.m_isAutoDefined;
    }

    @Override
    public boolean isOptional() {
        return this.m_isOptional;
    }

    public void connectTo(Interface iface, boolean isCycleRelevant, boolean isDeprecated) {
        assert (iface != null) : "Parameter 'iface' of method 'conectTo' must not be null";
        this.m_connectedInterfaces.add(new InterfaceConnection(isCycleRelevant, isDeprecated, iface));
    }

    public List<Connector> getIncludedConnectors() {
        return Collections.unmodifiableList(this.m_includedConnectors);
    }

    public List<Connector> getIncludedByConnectorsRecursively() {
        if (this.m_includedByConnectorsRecursively == null) {
            this.m_includedByConnectorsRecursively = new ArrayList<Connector>(this.m_includedByConnectors);
            this.m_includedByConnectors.forEach(c -> {
                boolean bl = this.m_includedByConnectorsRecursively.addAll(c.getIncludedByConnectorsRecursively());
            });
        }
        return this.m_includedByConnectorsRecursively;
    }

    public boolean connectsDirectlyToInterface(Interface iface) {
        return this.m_connectedInterfaces.stream().anyMatch(conn -> conn.getTargetInterface() == iface);
    }

    public Collection<Interface> getDirectlyConnectedInterfaces() {
        return this.m_connectedInterfaces.stream().map(conn -> conn.getTargetInterface()).collect(Collectors.toList());
    }

    public Collection<InterfaceConnection> getConnections() {
        if (this.m_interfaceConnections == null) {
            this.m_interfaceConnections = new LinkedHashSet<InterfaceConnection>(this.m_connectedInterfaces);
            for (Connector includedBy : this.getIncludedByConnectorsRecursively()) {
                this.m_interfaceConnections.addAll(includedBy.m_connectedInterfaces);
            }
        }
        return Collections.unmodifiableCollection(this.m_interfaceConnections);
    }

    public Collection<Interface> getConnectedCycleRelevantInterfaces() {
        return this.getConnections().stream().filter(conn -> conn.isCycleReleveant()).map(conn -> conn.getTargetInterface()).collect(Collectors.toSet());
    }

    public Collection<Interface> getConnectedInterfaces() {
        return this.getConnections().stream().map(conn -> conn.getTargetInterface()).collect(Collectors.toSet());
    }

    public void addIncludedConnector(Connector included) {
        assert (included != null) : "Parameter 'included' of method 'addIncludedConnector' must not be null";
        if (!this.m_includedConnectors.contains(included)) {
            this.m_includedConnectors.add(included);
            included.addIncludedByConnector(this);
        }
    }

    private void addIncludedByConnector(Connector includedBy) {
        this.m_includedByConnectors.add(includedBy);
        for (Connector included : this.m_includedConnectors) {
            included.addIncludedByConnector(includedBy);
        }
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.getShortName() + "(Connector)";
    }

    @Override
    public boolean isEmpty() {
        if (!super.isEmpty()) {
            return false;
        }
        for (Connector conn : this.m_includedConnectors) {
            if (conn.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.m_allAssignedElements = null;
        this.m_includedByConnectorsRecursively = null;
        this.m_interfaceConnections = null;
        super.clear();
    }

    @Override
    public Collection<IAssignableToArtifact> getAssignedElements() {
        if (this.m_allAssignedElements == null) {
            this.m_allAssignedElements = new THashSet();
            this.m_allAssignedElements.addAll(super.getAssignedElements());
            for (Connector conn : this.m_includedConnectors) {
                this.m_allAssignedElements.addAll(conn.getAssignedElements());
            }
        }
        return Collections.unmodifiableSet(this.m_allAssignedElements);
    }

    @Override
    public int getNumberOfAssignedElements() {
        return this.getAssignedElements().size();
    }

    @Override
    public void override(FilePath definingFile, int line) {
        this.m_includedConnectors.clear();
        this.m_includedByConnectors.clear();
        super.override(definingFile, line);
    }

    public boolean disconnect(Interface targetInterface) {
        return this.m_connectedInterfaces.removeIf(conn -> conn.getTargetInterface() == targetInterface);
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return true;
    }

    void reset() {
        this.m_includedConnectors.clear();
    }

    @Override
    public final void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitConnector(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitConnector(Connector var1);
    }
}

