/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureProviderId;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ArchitectureViolationIssueInfo
extends NamedElement {
    private static final String PROVIDER_IDS = "providerIds";
    private final Set<IProviderId> m_providerIds = new HashSet<IProviderId>();

    public ArchitectureViolationIssueInfo(NamedElement parent) {
        super(parent);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        List<String> idList = this.m_providerIds.stream().map(id -> id.getStandardName()).collect(Collectors.toList());
        String[] ids = idList.toArray(new String[idList.size()]);
        writer.writeStringArray(PROVIDER_IDS, ids);
        super.writeAttributes(writer);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        String[] ids;
        String[] stringArray = ids = reader.readStringArray(PROVIDER_IDS);
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.m_providerIds.add(new ArchitectureProviderId(id));
            ++n2;
        }
        super.readAttributes(reader);
    }

    @Override
    public String getShortName() {
        return "Architecture Violation Issue Info";
    }

    public void addIssueProviderId(IProviderId id) {
        assert (id != null) : "Parameter 'id' of method 'addIssueProviderId' must not be null";
        this.m_providerIds.add(id);
    }

    public Set<IProviderId> getProviderIds() {
        return Collections.unmodifiableSet(this.m_providerIds);
    }
}

