/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfo;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfoEQClass;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ISingleIssueProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.text.Levenshtein;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class DuplicateCodeBlock
extends NamedElementContainer
implements ISingleIssueProvider {
    private static final String FQ_NAME_PART = "fqNamePart";
    private static final String SIMPLE_ID = "simpleId";
    private static final String DUPLICATE_BLOCK_INFO = "duplicateBlockInfo";
    private DuplicateBlockInfoEQClass m_duplicateBlockInfoEQClass;
    private int m_simpleId;
    private String m_fqNamePart;

    public DuplicateCodeBlock(NamedElement parent) {
        super(parent);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeOwnedObject(DUPLICATE_BLOCK_INFO, (IPersistable)this.m_duplicateBlockInfoEQClass);
        writer.writeInt(SIMPLE_ID, this.m_simpleId);
        writer.writeString(FQ_NAME_PART, this.m_fqNamePart);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_duplicateBlockInfoEQClass = (DuplicateBlockInfoEQClass)reader.readOwnedObject(DUPLICATE_BLOCK_INFO, DuplicateBlockInfoEQClass.class);
        this.m_simpleId = reader.readInt(SIMPLE_ID);
        this.m_fqNamePart = reader.readString(FQ_NAME_PART);
    }

    public DuplicateCodeBlock(NamedElement parent, DuplicateBlockInfoEQClass duplicateBlockInfoEQClass, int simpleId) {
        super(parent);
        assert (duplicateBlockInfoEQClass != null) : "Parameter 'duplicateBlockInfoEQClass' of method 'DuplicateCodeBlock' must not be null";
        this.m_duplicateBlockInfoEQClass = duplicateBlockInfoEQClass;
        this.m_simpleId = simpleId;
    }

    @Override
    public String getShortName() {
        StringBuilder builder = new StringBuilder();
        if (this.getLanguage() != null) {
            builder.append(this.getLanguage().getPresentationName()).append(" ");
        }
        builder.append("Duplicate code block ");
        builder.append(this.m_simpleId);
        return builder.toString();
    }

    public int getBlockSize() {
        return this.m_duplicateBlockInfoEQClass.getLineCount();
    }

    public int getBlockSizeWithoutIgnored() {
        return this.m_duplicateBlockInfoEQClass.getLineCountWithoutIgnored();
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public int getTotalNumberOfOccurrences() {
        return this.m_duplicateBlockInfoEQClass.getElements().size();
    }

    public int getDuplicatedLineCount() {
        int biggestBlockSize = 0;
        int totalDuplicatedLines = 0;
        for (DuplicateBlockInfo info : this.m_duplicateBlockInfoEQClass.getElements()) {
            int matchedLineCount = info.getMatchedLineCount();
            totalDuplicatedLines += matchedLineCount;
            if (matchedLineCount <= biggestBlockSize) continue;
            biggestBlockSize = matchedLineCount;
        }
        return totalDuplicatedLines - biggestBlockSize;
    }

    public int getTotalDuplicateLineCount() {
        return this.getChildren(DuplicateCodeBlockOccurrence.class).stream().mapToInt(occ -> occ.getBlockSize()).sum();
    }

    public int getSimpleId() {
        return this.m_simpleId;
    }

    public String createIssueDescription() {
        List<DuplicateCodeBlockOccurrence> occurrences = this.getChildren(DuplicateCodeBlockOccurrence.class);
        List<String> involvedFiles = this.getFullyQualifiedNamesOfInvolvedElements();
        return occurrences.size() + " occurrences with " + this.getBlockSize() + " line(s) found in " + involvedFiles.size() + " file(s)";
    }

    public List<String> getFullyQualifiedNamesOfInvolvedElements() {
        ArrayList<String> fqNames = new ArrayList<String>();
        HashSet<SourceFile> inFiles = new HashSet<SourceFile>();
        for (DuplicateCodeBlockOccurrence nextOccurrence : this.getChildren(DuplicateCodeBlockOccurrence.class)) {
            SourceFile nextSourceFile = nextOccurrence.getSourceFile();
            if (!inFiles.add(nextSourceFile)) continue;
            fqNames.add(nextSourceFile.getFullyQualifiedName());
        }
        Collections.sort(fqNames);
        return fqNames;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        if (this.m_fqNamePart == null) {
            StringBuilder componentsFqNames = new StringBuilder();
            for (String next : this.getFullyQualifiedNamesOfInvolvedElements()) {
                componentsFqNames.append(next);
            }
            ArrayList<DuplicateCodeBlockOccurrence> occurrences = new ArrayList<DuplicateCodeBlockOccurrence>(this.getChildren(DuplicateCodeBlockOccurrence.class));
            Collections.sort(occurrences, new Comparator<DuplicateCodeBlockOccurrence>(){

                @Override
                public int compare(DuplicateCodeBlockOccurrence o1, DuplicateCodeBlockOccurrence o2) {
                    return o1.getShortName().compareTo(o2.getShortName());
                }
            });
            StringBuilder contentHashes = new StringBuilder();
            for (DuplicateCodeBlockOccurrence next : occurrences) {
                contentHashes.append(next.getBlockHash());
            }
            this.m_fqNamePart = HashSupport.MD5.getHexString(componentsFqNames.toString()) + Element.INNER_NAME_PARTS_SEPARATOR + HashSupport.MD5.getHexString(contentHashes.toString());
        }
        return this.m_fqNamePart;
    }

    public static String removeFullyQualifiedNamePartFromHash(String fqName) {
        String hashPart;
        int posHashPart;
        assert (fqName != null && fqName.length() > 0) : "Parameter 'fqName' of method 'removeFullyQualifiedNamePartFromHash' must not be empty";
        int pos = fqName.lastIndexOf(58);
        if (pos != -1 && (posHashPart = (hashPart = fqName.substring(pos + 1)).lastIndexOf(124)) != -1) {
            String contentMD5 = hashPart.substring(posHashPart + 1);
            return fqName.substring(0, pos + 1) + contentMD5;
        }
        return fqName;
    }

    public static String translateHashPart(String hashPart, List<String> translatedFullyQualifiedNamesOfInvolvedElements) {
        assert (hashPart != null && hashPart.length() > 0) : "Parameter 'hashPart' of method 'translateHashPart' must not be empty";
        assert (translatedFullyQualifiedNamesOfInvolvedElements != null && !translatedFullyQualifiedNamesOfInvolvedElements.isEmpty()) : "Parameter 'translatedFullyQualifiedNamesOfInvolvedElements' of method 'translateHashPart' must not be empty";
        int pos = hashPart.lastIndexOf(124);
        if (pos != -1) {
            String contentMD5 = hashPart.substring(pos + 1);
            ArrayList<String> fqNames = new ArrayList<String>(translatedFullyQualifiedNamesOfInvolvedElements);
            Collections.sort(fqNames);
            StringBuilder componentsFqNames = new StringBuilder();
            for (String next : fqNames) {
                componentsFqNames.append(next);
            }
            return HashSupport.MD5.getHexString(componentsFqNames.toString()) + Element.INNER_NAME_PARTS_SEPARATOR + contentMD5;
        }
        return hashPart;
    }

    @Override
    public Issue getAssociatedIssue() {
        List<Issue> issues = this.getIssues();
        return issues.size() == 1 ? issues.get(0) : null;
    }

    public StrictPair<String, Double> getMatchingInfoSummary() {
        StringBuilder result = new StringBuilder(this.getPresentationName(true));
        result.append(", occurrences: ").append(this.getTotalNumberOfOccurrences()).append(", block size (without ignored): ").append(this.getBlockSizeWithoutIgnored()).append("\n");
        double biggestDifferenceRatio = 0.0;
        List<DuplicateCodeBlockOccurrence> occurrences = this.getChildren(DuplicateCodeBlockOccurrence.class);
        for (DuplicateCodeBlockOccurrence occ : occurrences) {
            result.append("\t");
            StrictPair<Double, Integer> similarityPair = this.getDistance(occ, occurrences);
            int toleranceAsInt = occ.getToleranceAsInt();
            int diff = Math.abs((Integer)similarityPair.getSecond() - toleranceAsInt);
            if (toleranceAsInt != (Integer)similarityPair.getSecond()) {
                double differenceRatio = (double)diff / (double)occ.getBlockSizeWithoutIgnored();
                result.append("DIFFERENT (ratio: ").append(differenceRatio).append("):  ");
                if (Double.compare(differenceRatio, biggestDifferenceRatio) > 0) {
                    biggestDifferenceRatio = differenceRatio;
                }
            }
            result.append(occ.getPresentationName(true)).append(", tolerance: ").append(toleranceAsInt).append(", distance: ").append(similarityPair.getSecond());
            result.append("\n");
        }
        return new StrictPair((Object)result.toString(), (Object)biggestDifferenceRatio);
    }

    private StrictPair<Double, Integer> getDistance(DuplicateCodeBlockOccurrence occ, List<DuplicateCodeBlockOccurrence> allOccurrences) {
        assert (occ != null) : "Parameter 'occ' of method 'getDistance' must not be null";
        assert (allOccurrences != null && !allOccurrences.isEmpty()) : "Parameter 'allOccurrences' of method 'getDistance' must not be empty";
        int minDistance = Integer.MAX_VALUE;
        StrictPair bestMatch = null;
        for (DuplicateCodeBlockOccurrence next : allOccurrences) {
            StrictPair similarity;
            int distance;
            if (next == occ || (distance = ((Integer)(similarity = Levenshtein.similarity((IntBasedHash)occ.getHashRepresentation(), (IntBasedHash)next.getHashRepresentation())).getSecond()).intValue()) >= minDistance) continue;
            minDistance = distance;
            bestMatch = similarity;
        }
        return bestMatch;
    }

    public Set<IntBasedHash> getOccurrenceHashs() {
        return this.getChildren(DuplicateCodeBlockOccurrence.class).stream().map(occ -> occ.getHashRepresentation()).filter(hash -> hash != null).collect(Collectors.toSet());
    }

    public List<StrictPair<String, IntBasedHash>> getOccurrenceNamesAndHashs() {
        ArrayList<StrictPair<String, IntBasedHash>> result = new ArrayList<StrictPair<String, IntBasedHash>>();
        for (DuplicateCodeBlockOccurrence next : this.getChildren(DuplicateCodeBlockOccurrence.class)) {
            result.add((StrictPair<String, IntBasedHash>)new StrictPair((Object)next.getSourceFile().getFullyQualifiedName(), (Object)next.getHashRepresentation()));
        }
        return result;
    }
}

